/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.tx.OTxMetadataHolder;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.exception.OTxPromiseException;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.TxContextStatus;
import com.orientechnologies.orient.server.distributed.impl.lock.OTxPromise;
import com.orientechnologies.orient.server.distributed.impl.lock.OTxPromiseManager;
import com.orientechnologies.orient.server.distributed.task.ODistributedKeyLockedException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ONewDistributedTxContextImpl
implements ODistributedTxContext {
    private final ODistributedDatabaseImpl shared;
    private final ODistributedRequestId id;
    private final OTransactionInternal tx;
    private final long startedOn;
    private final Set<OTxPromise<ORID>> promisedRids = new HashSet<OTxPromise<ORID>>();
    private final Set<OTxPromise<Object>> promisedKeys = new HashSet<OTxPromise<Object>>();
    private final OTransactionId transactionId;
    private TxContextStatus status;

    public ONewDistributedTxContextImpl(ODistributedDatabaseImpl shared, ODistributedRequestId reqId, OTransactionInternal tx, OTransactionId id) {
        this.shared = shared;
        this.id = reqId;
        this.tx = tx;
        this.startedOn = System.currentTimeMillis();
        this.transactionId = id;
    }

    public OTransactionId acquireIndexKeyPromise(Object key, int version, boolean force) {
        OTxPromiseManager<Object> promiseManager = this.shared.getIndexKeyPromiseManager();
        OTransactionId cancelledPromise = null;
        try {
            cancelledPromise = promiseManager.promise(key, version, this.transactionId, force);
        }
        catch (OTxPromiseException ex) {
            this.releasePromises();
            throw new ODistributedKeyLockedException(this.shared.getLocalNodeName(), key);
        }
        this.promisedKeys.add(new OTxPromise<Object>(key, version, this.transactionId));
        return cancelledPromise;
    }

    public OTransactionId acquirePromise(ORID rid, int version, boolean force) {
        OTxPromiseManager<ORID> promiseManager = this.shared.getRecordPromiseManager();
        OTransactionId cancelledPromise = null;
        try {
            cancelledPromise = promiseManager.promise(rid, version, this.transactionId, force);
        }
        catch (OTxPromiseException ex) {
            this.releasePromises();
            throw new ODistributedRecordLockedException(this.shared.getLocalNodeName(), rid);
        }
        this.promisedRids.add(new OTxPromise<ORID>(rid, version, this.transactionId));
        return cancelledPromise;
    }

    public ODistributedRequestId getReqId() {
        return this.id;
    }

    public synchronized void begin(ODatabaseDocumentInternal database, boolean local) {
        throw new UnsupportedOperationException();
    }

    public synchronized void commit(ODatabaseDocumentInternal database) {
        ODistributedDatabase localDistributedDatabase = ((ODatabaseDocumentDistributed)database).getDistributedShared();
        OTxMetadataHolder metadataHolder = localDistributedDatabase.commit(this.getTransactionId());
        try {
            this.tx.setMetadataHolder(Optional.of(metadataHolder));
            this.tx.prepareSerializedOperations();
            ((ODatabaseDocumentDistributed)database).internalCommit2pc(this);
        }
        catch (IOException e) {
            throw OException.wrapException((OException)((Object)new ODistributedException("Error on preparation of log serialized operations")), (Throwable)e);
        }
        finally {
            metadataHolder.notifyMetadataRead();
        }
    }

    public Set<ORecordId> rollback(ODatabaseDocumentInternal database) {
        return new HashSet<ORecordId>();
    }

    public void destroy() {
        this.releasePromises();
    }

    public void clearUndo() {
        throw new UnsupportedOperationException();
    }

    public void releasePromises() {
        this.shared.rollback(this.transactionId);
        for (OTxPromise<ORID> promise : this.promisedRids) {
            this.shared.getRecordPromiseManager().release(promise.getKey(), this.transactionId);
        }
        this.promisedRids.clear();
        for (OTxPromise<Object> promisedKey : this.promisedKeys) {
            this.shared.getIndexKeyPromiseManager().release(promisedKey.getKey(), this.transactionId);
        }
        this.promisedKeys.clear();
    }

    public long getStartedOn() {
        return this.startedOn;
    }

    public Set<ORecordId> cancel(ODistributedServerManager current, ODatabaseDocumentInternal database) {
        this.destroy();
        return null;
    }

    public OTransactionInternal getTransaction() {
        return this.tx;
    }

    public TxContextStatus getStatus() {
        return this.status;
    }

    public void setStatus(TxContextStatus status) {
        this.status = status;
    }

    public Set<OTxPromise<ORID>> getPromisedRids() {
        return this.promisedRids;
    }

    public Set<OTxPromise<Object>> getPromisedKeys() {
        return this.promisedKeys;
    }

    public OTransactionId getTransactionId() {
        return this.transactionId;
    }
}

