/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionUniqueKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class OTransactionOptimisticDistributed
extends OTransactionOptimistic {
    private List<ORecordOperation> changes;
    private Map<String, Map<Object, Integer>> keyVersions;

    public OTransactionOptimisticDistributed(ODatabaseDocumentInternal database, List<ORecordOperation> changes, SortedSet<OTransactionUniqueKey> uniqueIndexKeys) {
        super(database);
        this.changes = changes;
        this.keyVersions = new HashMap<String, Map<Object, Integer>>();
        for (OTransactionUniqueKey key : uniqueIndexKeys) {
            Map<Object, Integer> index = this.keyVersions.get(key.getIndex());
            if (index == null) {
                index = new HashMap<Object, Integer>();
                this.keyVersions.put(key.getIndex(), index);
            }
            index.put(key.getKey(), key.getVersion());
        }
    }

    public void begin() {
        super.begin();
        for (ORecordOperation change : this.changes) {
            this.allEntries.put(change.getRID(), change);
            this.resolveTracking(change);
        }
    }

    public void setDatabase(ODatabaseDocumentInternal database) {
        this.database = database;
    }

    public int getVersionForKey(String index, Object key) {
        Map<Object, Integer> indexKeys = this.keyVersions.get(index);
        assert (indexKeys != null);
        return indexKeys.get(key);
    }
}

