/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.lock;

import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.server.distributed.impl.lock.OIndexKeyLockKey;
import com.orientechnologies.orient.server.distributed.impl.lock.OLockGuard;
import com.orientechnologies.orient.server.distributed.impl.lock.OLockKey;
import com.orientechnologies.orient.server.distributed.impl.lock.OLockManager;
import com.orientechnologies.orient.server.distributed.impl.lock.ORIDLockKey;
import com.orientechnologies.orient.server.distributed.impl.lock.OResourceLockKey;
import com.orientechnologies.orient.server.distributed.impl.lock.OTransactionIdLockKey;
import com.orientechnologies.orient.server.distributed.impl.lock.OWaitingTracker;
import com.orientechnologies.orient.server.distributed.impl.lock.OnFreezeAcquired;
import com.orientechnologies.orient.server.distributed.impl.lock.OnLocksAcquired;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionUniqueKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;

public class OLockManagerImpl
implements OLockManager {
    private Map<OLockKey, Queue<OWaitingTracker>> locks = new ConcurrentHashMap<OLockKey, Queue<OWaitingTracker>>();
    private boolean frozen;
    private OnFreezeAcquired frozenLock;

    @Override
    public synchronized void freeze(OnFreezeAcquired frozenLock) {
        this.frozen = true;
        this.frozenLock = frozenLock;
        if (this.locks.isEmpty()) {
            this.frozenLock.acquired(() -> this.release());
        }
    }

    private synchronized void release() {
        this.frozen = false;
        this.frozenLock = null;
    }

    private void lock(OLockKey key, OWaitingTracker waitingTracker) {
        if (this.frozen) {
            throw new OOfflineNodeException("Node is offline");
        }
        Queue<OWaitingTracker> queue = this.locks.get(key);
        if (queue == null) {
            this.locks.put(key, new LinkedList());
        } else {
            queue.add(waitingTracker);
            waitingTracker.waitOne();
        }
    }

    private synchronized void unlock(OLockGuard guard) {
        Queue<OWaitingTracker> result = this.locks.get(guard.getKey());
        assert (result != null) : guard.getKey().toString();
        OWaitingTracker waiting = result.poll();
        if (waiting != null) {
            waiting.unlockOne();
        } else {
            this.locks.remove(guard.getKey());
        }
        if (this.frozen && this.locks.isEmpty()) {
            this.frozenLock.acquired(() -> this.release());
        }
    }

    @Override
    public synchronized void lock(SortedSet<ORID> rids, SortedSet<OTransactionUniqueKey> indexKeys, OTransactionId transactionId, OnLocksAcquired acquired) {
        OLockKey key;
        ArrayList<OLockGuard> guards = new ArrayList<OLockGuard>();
        OWaitingTracker waitingTracker = new OWaitingTracker(acquired);
        for (ORID rid : rids) {
            key = new ORIDLockKey(rid);
            this.lock(key, waitingTracker);
            guards.add(new OLockGuard(key));
        }
        for (OTransactionUniqueKey indexKey : indexKeys) {
            key = new OIndexKeyLockKey(indexKey.getIndex(), indexKey.getKey());
            this.lock(key, waitingTracker);
            guards.add(new OLockGuard(key));
        }
        OTransactionIdLockKey key2 = new OTransactionIdLockKey(transactionId);
        this.lock(key2, waitingTracker);
        guards.add(new OLockGuard(key2));
        waitingTracker.setGuards(guards);
        waitingTracker.acquireIfNoWaiting();
    }

    @Override
    public synchronized void unlock(List<OLockGuard> guards) {
        for (OLockGuard guard : guards) {
            this.unlock(guard);
        }
    }

    @Override
    public synchronized void lockResource(String name, OnLocksAcquired acquired) {
        OWaitingTracker waitingTracker = new OWaitingTracker(acquired);
        OResourceLockKey key = new OResourceLockKey(name);
        OLockGuard guard = new OLockGuard(key);
        this.lock(key, waitingTracker);
        waitingTracker.setGuards(Collections.singletonList(guard));
        waitingTracker.acquireIfNoWaiting();
    }
}

