/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.lock;

import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.server.distributed.exception.ODistributedTxPromiseRequestIsOldException;
import com.orientechnologies.orient.server.distributed.exception.OTxPromiseException;
import com.orientechnologies.orient.server.distributed.impl.lock.OTxPromise;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OTxPromiseManager<T> {
    private final Lock lock = new ReentrantLock();
    private final Map<T, OTxPromise<T>> map = new ConcurrentHashMap<T, OTxPromise<T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OTransactionId promise(T key, int version, OTransactionId txId, boolean force) {
        this.lock.lock();
        try {
            OTxPromise<T> p = this.map.get(key);
            if (p == null) {
                this.map.put(key, new OTxPromise<T>(key, version, txId));
                OTransactionId oTransactionId = null;
                return oTransactionId;
            }
            if (p.getTxId().equals((Object)txId)) {
                OTransactionId oTransactionId = null;
                return oTransactionId;
            }
            if (!force) {
                throw new OTxPromiseException(String.format("Cannot acquire promise for resource: '%s' v%d (existing version: %d)", key, version, p.getVersion()), version, p.getVersion());
            }
            OTransactionId cancelledPromise = null;
            if (version < p.getVersion()) {
                throw new ODistributedTxPromiseRequestIsOldException(String.format("Cannot force acquire promise for resource: '%s' v%d (existing version: %d)", key, version, p.getVersion()));
            }
            if (version > p.getVersion()) {
                throw new OTxPromiseException(String.format("Cannot force acquire promise for resource: '%s' v%d (existing version: %d)", key, version, p.getVersion()), version, p.getVersion());
            }
            cancelledPromise = p.getTxId();
            this.map.remove(key);
            this.map.put(key, new OTxPromise<T>(key, version, txId));
            OTransactionId oTransactionId = cancelledPromise;
            return oTransactionId;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T key, OTransactionId txId) {
        this.lock.lock();
        try {
            OTxPromise<T> p = this.map.get(key);
            if (p != null && p.getTxId().equals((Object)txId)) {
                this.map.remove(key);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.lock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public long size() {
        this.lock.lock();
        try {
            long l = this.map.size();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

