/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.metadata;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.metadata.OPropertyDistributed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class OClassDistributed
extends OClassEmbedded {
    private volatile int[] bestClusterIds;
    private volatile int lastVersion;

    protected OClassDistributed(OSchemaShared iOwner, String iName) {
        super(iOwner, iName);
    }

    public OClassDistributed(OSchemaShared iOwner, String iName, int[] iClusterIds) {
        super(iOwner, iName, iClusterIds);
    }

    public OClassDistributed(OSchemaShared iOwner, ODocument iDocument, String iName) {
        super(iOwner, iDocument, iName);
    }

    protected OPropertyImpl createPropertyInstance(ODocument p) {
        return new OPropertyDistributed((OClassImpl)this, p);
    }

    protected OPropertyEmbedded createPropertyInstance(OGlobalProperty global) {
        return new OPropertyDistributed((OClassImpl)this, global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProperty addProperty(String propertyName, OType type, OType linkedType, OClass linkedClass, boolean unsafe) {
        block13: {
            if (type == null) {
                throw new OSchemaException("Property type not defined.");
            }
            if (propertyName == null || propertyName.length() == 0) {
                throw new OSchemaException("Property name is null or empty");
            }
            ODatabaseDocumentInternal database = this.getDatabase();
            this.validatePropertyName(propertyName);
            if (database.getTransaction().isActive()) {
                throw new OSchemaException("Cannot create property '" + propertyName + "' inside a transaction");
            }
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
            if (linkedType != null) {
                OPropertyImpl.checkLinkTypeSupport((OType)type);
            }
            if (linkedClass != null) {
                OPropertyImpl.checkSupportLinkedClass((OType)type);
            }
            this.acquireSchemaWriteLock();
            try {
                if (this.isDistributedCommand(database)) {
                    StringBuilder cmd = new StringBuilder("create property ");
                    cmd.append('`');
                    cmd.append(this.name);
                    cmd.append('`');
                    cmd.append('.');
                    cmd.append('`');
                    cmd.append(propertyName);
                    cmd.append('`');
                    cmd.append(' ');
                    cmd.append(type.getName());
                    if (linkedType != null) {
                        cmd.append(' ');
                        cmd.append(linkedType.getName());
                    } else if (linkedClass != null) {
                        cmd.append(' ');
                        cmd.append('`');
                        cmd.append(linkedClass.getName());
                        cmd.append('`');
                    }
                    if (unsafe) {
                        cmd.append(" unsafe ");
                    }
                    this.owner.sendCommand(database, cmd.toString());
                    break block13;
                }
                OProperty oProperty = (OProperty)OScenarioThreadLocal.executeAsDistributed(() -> this.addPropertyInternal(propertyName, type, linkedType, linkedClass, unsafe));
                return oProperty;
            }
            finally {
                this.releaseSchemaWriteLock();
            }
        }
        return this.getProperty(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClassImpl setEncryption(String iValue) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` encryption %s", this.name, iValue);
                this.owner.sendCommand(database, cmd);
            } else {
                this.setEncryptionInternal(database, iValue);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass setClusterSelection(String value) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` clusterselection '%s'", this.name, value);
                this.owner.sendCommand(database, cmd);
            } else {
                this.setClusterSelectionInternal(value);
            }
            OClassDistributed oClassDistributed = this;
            return oClassDistributed;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClassImpl setCustom(String name, String value) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` custom `%s`=%s", this.getName(), name, value);
                this.owner.sendCommand(database, cmd);
            } else {
                this.setCustomInternal(name, value);
            }
            OClassDistributed oClassDistributed = this;
            return oClassDistributed;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    public void clearCustom() {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` custom clear", this.getName());
                this.owner.sendCommand(database, cmd);
            } else {
                this.clearCustomInternal();
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass setSuperClasses(List<? extends OClass> classes) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (classes != null) {
            ArrayList<? extends OClass> toCheck = new ArrayList<OClass>(classes);
            toCheck.add((OClass)this);
            OClassDistributed.checkParametersConflict(toCheck);
        }
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                StringBuilder sb = new StringBuilder();
                if (classes != null && classes.size() > 0) {
                    for (OClass oClass : classes) {
                        sb.append('`').append(oClass.getName()).append("`,");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                } else {
                    sb.append("null");
                }
                String cmd = String.format("alter class `%s` superclasses %s", this.name, sb);
                this.owner.sendCommand(database, cmd);
            } else {
                this.setSuperClassesInternal(classes);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass addSuperClass(OClass superClass) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.checkParametersConflict(superClass);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` superclass +`%s`", this.name, superClass != null ? superClass.getName() : null);
                this.owner.sendCommand(database, cmd);
            } else {
                this.addSuperClassInternal(database, superClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass removeSuperClass(OClass superClass) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` superclass -`%s`", this.name, superClass != null ? superClass.getName() : null);
                this.owner.sendCommand(database, cmd);
            } else {
                this.removeSuperClassInternal(superClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass setName(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid((String)name);
        OClass oClass = database.getMetadata().getSchema().getClass(name);
        if (oClass != null) {
            String error = String.format("Cannot rename class %s to %s. A Class with name %s exists", this.name, name, name);
            throw new OSchemaException(error);
        }
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + name + "'");
        }
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` name `%s`", this.name, name);
                this.owner.sendCommand(database, cmd);
            } else {
                this.setNameInternal(database, name);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass setShortName(String shortName) {
        if (shortName != null && (shortName = shortName.trim()).isEmpty()) {
            shortName = null;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` shortname `%s`", this.name, shortName);
                this.owner.sendCommand(database, cmd);
            } else {
                this.setShortNameInternal(database, shortName);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass truncateCluster(String clusterName) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, (Object)this.name);
        this.acquireSchemaReadLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("truncate cluster %s", clusterName);
                this.owner.sendCommand(database, cmd);
            } else {
                this.truncateClusterInternal(clusterName, database);
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass setStrictMode(boolean isStrict) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` strictmode %s", this.name, isStrict);
                this.owner.sendCommand(database, cmd);
            } else {
                this.setStrictModeInternal(isStrict);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass setDescription(String iDescription) {
        if (iDescription != null && (iDescription = iDescription.trim()).isEmpty()) {
            iDescription = null;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` description ?", this.name);
                this.owner.sendCommand(database, cmd);
            } else {
                this.setDescriptionInternal(iDescription);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass addClusterId(int clusterId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isAbstract()) {
            throw new OSchemaException("Impossible to associate a cluster to an abstract class class");
        }
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` addcluster %d", this.name, clusterId);
                this.owner.sendCommand(database, cmd);
            } else {
                this.addClusterIdInternal(database, clusterId);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass removeClusterId(int clusterId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.clusterIds.length == 1 && clusterId == this.clusterIds[0]) {
            throw new ODatabaseException(" Impossible to remove the last cluster of class '" + this.getName() + "' drop the class instead");
        }
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` removecluster %d", this.name, clusterId);
                this.owner.sendCommand(database, cmd);
            } else {
                this.removeClusterIdInternal(database, clusterId);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    public void dropProperty(String propertyName) {
        ODatabaseDocumentInternal database = this.getDatabase();
        if (database.getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (!this.properties.containsKey(propertyName)) {
                throw new OSchemaException("Property '" + propertyName + "' not found in class " + this.name + "'");
            }
            if (this.isDistributedCommand(database)) {
                this.owner.sendCommand(database, "drop property " + this.name + '.' + propertyName);
            } else {
                OScenarioThreadLocal.executeAsDistributed(() -> {
                    this.dropPropertyInternal(database, propertyName);
                    return null;
                });
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass addCluster(String clusterNameOrId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isAbstract()) {
            throw new OSchemaException("Impossible to associate a cluster to an abstract class class");
        }
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` addcluster `%s`", this.name, clusterNameOrId);
                this.owner.sendCommand(database, cmd);
            } else {
                int clusterId = this.owner.createClusterIfNeeded(database, clusterNameOrId);
                this.addClusterIdInternal(database, clusterId);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass setOverSize(float overSize) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` oversize %s", this.name, new Float(overSize).toString());
                this.owner.sendCommand(database, cmd);
            } else {
                this.setOverSizeInternal(database, overSize);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass setAbstract(boolean isAbstract) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand(database)) {
                String cmd = String.format("alter class `%s` abstract %s", this.name, isAbstract);
                this.owner.sendCommand(database, cmd);
            } else {
                this.setAbstractInternal(database, isAbstract);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    public int getClusterForNewInstance(ODocument doc) {
        return this.getClusterForNewInstance((ODatabaseDocumentDistributed)this.getDatabase(), doc);
    }

    public int getClusterForNewInstance(ODatabaseDocumentDistributed db, ODocument doc) {
        ODistributedServerManager manager = db.getDistributedManager();
        if (this.bestClusterIds == null) {
            this.readConfiguration(db, manager);
        } else {
            ODistributedConfiguration cfg = manager.getDatabaseConfiguration(db.getName());
            if (this.lastVersion != cfg.getVersion()) {
                this.readConfiguration(db, manager);
                ODistributedServerLog.info((Object)((Object)this), (String)manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"New cluster list for class '%s': %s (dCfgVersion=%d)", (Object[])new Object[]{this.getName(), Arrays.toString(this.bestClusterIds), this.lastVersion});
            }
        }
        int size = this.bestClusterIds.length;
        if (size == 0) {
            return -1;
        }
        if (size == 1) {
            return this.bestClusterIds[0];
        }
        int cluster = super.getClusterSelection().getCluster((OClass)this, this.bestClusterIds, doc);
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)((Object)this), (String)manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Selected cluster %d for class '%s' from %s (threadId=%d dCfgVersion=%d)", (Object[])new Object[]{cluster, this.getName(), Arrays.toString(this.bestClusterIds), Thread.currentThread().getId(), this.lastVersion});
        }
        return cluster;
    }

    public ODistributedConfiguration readConfiguration(ODatabaseDocumentDistributed db, ODistributedServerManager manager) {
        if (this.isAbstract()) {
            throw new IllegalArgumentException("Cannot create a new instance of abstract class");
        }
        int[] clusterIds = this.getClusterIds();
        ArrayList<String> clusterNames = new ArrayList<String>(clusterIds.length);
        for (int c : clusterIds) {
            clusterNames.add(db.getClusterNameById(c).toLowerCase(Locale.ENGLISH));
        }
        ODistributedConfiguration cfg = manager.getDatabaseConfiguration(db.getName());
        List bestClusters = cfg.getOwnedClustersByServer(clusterNames, manager.getLocalNodeName());
        if (bestClusters.isEmpty()) {
            OModifiableDistributedConfiguration modifiableCfg = cfg.modify();
            manager.reassignClustersOwnership(manager.getLocalNodeName(), db.getName(), modifiableCfg, true);
            cfg = modifiableCfg;
            db.activateOnCurrentThread();
            clusterNames.clear();
            for (int c : clusterIds = this.getClusterIds()) {
                clusterNames.add(db.getClusterNameById(c).toLowerCase(Locale.ENGLISH));
            }
            bestClusters = cfg.getOwnedClustersByServer(clusterNames, manager.getLocalNodeName());
            if (bestClusters.isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                for (String c : clusterNames) {
                    if (buffer.length() > 0) {
                        buffer.append(" ");
                    }
                    buffer.append(" ");
                    buffer.append(c);
                    buffer.append(":");
                    buffer.append(cfg.getServers(c, null));
                }
                ODistributedServerLog.warn((Object)((Object)this), (String)manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot find best cluster for class '%s'. Configured servers for clusters %s are %s (dCfgVersion=%d)", (Object[])new Object[]{this.getName(), clusterNames, buffer.toString(), cfg.getVersion()});
                throw new ODatabaseException("Cannot find best cluster for class '" + this.getName() + "' on server '" + manager.getLocalNodeName() + "' (clusterStrategy=" + this.getName() + " dCfgVersion=" + cfg.getVersion() + ")");
            }
        }
        db.activateOnCurrentThread();
        int[] newBestClusters = new int[bestClusters.size()];
        int i = 0;
        for (String c : bestClusters) {
            newBestClusters[i++] = db.getClusterIdByName(c);
        }
        this.bestClusterIds = newBestClusters;
        this.lastVersion = cfg.getVersion();
        return cfg;
    }

    protected boolean isDistributedCommand(ODatabaseDocumentInternal database) {
        return !database.isLocalEnv();
    }
}

