/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.metadata;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerShared;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;

public class OIndexManagerDistributed
extends OIndexManagerShared {
    public OIndexManagerDistributed(OStorage storage) {
        super(storage);
    }

    public void load(ODatabaseDocumentInternal database) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            super.load(database);
            return null;
        });
    }

    public OIndex createIndex(ODatabaseDocumentInternal database, String iName, String iType, OIndexDefinition indexDefinition, int[] clusterIdsToIndex, OProgressListener progressListener, ODocument metadata) {
        if (this.isDistributedCommand(database)) {
            return this.distributedCreateIndex(database, iName, iType, indexDefinition, clusterIdsToIndex, progressListener, metadata, null);
        }
        return super.createIndex(database, iName, iType, indexDefinition, clusterIdsToIndex, progressListener, metadata);
    }

    public OIndex createIndex(ODatabaseDocumentInternal database, String iName, String iType, OIndexDefinition iIndexDefinition, int[] iClusterIdsToIndex, OProgressListener progressListener, ODocument metadata, String algorithm) {
        if (this.isDistributedCommand(database)) {
            return this.distributedCreateIndex(database, iName, iType, iIndexDefinition, iClusterIdsToIndex, progressListener, metadata, algorithm);
        }
        return super.createIndex(database, iName, iType, iIndexDefinition, iClusterIdsToIndex, progressListener, metadata, algorithm);
    }

    public OIndex distributedCreateIndex(ODatabaseDocumentInternal database, String iName, String iType, OIndexDefinition iIndexDefinition, int[] iClusterIdsToIndex, OProgressListener progressListener, ODocument metadata, String engine) {
        String createIndexDDL = iIndexDefinition != null ? iIndexDefinition.toCreateIndexDDL(iName, iType, engine) : new OSimpleKeyIndexDefinition().toCreateIndexDDL(iName, iType, engine);
        if (metadata != null) {
            createIndexDDL = createIndexDDL + " METADATA " + metadata.toJSON();
        }
        if (progressListener != null) {
            progressListener.onBegin((Object)this, 0L, (Object)false);
        }
        this.sendCommand(database, createIndexDDL);
        ORecordInternal.setIdentity((ORecord)this.getDocument(), (ORecordId)new ORecordId(database.getStorageInfo().getConfiguration().getIndexMgrRecordId()));
        if (progressListener != null) {
            progressListener.onCompletition((Object)this, true);
        }
        this.reload();
        return super.preProcessBeforeReturn(database, super.getIndex(database, iName));
    }

    private boolean isDistributedCommand(ODatabaseDocumentInternal database) {
        return !database.isLocalEnv();
    }

    public void dropIndex(ODatabaseDocumentInternal database, String iIndexName) {
        if (this.isDistributedCommand(database)) {
            this.distributedDropIndex(database, iIndexName);
        }
        super.dropIndex(database, iIndexName);
    }

    public void distributedDropIndex(ODatabaseDocumentInternal database, String iName) {
        String dropIndexDDL = "DROP INDEX `" + iName + "`";
        this.sendCommand(database, dropIndexDDL);
        ORecordInternal.setIdentity((ORecord)this.getDocument(), (ORecordId)new ORecordId(database.getStorageInfo().getConfiguration().getIndexMgrRecordId()));
        this.reload();
    }

    public void sendCommand(ODatabaseDocumentInternal database, String query) {
        ((ODatabaseDocumentDistributed)database).sendDDLCommand(query, false);
    }
}

