/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.metadata;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class OPropertyDistributed
extends OPropertyEmbedded {
    public OPropertyDistributed(OClassImpl owner) {
        super(owner);
    }

    public OPropertyDistributed(OClassImpl owner, ODocument document) {
        super(owner, document);
    }

    public OPropertyDistributed(OClassImpl oClassImpl, OGlobalProperty global) {
        super(oClassImpl, global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setType(OType type) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        ODatabaseDocumentInternal database = this.getDatabase();
        this.acquireSchemaWriteLock();
        try {
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s type %s", this.getFullNameQuoted(), OPropertyDistributed.quoteString((String)type.toString()));
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setTypeInternal(type);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        this.owner.fireDatabaseMigration((ODatabaseDocument)database, this.globalRef.getName(), this.globalRef.getType());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProperty setName(String name) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s name %s", this.getFullNameQuoted(), OPropertyDistributed.quoteString((String)name));
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setNameInternal(name);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setDescription(String iDescription) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s description %s", this.getFullNameQuoted(), OPropertyDistributed.quoteString((String)iDescription));
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setDescriptionInternal(iDescription);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProperty setCollate(String collate) {
        if (collate == null) {
            collate = "default";
        }
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s collate %s", this.getFullNameQuoted(), OPropertyDistributed.quoteString((String)collate));
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setCollateInternal(collate);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    public void clearCustom() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s custom clear", this.getFullNameQuoted());
            if (this.isDistributedCommand()) {
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.clearCustomInternal();
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setCustom(String name, String value) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter property %s custom `%s`=%s", this.getFullNameQuoted(), name, OPropertyDistributed.quoteString((String)value));
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setCustomInternal(name, value);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setRegexp(String regexp) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s regexp %s", this.getFullNameQuoted(), OPropertyDistributed.quoteString((String)regexp));
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setRegexpInternal(regexp);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setLinkedClass(OClass linkedClass) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        OPropertyDistributed.checkSupportLinkedClass((OType)this.getType());
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s linkedclass %s", this.getFullNameQuoted(), OPropertyDistributed.quoteString((String)linkedClass.getName()));
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setLinkedClassInternal(linkedClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProperty setLinkedType(OType linkedType) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        OPropertyDistributed.checkLinkTypeSupport((OType)this.getType());
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s linkedtype %s", this.getFullNameQuoted(), OPropertyDistributed.quoteString((String)linkedType.toString()));
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setLinkedTypeInternal(linkedType);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setNotNull(boolean isNotNull) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s notnull %s", this.getFullNameQuoted(), isNotNull);
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setNotNullInternal(isNotNull);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setDefaultValue(String defaultValue) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s default %s", this.getFullNameQuoted(), OPropertyDistributed.quoteString((String)defaultValue));
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setDefaultValueInternal(defaultValue);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setMax(String max) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s max %s", this.getFullNameQuoted(), OPropertyDistributed.quoteString((String)max));
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setMaxInternal(max);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setMin(String min) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s min %s", this.getFullNameQuoted(), OPropertyDistributed.quoteString((String)min));
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setMinInternal(min);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setReadonly(boolean isReadonly) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s readonly %s", this.getFullNameQuoted(), isReadonly);
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setReadonlyInternal(isReadonly);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl setMandatory(boolean isMandatory) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s mandatory %s", this.getFullNameQuoted(), isMandatory);
                this.owner.getOwner().sendCommand(database, cmd);
            } else {
                this.setMandatoryInternal(isMandatory);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }
}

