/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.metadata;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.metadata.OClassDistributed;
import java.util.List;
import java.util.stream.Collectors;

public class OSchemaDistributed
extends OSchemaEmbedded {
    public OSchemaDistributed(OSharedContext sharedContext) {
        super(sharedContext);
    }

    protected OClassImpl createClassInstance(String className, int[] clusterIds) {
        return new OClassDistributed((OSchemaShared)this, className, clusterIds);
    }

    protected OClassImpl createClassInstance(ODocument c) {
        return new OClassDistributed((OSchemaShared)this, c, (String)c.field("name"));
    }

    public void acquireSchemaWriteLock(ODatabaseDocumentInternal database) {
        if (this.executeThroughDistributedStorage(database)) {
            ((ODatabaseDocumentDistributed)database).acquireDistributedExclusiveLock(0);
        } else {
            super.acquireSchemaWriteLock(database);
        }
    }

    public void releaseSchemaWriteLock(ODatabaseDocumentInternal database, boolean iSave) {
        try {
            if (!this.executeThroughDistributedStorage(database)) {
                super.releaseSchemaWriteLock(database, iSave);
            }
        }
        finally {
            if (this.executeThroughDistributedStorage(database)) {
                ((ODatabaseDocumentDistributed)database).releaseDistributedExclusiveLock();
            }
        }
    }

    protected void doDropClass(ODatabaseDocumentInternal database, String className) {
        if (this.executeThroughDistributedStorage(database)) {
            StringBuilder cmd = new StringBuilder("drop class ");
            cmd.append(className);
            cmd.append(" unsafe");
            this.sendCommand(database, cmd.toString());
        } else {
            this.dropClassInternal(database, className);
        }
    }

    protected void doDropView(ODatabaseDocumentInternal database, String name) {
        if (this.executeThroughDistributedStorage(database)) {
            StringBuilder cmd = new StringBuilder("drop view ");
            cmd.append(name);
            cmd.append(" unsafe");
            this.sendCommand(database, cmd.toString());
        }
        this.dropViewInternal(database, name);
    }

    protected void doRealCreateView(ODatabaseDocumentInternal database, OViewConfig config, int[] clusterIds) throws OSchemaShared.ClusterIdsAreEmptyException {
        if (this.executeThroughDistributedStorage(database)) {
            StringBuilder cmd = new StringBuilder("create view ");
            cmd.append('`');
            cmd.append(config.getName());
            cmd.append('`');
            cmd.append(" from (");
            cmd.append(config.getQuery());
            cmd.append(") METADATA {");
            cmd.append(", updateIntervalSeconds: " + config.getUpdateIntervalSeconds());
            if (config.getWatchClasses() != null && config.getWatchClasses().size() > 0) {
                cmd.append(", watchClasses: [\"");
                cmd.append(config.getWatchClasses().stream().collect(Collectors.joining("\",\"")));
                cmd.append("\"]");
            }
            if (config.getNodes() != null && config.getNodes().size() > 0) {
                cmd.append(", nodes: [\"");
                cmd.append(config.getNodes().stream().collect(Collectors.joining("\",\"")));
                cmd.append("\"]");
            }
            if (config.getIndexes() != null && config.getIndexes().size() > 0) {
                cmd.append(", indexes: [");
                boolean first = true;
                for (OViewConfig.OViewIndexConfig index : config.getIndexes()) {
                    if (!first) {
                        cmd.append(", ");
                    }
                    cmd.append("{");
                    cmd.append("type: \"" + index.getType() + "\"");
                    if (index.getEngine() != null) {
                        cmd.append(", engine: \"" + index.getEngine() + "\"");
                    }
                    cmd.append(", properties:{");
                    boolean firstProp = true;
                    for (OPair property : index.getProperties()) {
                        if (!firstProp) {
                            cmd.append(", ");
                        }
                        cmd.append("\"");
                        cmd.append((String)((Object)property.key));
                        cmd.append("\":\"");
                        cmd.append(property.value);
                        cmd.append("\"");
                        firstProp = false;
                    }
                    cmd.append("  }");
                    cmd.append("}");
                    first = false;
                }
                cmd.append("]");
            }
            if (config.isUpdatable()) {
                cmd.append(", updatable: true");
            }
            if (config.getOriginRidField() != null) {
                cmd.append(", originRidField: \"");
                cmd.append(config.getOriginRidField());
                cmd.append("\"");
            }
            if (config.getUpdateStrategy() != null) {
                cmd.append(", updateStrategy: \"");
                cmd.append(config.getUpdateStrategy());
                cmd.append("\"");
            }
            cmd.append("}");
            this.sendCommand(database, cmd.toString());
        } else {
            this.createViewInternal(database, config, clusterIds);
        }
    }

    protected void doRealCreateClass(ODatabaseDocumentInternal database, String className, List<OClass> superClassesList, int[] clusterIds) throws OSchemaShared.ClusterIdsAreEmptyException {
        if (this.executeThroughDistributedStorage(database)) {
            StringBuilder cmd = new StringBuilder("create class ");
            cmd.append('`');
            cmd.append(className);
            cmd.append('`');
            boolean first = true;
            for (OClass superClass : superClassesList) {
                if (first) {
                    cmd.append(" extends ");
                } else {
                    cmd.append(", ");
                }
                cmd.append(superClass.getName());
                first = false;
            }
            if (clusterIds != null) {
                if (clusterIds.length == 1 && clusterIds[0] == -1) {
                    cmd.append(" abstract");
                } else {
                    cmd.append(" cluster ");
                    for (int i = 0; i < clusterIds.length; ++i) {
                        if (i > 0) {
                            cmd.append(',');
                        } else {
                            cmd.append(' ');
                        }
                        cmd.append(clusterIds[i]);
                    }
                }
            }
            this.sendCommand(database, cmd.toString());
        } else {
            this.createClassInternal(database, className, clusterIds, superClassesList);
        }
    }

    public void sendCommand(ODatabaseDocumentInternal database, String command) {
        ((ODatabaseDocumentDistributed)database).sendDDLCommand(command, false);
    }
}

