/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.metadata;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OMetadataUpdateListener;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.db.OrientDBDistributed;
import com.orientechnologies.orient.core.db.OrientDBEmbedded;
import com.orientechnologies.orient.core.db.viewmanager.ViewManager;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryImpl;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryImpl;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.schedule.OSchedulerImpl;
import com.orientechnologies.orient.core.sql.executor.OQueryStats;
import com.orientechnologies.orient.core.sql.parser.OExecutionPlanCache;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.server.distributed.impl.metadata.OIndexManagerDistributed;
import com.orientechnologies.orient.server.distributed.impl.metadata.OSchemaDistributed;
import java.util.HashMap;

public class OSharedContextDistributed
extends OSharedContextEmbedded {
    public OSharedContextDistributed(OStorage storage, OrientDBDistributed orientDB) {
        super(storage, (OrientDBEmbedded)orientDB);
    }

    protected void init(OStorage storage) {
        this.schema = new OSchemaDistributed((OSharedContext)this);
        this.security = this.orientDB.getSecuritySystem().newSecurity(storage.getName());
        this.indexManager = new OIndexManagerDistributed(storage);
        this.functionLibrary = new OFunctionLibraryImpl();
        this.scheduler = new OSchedulerImpl(this.orientDB);
        this.sequenceLibrary = new OSequenceLibraryImpl();
        this.liveQueryOps = new OLiveQueryHook.OLiveQueryOps();
        this.liveQueryOpsV2 = new OLiveQueryHookV2.OLiveQueryOps();
        this.statementCache = new OStatementCache(storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.STATEMENT_CACHE_SIZE));
        this.executionPlanCache = new OExecutionPlanCache(storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.STATEMENT_CACHE_SIZE));
        this.registerListener(this.executionPlanCache);
        this.queryStats = new OQueryStats();
        this.activeDistributedQueries = new HashMap();
        ((OAbstractPaginatedStorage)storage).setStorageConfigurationUpdateListener(update -> {
            for (OMetadataUpdateListener listener : this.browseListeners()) {
                listener.onStorageConfigurationUpdate(storage.getName(), update);
            }
        });
        this.viewManager = new ViewManager(this.orientDB, storage.getName());
    }

    public synchronized void load(ODatabaseDocumentInternal database) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            long timer = PROFILER.startChrono();
            try {
                if (!this.loaded) {
                    this.schema.load(database);
                    this.indexManager.load(database);
                    this.schema.forceSnapshot(database);
                    this.security.load((ODatabaseSession)database);
                    this.functionLibrary.load(database);
                    this.scheduler.load(database);
                    this.sequenceLibrary.load(database);
                    this.schema.onPostIndexManagement();
                    this.viewManager.load();
                    this.loaded = true;
                }
            }
            finally {
                PROFILER.stopChrono(PROFILER.getDatabaseMetric(database.getName(), "metadata.load"), "Loading of database metadata", timer, "db.*.metadata.load");
            }
            return null;
        });
    }

    public synchronized void close() {
        this.viewManager.close();
        this.schema.close();
        this.security.close();
        this.indexManager.close();
        this.functionLibrary.close();
        this.scheduler.close();
        this.sequenceLibrary.close();
        this.statementCache.clear();
        this.executionPlanCache.invalidate();
        this.liveQueryOps.close();
        this.liveQueryOpsV2.close();
        this.loaded = false;
    }

    public synchronized void reload(ODatabaseDocumentInternal database) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            this.schema.reload(database);
            this.indexManager.reload();
            this.schema.forceSnapshot(database);
            this.security.load((ODatabaseSession)database);
            this.functionLibrary.load(database);
            this.sequenceLibrary.load(database);
            this.scheduler.load(database);
            return null;
        });
    }

    public synchronized void create(ODatabaseDocumentInternal database) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            this.schema.create(database);
            this.indexManager.create(database);
            this.security.create((ODatabaseSession)database);
            this.functionLibrary.create(database);
            this.sequenceLibrary.create(database);
            this.security.createClassTrigger((ODatabaseSession)database);
            this.scheduler.create(database);
            this.schema.createClass(database, "V");
            this.schema.createClass(database, "E");
            try {
                OIndexFactory factory = OIndexes.getFactory((String)OClass.INDEX_TYPE.SPATIAL.toString(), (String)"LUCENE");
                if (factory != null && factory instanceof ODatabaseLifecycleListener) {
                    ((ODatabaseLifecycleListener)factory).onCreate((ODatabaseInternal)database);
                }
            }
            catch (OIndexException oIndexException) {
                // empty catch block
            }
            this.schema.forceSnapshot(database);
            this.loaded = true;
            return null;
        });
    }

    public ViewManager getViewManager() {
        return this.viewManager;
    }
}

