/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncDatabaseTask;
import com.orientechnologies.orient.server.distributed.impl.task.TeeOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class OBackgroundBackup
implements Runnable,
OSyncSource {
    private OSyncDatabaseTask oSyncDatabaseTask;
    private final ODistributedServerManager iManager;
    private final ODatabaseDocumentInternal database;
    private final File resultedBackupFile;
    private final String finalBackupPath;
    private final AtomicBoolean incremental = new AtomicBoolean(false);
    private final ODistributedDatabase dDatabase;
    private final ODistributedRequestId requestId;
    private final CountDownLatch started = new CountDownLatch(1);
    private final CountDownLatch finished = new CountDownLatch(1);
    private volatile InputStream inputStream;
    public volatile boolean valid = true;
    private TimerTask timerTask;
    private volatile long lastRead;

    public OBackgroundBackup(OSyncDatabaseTask oSyncDatabaseTask, ODistributedServerManager iManager, ODatabaseDocumentInternal database, File resultedBackupFile, String finalBackupPath, OModifiableBoolean incremental, ODistributedDatabase dDatabase, ODistributedRequestId requestId, File completedFile) {
        this.oSyncDatabaseTask = oSyncDatabaseTask;
        this.iManager = iManager;
        this.database = database;
        this.resultedBackupFile = resultedBackupFile;
        this.finalBackupPath = finalBackupPath;
        this.dDatabase = dDatabase;
        this.requestId = requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("OrientDB SyncDatabase node=" + this.iManager.getLocalNodeName() + " db=" + this.database.getName());
        this.database.activateOnCurrentThread();
        this.startExpireTask();
        try {
            try {
                ODistributedServerLog.info((Object)this, (String)this.iManager.getLocalNodeName(), (String)this.oSyncDatabaseTask.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Compressing database '%s' %d clusters %s...", (Object[])new Object[]{this.database.getName(), this.database.getClusterNames().size(), this.database.getClusterNames()});
                if (this.resultedBackupFile.exists()) {
                    this.resultedBackupFile.delete();
                } else {
                    this.resultedBackupFile.getParentFile().mkdirs();
                }
                this.resultedBackupFile.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(this.resultedBackupFile);
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                this.inputStream = new PipedInputStream(pipedOutputStream, 0x800000);
                TeeOutputStream dest = new TeeOutputStream(fileOutputStream, pipedOutputStream);
                if (this.database.getStorage().supportIncremental()) {
                    OWriteAheadLog wal = ((OAbstractPaginatedStorage)this.database.getStorage()).getWALInstance();
                    OLogSequenceNumber lsn = wal.end();
                    if (lsn == null) {
                        lsn = new OLogSequenceNumber(-1L, -1);
                    }
                    wal.addCutTillLimit(lsn);
                    try {
                        this.incremental.set(true);
                        this.started.countDown();
                        this.database.getStorage().fullIncrementalBackup((OutputStream)dest);
                    }
                    catch (UnsupportedOperationException u) {
                        throw u;
                    }
                    catch (RuntimeException r) {
                        this.finished.countDown();
                        throw r;
                    }
                    finally {
                        wal.removeCutTillLimit(lsn);
                    }
                    this.finished.countDown();
                    OLogManager.instance().info((Object)this, "Sending Enterprise backup (" + this.database.getName() + ") for node sync", new Object[0]);
                } else {
                    try {
                        OCommandOutputListener listener = null;
                        if (ODistributedServerLog.isDebugEnabled()) {
                            listener = new OCommandOutputListener(){

                                public void onMessage(String iText) {
                                    if (iText.startsWith("\n")) {
                                        iText = iText.substring(1);
                                    }
                                    OLogManager.instance().debug((Object)this, iText, new Object[0]);
                                }
                            };
                        }
                        int compression = OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION.getValueAsInteger();
                        Callable<Object> startListener = () -> {
                            this.incremental.set(false);
                            this.started.countDown();
                            return null;
                        };
                        this.database.backup((OutputStream)dest, null, startListener, listener, compression, 0x800000);
                    }
                    finally {
                        try {
                            ((OutputStream)dest).close();
                        }
                        catch (IOException e2) {
                            OLogManager.instance().debug((Object)this, "Error performing backup ", (Throwable)e2, new Object[0]);
                        }
                        this.finished.countDown();
                        this.timerTask.cancel();
                    }
                }
                ODistributedServerLog.info((Object)this, (String)this.iManager.getLocalNodeName(), (String)this.oSyncDatabaseTask.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Backup of database '%s' completed. lastOperationId=%s...", (Object[])new Object[]{this.database.getName(), this.requestId});
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Cannot execute backup of database '%s' for deploy database", (Throwable)e, new Object[]{this.database.getName()});
                throw e;
            }
            finally {
                this.finished.countDown();
                this.timerTask.cancel();
            }
        }
        catch (Exception e) {
            OLogManager.instance().errorNoDb((Object)this, "Error during backup processing, file %s will be deleted\n", (Throwable)e, new Object[]{this.resultedBackupFile});
            try {
                Files.deleteIfExists(Paths.get(this.resultedBackupFile.getAbsolutePath(), new String[0]));
            }
            catch (IOException ioe) {
                OLogManager.instance().errorNoDb((Object)this, "Can not delete file %s\n", (Throwable)ioe, new Object[]{this.resultedBackupFile});
            }
        }
    }

    private void startExpireTask() {
        this.lastRead = System.currentTimeMillis();
        final long timeout = this.database.getConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_DEPLOYCHUNK_TASK_SYNCH_TIMEOUT);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - OBackgroundBackup.this.lastRead > timeout * 3L) {
                    try {
                        OBackgroundBackup.this.inputStream.close();
                        this.cancel();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.database.getSharedContext().getOrientDB().schedule(this.timerTask, timeout, timeout);
    }

    public void makeStreamFromFile() throws IOException, InterruptedException {
        this.getFinished().await();
        this.inputStream = new FileInputStream(this.finalBackupPath);
    }

    public boolean getIncremental() {
        return this.incremental.get();
    }

    public File getResultedBackupFile() {
        return this.resultedBackupFile;
    }

    public String getFinalBackupPath() {
        return this.finalBackupPath;
    }

    public CountDownLatch getStarted() {
        return this.started;
    }

    public CountDownLatch getFinished() {
        return this.finished;
    }

    public InputStream getInputStream() {
        this.lastRead = System.currentTimeMillis();
        return this.inputStream;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }
}

