/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OCopyDatabaseChunkTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 15;
    private String fileName;
    private int chunkNum;
    private long offset;
    private boolean compressed;

    public OCopyDatabaseChunkTask() {
    }

    public OCopyDatabaseChunkTask(String iFileName, int iChunkNum, long iOffset, boolean iCompressed) {
        this.fileName = iFileName;
        this.chunkNum = iChunkNum;
        this.offset = iOffset;
        this.compressed = iCompressed;
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (database == null) {
            throw new ODistributedException("database not available anymore during sync");
        }
        ODistributedDatabaseImpl local = (ODistributedDatabaseImpl)iManager.getMessageService().getDatabase(database.getName());
        OSyncSource b = local.getLastValidBackup();
        ODistributedDatabaseChunk result = new ODistributedDatabaseChunk(b, 0x800000);
        ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"- transferring chunk #%d offset=%d size=%s...", (Object[])new Object[]{this.chunkNum, result.offset, OFileUtils.getSizeAsNumber((Object)result.buffer.length)});
        return result;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.ANY;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYCHUNK_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    public String getName() {
        return "copy_db_chunk";
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.fileName);
        out.writeInt(this.chunkNum);
        out.writeLong(this.offset);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.fileName = in.readUTF();
        this.chunkNum = in.readInt();
        this.offset = in.readLong();
    }

    public boolean isNodeOnlineRequired() {
        return false;
    }

    public int getFactoryId() {
        return 15;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getChunkNum() {
        return this.chunkNum;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean isCompressed() {
        return this.compressed;
    }
}

