/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OGossipTask
extends OAbstractRemoteTask {
    public static final int FACTORYID = 16;
    private long timestamp = System.currentTimeMillis();
    private String lockManagerServer = "";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (ODistributedServerLog.isDebugEnabled()) {
            SimpleDateFormat simpleDateFormat = dateFormat;
            synchronized (simpleDateFormat) {
                ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Received gossip message (sourceTimeStamp=%s lockManagerServer=%s)", (Object[])new Object[]{dateFormat.format(new Date(this.timestamp)), this.lockManagerServer});
            }
        }
        return this.lockManagerServer;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public boolean isUsingDatabase() {
        return false;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeUTF(this.lockManagerServer);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.timestamp = in.readLong();
        this.lockManagerServer = in.readUTF();
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_HEARTBEAT_TIMEOUT.getValueAsLong();
    }

    public long getSynchronousTimeout(int iSynchNodes) {
        return this.getDistributedTimeout();
    }

    public long getTotalTimeout(int iTotalNodes) {
        return this.getDistributedTimeout();
    }

    public String getName() {
        return "gossip";
    }

    public int getFactoryId() {
        return 16;
    }

    public boolean isNodeOnlineRequired() {
        return false;
    }

    public String toString() {
        return this.getName() + " timestamp: " + this.timestamp + " lockManagerServer: " + this.lockManagerServer;
    }
}

