/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.serialization.OStreamable;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;

public class ONewDeltaTaskResponse
implements OStreamable {
    private ResponseType responseType;
    private Optional<ODistributedDatabaseChunk> chunk;

    public ONewDeltaTaskResponse() {
    }

    public ONewDeltaTaskResponse(ResponseType responseType) {
        this.responseType = responseType;
    }

    public ONewDeltaTaskResponse(ODistributedDatabaseChunk chunk) {
        this.responseType = ResponseType.CHUNK;
        this.chunk = Optional.of(chunk);
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeByte(this.responseType.getValue());
        if (this.responseType == ResponseType.CHUNK) {
            this.chunk.get().toStream(out);
        }
    }

    public void fromStream(DataInput in) throws IOException {
        this.responseType = ResponseType.fromValue(in.readByte());
        if (this.responseType == ResponseType.CHUNK) {
            ODistributedDatabaseChunk c = new ODistributedDatabaseChunk();
            c.fromStream(in);
            this.chunk = Optional.of(c);
        }
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public Optional<ODistributedDatabaseChunk> getChunk() {
        return this.chunk;
    }

    public static enum ResponseType {
        CHUNK(1),
        FULL_SYNC(2),
        PARTIAL_CHUNK(3),
        NO_CHANGES(4);

        private byte value;

        private ResponseType(byte b) {
            this.value = b;
        }

        public byte getValue() {
            return this.value;
        }

        static ResponseType fromValue(byte b) {
            switch (b) {
                case 1: {
                    return CHUNK;
                }
                case 2: {
                    return FULL_SYNC;
                }
                case 3: {
                    return PARTIAL_CHUNK;
                }
                case 4: {
                    return NO_CHANGES;
                }
            }
            return null;
        }
    }
}

