/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1TaskResult;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OSQLCommandTaskFirstPhase
extends OAbstractRemoteTask {
    public static final int FACTORYID = 59;
    private String query;
    private OTransactionId preChangeId;
    private OTransactionId afterChangeId;

    public OSQLCommandTaskFirstPhase() {
    }

    public OSQLCommandTaskFirstPhase(String query, OTransactionId preChangeId, OTransactionId afterChangeId) {
        this.query = query;
        this.preChangeId = preChangeId;
        this.afterChangeId = afterChangeId;
    }

    public String getName() {
        return "sql_command_ddl_first_phase";
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        OTransactionResultPayload res = ((ODatabaseDocumentDistributed)database).firstPhaseDDL(this.query, this.preChangeId, this.afterChangeId, requestId);
        return new OTransactionPhase1TaskResult(res);
    }

    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        out.writeUTF(this.query);
        this.preChangeId.write(out);
        this.afterChangeId.write(out);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        super.fromStream(in, factory);
        this.query = in.readUTF();
        this.preChangeId = OTransactionId.read((DataInput)in);
        this.afterChangeId = OTransactionId.read((DataInput)in);
    }

    public int getFactoryId() {
        return 59;
    }

    public String getQuery() {
        return this.query;
    }

    public OTransactionId getPreChangeId() {
        return this.preChangeId;
    }

    public OTransactionId getAfterChangeId() {
        return this.afterChangeId;
    }
}

