/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.core.tx.OTransactionSequenceStatus;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.task.ONewDeltaTaskResponse;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class OSyncDatabaseNewDeltaTask
extends OAbstractRemoteTask {
    public static final int CHUNK_MAX_SIZE = 0x800000;
    public static final int FACTORYID = 57;
    private OTransactionSequenceStatus lastState;

    public OSyncDatabaseNewDeltaTask(OTransactionSequenceStatus lastState) {
        this.lastState = lastState;
    }

    public OSyncDatabaseNewDeltaTask() {
    }

    public String getName() {
        return "transaction_id_delta_sync_database";
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedDatabase db = iManager.getMessageService().getDatabase(database.getName());
        db.checkReverseSync(this.lastState);
        List missing = db.missingTransactions(this.lastState);
        if (!missing.isEmpty()) {
            Optional delta = ((OAbstractPaginatedStorage)database.getStorage()).extractTransactionsFromWal(missing);
            if (delta.isPresent()) {
                ((ODistributedDatabaseImpl)db).setLastValidBackup((OSyncSource)delta.get());
                return new ONewDeltaTaskResponse(new ODistributedDatabaseChunk((OSyncSource)delta.get(), 0x800000));
            }
            return new ONewDeltaTaskResponse(ONewDeltaTaskResponse.ResponseType.FULL_SYNC);
        }
        return new ONewDeltaTaskResponse(ONewDeltaTaskResponse.ResponseType.NO_CHANGES);
    }

    public void toStream(DataOutput out) throws IOException {
        this.lastState.writeNetwork(out);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.lastState = OTransactionSequenceStatus.readNetwork((DataInput)in);
    }

    public OTransactionSequenceStatus getLastState() {
        return this.lastState;
    }

    public int getFactoryId() {
        return 57;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }
}

