/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.task.OBackgroundBackup;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class OSyncDatabaseTask
extends OAbstractRemoteTask {
    public static final int FACTORYID = 14;
    protected long random = UUID.randomUUID().getLeastSignificantBits();
    public static final String DEPLOYDB = "deploydb.";
    public static final int CHUNK_MAX_SIZE = 0x800000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (!iManager.getLocalNodeName().equals(this.getNodeSource())) {
            if (database == null) {
                throw new ODistributedException("Database instance is null");
            }
            String databaseName = database.getName();
            ODistributedDatabaseImpl dDatabase = (ODistributedDatabaseImpl)iManager.getMessageService().getDatabase(databaseName);
            try {
                Long lastDeployment = (Long)iManager.getConfigurationMap().get(DEPLOYDB + databaseName);
                if (lastDeployment != null && lastDeployment == this.random) {
                    ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skip deploying database '%s' because already executed", (Object[])new Object[]{databaseName});
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                iManager.getConfigurationMap().put(DEPLOYDB + databaseName, this.random);
                iManager.setDatabaseStatus(this.getNodeSource(), databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
                ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Deploying database %s...", (Object[])new Object[]{databaseName});
                OBackgroundBackup backup = null;
                OSyncSource last = dDatabase.getLastValidBackup();
                if (last instanceof OBackgroundBackup) {
                    backup = (OBackgroundBackup)last;
                }
                if (backup == null || !last.isValid() || !backup.getResultedBackupFile().exists()) {
                    File backupFile = new File(Orient.getTempPath() + "/backup_" + database.getName() + ".zip");
                    String backupPath = backupFile.getAbsolutePath();
                    int compressionRate = OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION.getValueAsInteger();
                    if (backupFile.exists()) {
                        if (backupFile.isDirectory()) {
                            OFileUtils.deleteRecursively((File)backupFile);
                        }
                        backupFile.delete();
                    } else {
                        backupFile.getParentFile().mkdirs();
                    }
                    backupFile.createNewFile();
                    File resultedBackupFile = backupFile;
                    File completedFile = new File(backupFile.getAbsolutePath() + ".completed");
                    if (completedFile.exists()) {
                        completedFile.delete();
                    }
                    ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Creating backup of database '%s' (compressionRate=%d) in directory: %s...", (Object[])new Object[]{databaseName, compressionRate, backupPath});
                    backup = new OBackgroundBackup(this, iManager, database, resultedBackupFile, backupPath, null, dDatabase, requestId, completedFile);
                    Thread t = new Thread(backup);
                    t.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new OUncaughtExceptionHandler());
                    t.start();
                    dDatabase.setLastValidBackup(backup);
                } else {
                    backup.makeStreamFromFile();
                    ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Reusing last backup of database '%s' in directory: %s...", (Object[])new Object[]{databaseName, backup.getResultedBackupFile().getAbsolutePath()});
                }
                while (!backup.getStarted().await(1L, TimeUnit.MINUTES)) {
                    OLogManager.instance().info((Object)this, "Another backup running on database '%s' waiting it to finish", new Object[]{databaseName});
                }
                ODistributedDatabaseChunk chunk = new ODistributedDatabaseChunk(backup, 0x800000);
                ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"- transferring chunk #%d offset=%d size=%s...", (Object[])new Object[]{1, 0, OFileUtils.getSizeAsNumber((Object)chunk.buffer.length)});
                if (chunk.last) {
                    iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
                }
                ODistributedDatabaseChunk oDistributedDatabaseChunk = chunk;
                return oDistributedDatabaseChunk;
            }
            catch (OLockException e) {
                ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skip deploying database %s because another node is doing it", (Object[])new Object[]{databaseName});
            }
            finally {
                ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Deploy database task completed", (Object[])new Object[0]);
            }
        } else {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skip deploying database from the same node", (Object[])new Object[0]);
        }
        return Boolean.FALSE;
    }

    public String getName() {
        return "deploy_db";
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeLong(this.random);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.random = in.readLong();
    }

    public int getFactoryId() {
        return 14;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public void onMessage(String iText) {
        if (iText.startsWith("\r\n")) {
            iText = iText.substring(2);
        }
        if (iText.startsWith("\n")) {
            iText = iText.substring(1);
        }
        OLogManager.instance().info((Object)this, iText, new Object[0]);
    }

    public boolean isNodeOnlineRequired() {
        return false;
    }
}

