/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializerDeltaDistributed;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkDistributed;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.tx.ValidationResult;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.OInvalidSequentialException;
import com.orientechnologies.orient.server.distributed.impl.ONewDistributedTxContextImpl;
import com.orientechnologies.orient.server.distributed.impl.OTransactionOptimisticDistributed;
import com.orientechnologies.orient.server.distributed.impl.TxContextStatus;
import com.orientechnologies.orient.server.distributed.impl.task.OLockKeySource;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1TaskResult;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionUniqueKey;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentCreation;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentModification;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxException;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxInvalidSequential;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxKeyLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxRecordLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxStillRunning;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxSuccess;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxUniqueIndex;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedKeyLockedException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.TreeSet;

public class OTransactionPhase1Task
extends OAbstractRemoteTask
implements OLockKeySource {
    public static final int FACTORYID = 43;
    private volatile boolean hasResponse;
    private List<ORecordOperation> ops;
    private List<ORecordOperationRequest> operations;
    private SortedSet<OTransactionUniqueKey> uniqueIndexKeys;
    private transient int retryCount = 0;
    private volatile boolean finished;
    private TimerTask notYetFinishedTask;
    private OTransactionId transactionId;

    public OTransactionPhase1Task() {
        this.ops = new ArrayList<ORecordOperation>();
        this.operations = new ArrayList<ORecordOperationRequest>();
        this.uniqueIndexKeys = new TreeSet<OTransactionUniqueKey>();
    }

    public OTransactionPhase1Task(List<ORecordOperation> ops, OTransactionId transactionId, SortedSet<OTransactionUniqueKey> uniqueIndexKeys) {
        this.ops = ops;
        this.operations = new ArrayList<ORecordOperationRequest>();
        this.uniqueIndexKeys = uniqueIndexKeys;
        this.transactionId = transactionId;
        this.genOps(ops);
    }

    public void genOps(List<ORecordOperation> ops) {
        for (ORecordOperation txEntry : ops) {
            if (txEntry.type == 0) continue;
            ORecordOperationRequest request = new ORecordOperationRequest();
            request.setType(txEntry.type);
            request.setVersion(txEntry.getRecord().getVersion());
            request.setId(txEntry.getRecord().getIdentity());
            request.setRecordType(ORecordInternal.getRecordType((ORecord)txEntry.getRecord()));
            switch (txEntry.type) {
                case 3: {
                    request.setRecord(ORecordSerializerNetworkDistributed.INSTANCE.toStream(txEntry.getRecord()));
                    request.setContentChanged(ORecordInternal.isContentChanged((ORecord)txEntry.getRecord()));
                    break;
                }
                case 1: {
                    if (request.getRecordType() == 100) {
                        request.setRecord(ODocumentSerializerDeltaDistributed.instance().serializeDelta((ODocument)txEntry.getRecord()));
                    } else {
                        request.setRecord(ORecordSerializerNetworkDistributed.INSTANCE.toStream(txEntry.getRecord()));
                    }
                    request.setContentChanged(ORecordInternal.isContentChanged((ORecord)txEntry.getRecord()));
                    break;
                }
            }
            this.operations.add(request);
        }
    }

    public String getName() {
        return "TxPhase1";
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        OTransactionResultPayload res1;
        if (iManager != null) {
            iManager.messageBeforeOp("prepare1Phase", requestId);
        }
        this.convert(database);
        if (iManager != null) {
            iManager.messageAfterOp("prepare1Phase", requestId);
        }
        OTransactionOptimisticDistributed tx = new OTransactionOptimisticDistributed(database, this.ops, this.uniqueIndexKeys);
        try {
            res1 = OTransactionPhase1Task.executeTransaction(requestId, this.transactionId, (ODatabaseDocumentDistributed)database, (OTransactionInternal)tx, false, this.retryCount);
        }
        catch (Exception e) {
            this.finished = true;
            if (this.notYetFinishedTask != null) {
                this.notYetFinishedTask.cancel();
            }
            throw e;
        }
        if (res1 == null) {
            int autoRetryDelay = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY.getValueAsInteger();
            ++this.retryCount;
            ((ODatabaseDocumentDistributed)database).getDistributedShared().reEnqueue(requestId.getNodeId(), requestId.getMessageId(), database.getName(), (ORemoteTask)this, this.retryCount, autoRetryDelay);
            this.hasResponse = false;
            return null;
        }
        this.hasResponse = true;
        this.finished = true;
        if (this.notYetFinishedTask != null) {
            this.notYetFinishedTask.cancel();
        }
        return new OTransactionPhase1TaskResult(res1);
    }

    public boolean hasResponse() {
        return this.hasResponse;
    }

    public static OTransactionResultPayload executeTransaction(ODistributedRequestId requestId, OTransactionId id, ODatabaseDocumentDistributed database, OTransactionInternal tx, boolean isCoordinator, int retryCount) {
        OTransactionResultPayload payload;
        try {
            if (!isCoordinator) {
                ODistributedDatabase localDistributedDatabase = database.getDistributedShared();
                ValidationResult result = localDistributedDatabase.validate(id);
                if (result == ValidationResult.ALREADY_PROMISED || result == ValidationResult.MISSING_PREVIOUS) {
                    ONewDistributedTxContextImpl txContext = new ONewDistributedTxContextImpl((ODistributedDatabaseImpl)localDistributedDatabase, requestId, tx, id);
                    txContext.setStatus(TxContextStatus.TIMEDOUT);
                    database.register(requestId, localDistributedDatabase, txContext);
                    return new OTxInvalidSequential();
                }
                if (result == ValidationResult.ALREADY_PRESENT) {
                    ONewDistributedTxContextImpl txContext = new ONewDistributedTxContextImpl((ODistributedDatabaseImpl)localDistributedDatabase, requestId, tx, id);
                    txContext.setStatus(TxContextStatus.TIMEDOUT);
                    database.register(requestId, localDistributedDatabase, txContext);
                    return new OTxInvalidSequential();
                }
            }
            if (!database.beginDistributedTx(requestId, id, tx, isCoordinator, retryCount)) {
                return null;
            }
            payload = new OTxSuccess();
        }
        catch (OConcurrentModificationException ex) {
            payload = new OTxConcurrentModification((ORecordId)ex.getRid(), ex.getEnhancedDatabaseVersion());
        }
        catch (ODistributedRecordLockedException ex) {
            payload = new OTxRecordLockTimeout(ex.getNode(), ex.getRid());
        }
        catch (ODistributedKeyLockedException ex) {
            payload = new OTxKeyLockTimeout(ex.getNode(), ex.getKey());
        }
        catch (ORecordDuplicatedException ex) {
            payload = new OTxUniqueIndex((ORecordId)ex.getRid(), ex.getIndexName(), ex.getKey());
        }
        catch (OConcurrentCreateException ex) {
            payload = new OTxConcurrentCreation(ex.getActualRid(), ex.getExpectedRid());
        }
        catch (OInvalidSequentialException ex) {
            payload = new OTxInvalidSequential();
        }
        catch (RuntimeException ex) {
            payload = new OTxException(ex);
        }
        return payload;
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.transactionId = OTransactionId.read((DataInput)in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            ORecordOperationRequest req = OMessageHelper.readTransactionEntry((DataInput)in);
            this.operations.add(req);
        }
        ORecordSerializerNetworkDistributed serializer = ORecordSerializerNetworkDistributed.INSTANCE;
        OTransactionPhase1Task.readTxUniqueIndexKeys(this.uniqueIndexKeys, (ORecordSerializerNetworkV37)serializer, in);
    }

    public static void readTxUniqueIndexKeys(SortedSet<OTransactionUniqueKey> uniqueIndexKeys, ORecordSerializerNetworkV37 serializer, DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            OTransactionUniqueKey entry = OTransactionUniqueKey.read(in, serializer);
            uniqueIndexKeys.add(entry);
        }
    }

    private void convert(ODatabaseDocumentInternal database) {
        for (ORecordOperationRequest req : this.operations) {
            byte type = req.getType();
            if (type == 0) continue;
            ORecord record = null;
            switch (type) {
                case 3: {
                    record = ORecordSerializerNetworkDistributed.INSTANCE.fromStream(req.getRecord(), null);
                    ORecordInternal.setRecordSerializer((ORecord)record, (ORecordSerializer)database.getSerializer());
                    break;
                }
                case 1: {
                    if (req.getRecordType() == 100) {
                        record = (ORecord)database.load(req.getId());
                        if (record == null) {
                            record = new ODocument();
                        }
                        ((ODocument)record).deserializeFields(new String[0]);
                        ODocumentInternal.clearTransactionTrackData((ODocument)((ODocument)record));
                        ODocumentSerializerDeltaDistributed.instance().deserializeDelta(req.getRecord(), (ODocument)record);
                        if (!req.isContentChanged()) {
                            record.setDirtyNoChanged();
                            break;
                        }
                        record.setDirty();
                        break;
                    }
                    record = ORecordSerializerNetworkDistributed.INSTANCE.fromStream(req.getRecord(), null);
                    ORecordInternal.setRecordSerializer((ORecord)record, (ORecordSerializer)database.getSerializer());
                    break;
                }
                case 2: {
                    record = (ORecord)database.load(req.getId());
                    if (record != null) break;
                    record = Orient.instance().getRecordFactoryManager().newInstance(req.getRecordType(), req.getId().getClusterId(), database);
                }
            }
            ORecordInternal.setIdentity(record, (ORecordId)((ORecordId)req.getId()));
            ORecordInternal.setVersion((ORecord)record, (int)req.getVersion());
            ORecordOperation op = new ORecordOperation((OIdentifiable)record, type);
            this.ops.add(op);
        }
        this.operations.clear();
    }

    public void toStream(DataOutput out) throws IOException {
        this.transactionId.write(out);
        out.writeInt(this.operations.size());
        for (ORecordOperationRequest operation : this.operations) {
            OMessageHelper.writeTransactionEntry((DataOutput)out, (ORecordOperationRequest)operation);
        }
        ORecordSerializerNetworkDistributed serializer = ORecordSerializerNetworkDistributed.INSTANCE;
        OTransactionPhase1Task.writeTxUniqueIndexKeys(this.uniqueIndexKeys, (ORecordSerializerNetworkV37)serializer, out);
    }

    public static void writeTxUniqueIndexKeys(SortedSet<OTransactionUniqueKey> uniqueIndexKeys, ORecordSerializerNetworkV37 serializer, DataOutput out) throws IOException {
        out.writeInt(uniqueIndexKeys.size());
        for (OTransactionUniqueKey pair : uniqueIndexKeys) {
            pair.write(serializer, out);
        }
    }

    public int getFactoryId() {
        return 43;
    }

    public void init(OTransactionId transactionId, OTransactionInternal tx) {
        this.transactionId = transactionId;
        this.extractUniqueIndexOps(tx);
        this.ops = new ArrayList<ORecordOperation>(tx.getRecordOperations());
        this.genOps(this.ops);
    }

    private void extractUniqueIndexOps(OTransactionInternal tx) {
        if (tx.getIndexOperations().isEmpty()) {
            return;
        }
        ODatabaseDocumentInternal database = tx.getDatabase();
        OAbstractPaginatedStorage storage = (OAbstractPaginatedStorage)database.getStorage();
        tx.getIndexOperations().forEach((index, changes) -> {
            OIndexInternal resolvedIndex = changes.resolveAssociatedIndex(index, database.getMetadata().getIndexManagerInternal(), database);
            if (resolvedIndex != null && resolvedIndex.isUnique()) {
                for (Object keyWithChange : changes.changesPerKey.keySet()) {
                    int version = storage.getVersionForKey(index, keyWithChange);
                    Object keyChange = OTransactionPhase1Task.mapKey(keyWithChange);
                    this.uniqueIndexKeys.add(new OTransactionUniqueKey((String)index, keyChange, version));
                }
                if (!changes.nullKeyChanges.isEmpty()) {
                    int version = storage.getVersionForKey(index, null);
                    this.uniqueIndexKeys.add(new OTransactionUniqueKey((String)index, null, version));
                }
            }
        });
    }

    public boolean isIdempotent() {
        return false;
    }

    public long getDistributedTimeout() {
        return super.getDistributedTimeout() + (long)(this.operations.size() / 10);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public List<ORecordOperation> getOps() {
        return this.ops;
    }

    public void received(final ODistributedRequest request, final ODistributedDatabase distributedDatabase) {
        if (this.notYetFinishedTask == null) {
            this.notYetFinishedTask = Orient.instance().scheduleTask(new Runnable(){

                @Override
                public void run() {
                    Orient.instance().submit(() -> {
                        if (!OTransactionPhase1Task.this.finished) {
                            ODistributedDatabaseImpl.sendResponseBack(this, distributedDatabase.getManager(), request.getId(), new OTransactionPhase1TaskResult(new OTxStillRunning()));
                        }
                    });
                }
            }, this.getDistributedTimeout(), this.getDistributedTimeout());
        }
        if (distributedDatabase instanceof ODistributedDatabaseImpl) {
            ((ODistributedDatabaseImpl)distributedDatabase).trackTransactions(this.transactionId);
        }
    }

    public void finished(ODistributedDatabase distributedDatabase) {
        if (this.notYetFinishedTask != null) {
            this.notYetFinishedTask.cancel();
        }
        if (distributedDatabase instanceof ODistributedDatabaseImpl) {
            ((ODistributedDatabaseImpl)distributedDatabase).untrackTransactions(this.transactionId);
        }
    }

    @Override
    public OTransactionId getTransactionId() {
        return this.transactionId;
    }

    @Override
    public SortedSet<ORID> getRids() {
        TreeSet<ORID> set = new TreeSet<ORID>();
        if (this.operations.size() > 0) {
            for (ORecordOperationRequest operation : this.operations) {
                OTransactionPhase1Task.mapRidOp(set, operation);
            }
        } else {
            for (ORecordOperation operation : this.ops) {
                OTransactionPhase1Task.mapRid(set, operation);
            }
        }
        return set;
    }

    @Override
    public SortedSet<OTransactionUniqueKey> getUniqueKeys() {
        return this.uniqueIndexKeys;
    }

    private static void mapRidOp(Set<ORID> set, ORecordOperationRequest operation) {
        if (operation.getType() == 3) {
            set.add((ORID)new ORecordId(operation.getId().getClusterId(), -1L));
        }
        set.add(operation.getId().copy());
    }

    public static void mapRid(Set<ORID> set, ORecordOperation operation) {
        if (operation.getType() == 3) {
            set.add((ORID)new ORecordId(operation.getRID().getClusterId(), -1L));
        }
        set.add(operation.getRID().copy());
    }

    public static Object mapKey(Object key) {
        if (key instanceof ORID) {
            if (((ORID)key).isNew()) {
                return new ORecordId(((ORID)key).getClusterId(), -1L);
            }
            return ((ORID)key).getIdentity().copy();
        }
        if (key instanceof OCompositeKey) {
            OCompositeKey cKey = (OCompositeKey)key;
            OCompositeKey newKey = new OCompositeKey();
            for (Object subKey : cKey.getKeys()) {
                newKey.addKey(OTransactionPhase1Task.mapKey(subKey));
            }
            return newKey;
        }
        return key;
    }
}

