/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkDistributed;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.task.OLockKeySource;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionUniqueKey;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;

public class OTransactionPhase2Task
extends OAbstractRemoteTask
implements OLockKeySource {
    public static final int FACTORYID = 44;
    private OTransactionId transactionId;
    private ODistributedRequestId firstPhaseId;
    private boolean success;
    private SortedSet<ORID> involvedRids;
    private SortedSet<OTransactionUniqueKey> uniqueIndexKeys = new TreeSet<OTransactionUniqueKey>();
    private boolean hasResponse = false;
    private volatile int retryCount = 0;

    public OTransactionPhase2Task(ODistributedRequestId firstPhaseId, boolean success, SortedSet<ORID> rids, SortedSet<OTransactionUniqueKey> uniqueIndexKeys, OTransactionId transactionId) {
        this.firstPhaseId = firstPhaseId;
        this.success = success;
        this.involvedRids = rids;
        this.uniqueIndexKeys = uniqueIndexKeys;
        this.transactionId = transactionId;
    }

    public OTransactionPhase2Task() {
    }

    public String getName() {
        return "TxPhase2";
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.transactionId = OTransactionId.read((DataInput)in);
        int nodeId = in.readInt();
        long messageId = in.readLong();
        this.firstPhaseId = new ODistributedRequestId(nodeId, messageId);
        int length = in.readInt();
        this.involvedRids = new TreeSet<ORID>();
        for (int i = 0; i < length; ++i) {
            this.involvedRids.add((ORID)ORecordId.deserialize((DataInput)in));
        }
        this.success = in.readBoolean();
        ORecordSerializerNetworkDistributed serializer = ORecordSerializerNetworkDistributed.INSTANCE;
        OTransactionPhase2Task.readTxUniqueIndexKeys(this.uniqueIndexKeys, (ORecordSerializerNetworkV37)serializer, in);
    }

    public static void readTxUniqueIndexKeys(SortedSet<OTransactionUniqueKey> uniqueIndexKeys, ORecordSerializerNetworkV37 serializer, DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            OTransactionUniqueKey entry = OTransactionUniqueKey.read(in, serializer);
            uniqueIndexKeys.add(entry);
        }
    }

    public void toStream(DataOutput out) throws IOException {
        this.transactionId.write(out);
        out.writeInt(this.firstPhaseId.getNodeId());
        out.writeLong(this.firstPhaseId.getMessageId());
        out.writeInt(this.involvedRids.size());
        for (ORID id : this.involvedRids) {
            ORecordId.serialize((ORID)id, (DataOutput)out);
        }
        out.writeBoolean(this.success);
        ORecordSerializerNetworkDistributed serializer = ORecordSerializerNetworkDistributed.INSTANCE;
        OTransactionPhase2Task.writeTxUniqueIndexKeys(this.uniqueIndexKeys, (ORecordSerializerNetworkV37)serializer, out);
    }

    public static void writeTxUniqueIndexKeys(SortedSet<OTransactionUniqueKey> uniqueIndexKeys, ORecordSerializerNetworkV37 serializer, DataOutput out) throws IOException {
        out.writeInt(uniqueIndexKeys.size());
        for (OTransactionUniqueKey pair : uniqueIndexKeys) {
            pair.write(serializer, out);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (this.success) {
            if (((ODatabaseDocumentDistributed)database).commit2pc(this.firstPhaseId, false, requestId)) {
                this.hasResponse = true;
                return "OK";
            }
            int autoRetryDelay = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY.getValueAsInteger();
            ++this.retryCount;
            if (this.retryCount < database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY)) {
                OLogManager.instance().info((Object)this, "Received second phase but not yet first phase, re-enqueue second phase", new Object[0]);
                ((ODatabaseDocumentDistributed)database).getDistributedShared().reEnqueue(requestId.getNodeId(), requestId.getMessageId(), database.getName(), (ORemoteTask)this, this.retryCount, autoRetryDelay);
                this.hasResponse = false;
                return "OK";
            }
            Orient.instance().submit(() -> {
                OLogManager.instance().warn((Object)this, "Reached limit of retry for commit tx:%s forcing database re-install", new Object[]{this.firstPhaseId});
                iManager.installDatabase(false, database.getName(), true, true);
            });
            this.hasResponse = true;
            return "KO";
        }
        if (((ODatabaseDocumentDistributed)database).rollback2pc(this.firstPhaseId)) {
            this.hasResponse = true;
            return "OK";
        }
        int autoRetryDelay = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY.getValueAsInteger();
        ++this.retryCount;
        if (this.retryCount < database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY)) {
            OLogManager.instance().info((Object)this, "Received second phase but not yet first phase, re-enqueue second phase", new Object[0]);
            ((ODatabaseDocumentDistributed)database).getDistributedShared().reEnqueue(requestId.getNodeId(), requestId.getMessageId(), database.getName(), (ORemoteTask)this, this.retryCount, autoRetryDelay);
            this.hasResponse = false;
            return "OK";
        }
        this.hasResponse = true;
        return "KO";
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public ODistributedRequestId getFirstPhaseId() {
        return this.firstPhaseId;
    }

    public boolean isIdempotent() {
        return false;
    }

    public boolean hasResponse() {
        return this.hasResponse;
    }

    public int getFactoryId() {
        return 44;
    }

    @Override
    public SortedSet<ORID> getRids() {
        return this.involvedRids;
    }

    @Override
    public SortedSet<OTransactionUniqueKey> getUniqueKeys() {
        return this.uniqueIndexKeys;
    }

    @Override
    public OTransactionId getTransactionId() {
        return this.transactionId;
    }
}

