/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task.transaction;

import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.core.tx.OTransactionSequenceStatus;
import com.orientechnologies.orient.core.tx.ValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class OTransactionSequenceManager {
    private volatile long[] sequentials;
    private volatile OTransactionId[] promisedSequential;
    private final String node;
    private final int sequenceSize;

    public OTransactionSequenceManager(String node, int size) {
        this.sequentials = new long[size];
        this.promisedSequential = new OTransactionId[size];
        this.node = node;
        this.sequenceSize = size;
    }

    public synchronized void fill(OTransactionSequenceStatus data) {
        this.sequentials = data.getStatus();
        this.promisedSequential = new OTransactionId[this.sequentials.length];
    }

    public synchronized Optional<OTransactionId> next() {
        int pos;
        int retry = 0;
        do {
            pos = new Random().nextInt(this.sequenceSize);
            if (retry > this.sequenceSize) {
                return Optional.empty();
            }
            ++retry;
        } while (this.promisedSequential[pos] != null);
        return Optional.of(this.nextAt(pos));
    }

    public synchronized OTransactionId nextAt(int pos) {
        OTransactionId id;
        this.promisedSequential[pos] = id = new OTransactionId(Optional.of(this.node), pos, this.sequentials[pos] + 1L);
        return id;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized ValidationResult notifySuccess(OTransactionId transactionId) {
        if (this.promisedSequential[transactionId.getPosition()] != null) {
            if (this.promisedSequential[transactionId.getPosition()].getSequence() == transactionId.getSequence()) {
                this.sequentials[transactionId.getPosition()] = transactionId.getSequence();
                this.promisedSequential[transactionId.getPosition()] = null;
                return ValidationResult.VALID;
            }
            if (this.promisedSequential[transactionId.getPosition()].getSequence() <= transactionId.getSequence()) return ValidationResult.MISSING_PREVIOUS;
            return ValidationResult.ALREADY_PRESENT;
        }
        if (this.sequentials[transactionId.getPosition()] + 1L == transactionId.getSequence()) {
            this.sequentials[transactionId.getPosition()] = transactionId.getSequence();
            return ValidationResult.VALID;
        }
        if (this.sequentials[transactionId.getPosition()] + 1L <= transactionId.getSequence()) return ValidationResult.MISSING_PREVIOUS;
        return ValidationResult.ALREADY_PRESENT;
    }

    public synchronized ValidationResult validateTransactionId(OTransactionId transactionId) {
        if (this.promisedSequential[transactionId.getPosition()] == null) {
            if (this.sequentials[transactionId.getPosition()] + 1L == transactionId.getSequence()) {
                this.promisedSequential[transactionId.getPosition()] = transactionId;
                return ValidationResult.VALID;
            }
            if (this.sequentials[transactionId.getPosition()] + 1L < transactionId.getSequence()) {
                return ValidationResult.MISSING_PREVIOUS;
            }
            return ValidationResult.ALREADY_PRESENT;
        }
        if (this.sequentials[transactionId.getPosition()] + 1L == transactionId.getSequence()) {
            if (this.promisedSequential[transactionId.getPosition()].getNodeOwner().equals(transactionId.getNodeOwner())) {
                return ValidationResult.VALID;
            }
            return ValidationResult.ALREADY_PROMISED;
        }
        if (this.sequentials[transactionId.getPosition()] + 1L < transactionId.getSequence()) {
            return ValidationResult.MISSING_PREVIOUS;
        }
        return ValidationResult.ALREADY_PRESENT;
    }

    public synchronized List<OTransactionId> checkSelfStatus(OTransactionSequenceStatus sequenceStatus) {
        long[] status = sequenceStatus.getStatus();
        ArrayList<OTransactionId> missing = new ArrayList<OTransactionId>();
        for (int i = 0; i < status.length; ++i) {
            long x;
            if (this.sequentials[i] >= status[i]) continue;
            if (this.promisedSequential[i] == null) {
                for (x = this.sequentials[i] + 1L; x <= status[i]; ++x) {
                    missing.add(new OTransactionId(Optional.empty(), i, x));
                }
                continue;
            }
            if (this.promisedSequential[i].getSequence() == status[i]) continue;
            for (x = (long)(this.promisedSequential[i].getPosition() + 1); x <= status[i]; ++x) {
                missing.add(new OTransactionId(Optional.empty(), i, x));
            }
        }
        return missing;
    }

    public synchronized List<OTransactionId> checkOtherStatus(OTransactionSequenceStatus sequenceStatus) {
        long[] status = sequenceStatus.getStatus();
        ArrayList<OTransactionId> missing = new ArrayList<OTransactionId>();
        for (int i = 0; i < status.length; ++i) {
            if (this.sequentials[i] <= status[i]) continue;
            for (long x = status[i] + 1L; x <= this.sequentials[i]; ++x) {
                missing.add(new OTransactionId(Optional.empty(), i, x));
            }
        }
        return missing;
    }

    public synchronized boolean notifyFailure(OTransactionId id) {
        OTransactionId promised = this.promisedSequential[id.getPosition()];
        if (promised != null && promised.getSequence() == id.getSequence() && promised.getNodeOwner().equals(id.getNodeOwner())) {
            this.promisedSequential[id.getPosition()] = null;
            return true;
        }
        return false;
    }

    public synchronized OTransactionSequenceStatus currentStatus() {
        return new OTransactionSequenceStatus(Arrays.copyOf(this.sequentials, this.sequentials.length));
    }
}

