/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task.transaction;

import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OTransactionUniqueKey
implements Comparable<OTransactionUniqueKey> {
    private String index;
    private Object key;
    private int version;

    public OTransactionUniqueKey(String index, Object key, int version) {
        this.index = index;
        this.key = key;
        this.version = version;
        assert (key instanceof Comparable || key == null);
    }

    public String getIndex() {
        return this.index;
    }

    public Object getKey() {
        return this.key;
    }

    public int getVersion() {
        return this.version;
    }

    public void write(ORecordSerializerNetworkV37 serializer, DataOutput out) throws IOException {
        out.writeUTF(this.getIndex());
        if (this.getKey() == null) {
            out.writeByte(-1);
        } else if (this.getKey() instanceof OCompositeKey) {
            out.writeByte(-2);
            ((OCompositeKey)this.getKey()).toStream(serializer, out);
        } else {
            OType type = OType.getTypeByValue((Object)this.getKey());
            byte[] bytes = serializer.serializeValue(this.getKey(), type);
            out.writeByte((byte)type.getId());
            out.writeInt(bytes.length);
            out.write(bytes);
        }
        out.writeInt(this.getVersion());
    }

    public static OTransactionUniqueKey read(DataInput in, ORecordSerializerNetworkV37 serializer) throws IOException {
        Object key;
        String index = in.readUTF();
        byte b = in.readByte();
        if (b == -1) {
            key = null;
        } else if (b == -2) {
            OCompositeKey compositeKey = new OCompositeKey();
            compositeKey.fromStream(serializer, in);
            key = compositeKey;
        } else {
            OType type = OType.getById((byte)b);
            int len = in.readInt();
            byte[] bytes = new byte[len];
            in.readFully(bytes);
            key = serializer.deserializeValue(bytes, type);
        }
        int version = in.readInt();
        return new OTransactionUniqueKey(index, key, version);
    }

    @Override
    public int compareTo(OTransactionUniqueKey o) {
        int indexCompare = this.index.compareTo(o.index);
        if (indexCompare == 0) {
            if (this.key == null) {
                if (o.key == null) {
                    return 0;
                }
                return -1;
            }
            if (o.key == null) {
                return 1;
            }
            return ((Comparable)this.key).compareTo(o.key);
        }
        return indexCompare;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OTransactionUniqueKey other = (OTransactionUniqueKey)obj;
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return this.version == other.version;
    }
}

