/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OHaRemoveServerStatement;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODistributedPlugin;
import java.util.Map;

public class OCommandExecutorSQLHARemoveServer
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "HA REMOVE SERVER";
    private OHaRemoveServerStatement parsedStatement;

    public OCommandExecutorSQLHARemoveServer parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        try {
            this.parsedStatement = (OHaRemoveServerStatement)OStatementCache.get((String)this.parserText, (ODatabaseDocumentInternal)OCommandExecutorSQLHARemoveServer.getDatabase());
            this.preParsedStatement = this.parsedStatement;
        }
        catch (OCommandSQLParsingException sqlx) {
            throw sqlx;
        }
        catch (Exception e) {
            this.throwParsingException("Error parsing query: \n" + this.parserText + "\n" + e.getMessage(), e);
        }
        return this;
    }

    public Object execute(Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLHARemoveServer.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SERVER, "remove", ORole.PERMISSION_EXECUTE);
        if (!(database instanceof ODatabaseDocumentDistributed)) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        ODistributedPlugin dManager = (ODistributedPlugin)((ODatabaseDocumentDistributed)database).getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = database.getName();
        return dManager.removeNodeFromConfiguration(this.parsedStatement.serverName.getStringValue(), databaseName, false, true);
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    public String getSyntax() {
        return "HA REMOVE SERVER <server-name>";
    }
}

