/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OHaSyncDatabaseStatement;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import java.util.Map;

public class OCommandExecutorSQLHASyncDatabase
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "HA SYNC DATABASE";
    private OHaSyncDatabaseStatement parsedStatement;

    public OCommandExecutorSQLHASyncDatabase parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        try {
            this.parsedStatement = (OHaSyncDatabaseStatement)OStatementCache.get((String)this.parserText, (ODatabaseDocumentInternal)OCommandExecutorSQLHASyncDatabase.getDatabase());
            this.preParsedStatement = this.parsedStatement;
        }
        catch (OCommandSQLParsingException sqlx) {
            throw sqlx;
        }
        catch (Exception e) {
            this.throwParsingException("Error parsing query: \n" + this.parserText + "\n" + e.getMessage(), e);
        }
        return this;
    }

    public Object execute(Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLHASyncDatabase.getDatabase();
        return database.sync(this.parsedStatement.isForce(), !this.parsedStatement.isFull());
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    public long getDistributedTimeout() {
        return OCommandExecutorSQLHASyncDatabase.getDatabase().getConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT);
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public String getSyntax() {
        return "HA SYNC DATABASE [-force] [-full]";
    }
}

