/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ILock;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OCallableNoParamNoReturn;
import com.orientechnologies.common.util.OCallableUtils;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedLockManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStartupException;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedPlugin;
import com.orientechnologies.orient.server.hazelcast.OHazelcastDistributedMap;
import com.orientechnologies.orient.server.hazelcast.OHazelcastLockManager;
import com.orientechnologies.orient.server.hazelcast.OHazelcastMergeStrategy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class OHazelcastClusterMetadataManager
implements MembershipListener,
EntryListener<String, Object>,
LifecycleListener {
    public static final String CONFIG_DATABASE_PREFIX = "database.";
    public static final String CONFIG_NODE_PREFIX = "node.";
    public static final String CONFIG_DBSTATUS_PREFIX = "dbstatus.";
    public static final String CONFIG_REGISTEREDNODES = "registeredNodes";
    protected String hazelcastConfigFile = "hazelcast.xml";
    protected Config hazelcastConfig;
    protected String membershipListenerRegistration;
    protected String membershipListenerMapRegistration;
    protected volatile HazelcastInstance hazelcastInstance;
    protected OHazelcastDistributedMap configurationMap;
    private ODistributedLockManager distributedLockManager;
    protected ConcurrentMap<String, Member> activeNodes = new ConcurrentHashMap<String, Member>();
    protected ConcurrentMap<String, String> activeNodesNamesByUuid = new ConcurrentHashMap<String, String>();
    protected ConcurrentMap<String, String> activeNodesUuidByName = new ConcurrentHashMap<String, String>();
    protected final List<String> registeredNodeById = new CopyOnWriteArrayList<String>();
    protected final ConcurrentMap<String, Integer> registeredNodeByName = new ConcurrentHashMap<String, Integer>();
    protected ConcurrentMap<String, Long> autoRemovalOfServers = new ConcurrentHashMap<String, Long>();
    protected TimerTask publishLocalNodeConfigurationTask = null;
    protected volatile ODistributedServerManager.NODE_STATUS status = ODistributedServerManager.NODE_STATUS.OFFLINE;
    protected long lastClusterChangeOn;
    private String nodeUuid;
    private int nodeId = -1;
    private String nodeName = null;
    private OServer serverInstance;
    private final ODistributedPlugin distributedPlugin;

    public OHazelcastClusterMetadataManager(ODistributedPlugin distributedPlugin) {
        this.distributedPlugin = distributedPlugin;
    }

    public void configHazelcastPlugin(OServer server, OServerParameterConfiguration[] params, String nodeName) {
        this.nodeName = nodeName;
        this.serverInstance = server;
        for (OServerParameterConfiguration param : params) {
            if (!param.name.equalsIgnoreCase("configuration.hazelcast")) continue;
            this.hazelcastConfigFile = OSystemVariableResolver.resolveSystemVariables((String)param.value);
            this.hazelcastConfigFile = OFileUtils.getPath((String)this.hazelcastConfigFile);
        }
    }

    public void startupHazelcastPlugin() throws IOException, InterruptedException {
        this.status = ODistributedServerManager.NODE_STATUS.STARTING;
        String localNodeName = this.nodeName;
        this.activeNodes.clear();
        this.activeNodesNamesByUuid.clear();
        this.activeNodesUuidByName.clear();
        this.registeredNodeById.clear();
        this.registeredNodeByName.clear();
        this.hazelcastInstance = this.configureHazelcast();
        this.distributedLockManager = new OHazelcastLockManager(this.hazelcastInstance);
        this.nodeUuid = this.hazelcastInstance.getCluster().getLocalMember().getUuid();
        LifecycleService lifecycleService = this.hazelcastInstance.getLifecycleService();
        lifecycleService.addLifecycleListener((LifecycleListener)this);
        OLogManager.instance().info((Object)this, "Starting distributed server '%s' (hzID=%s)...", new Object[]{localNodeName, this.nodeUuid});
        long clusterTime = this.getClusterTime();
        long deltaTime = System.currentTimeMillis() - clusterTime;
        OLogManager.instance().info((Object)this, "Distributed cluster time=%s (delta from local node=%d)...", new Object[]{new Date(clusterTime), deltaTime});
        this.activeNodes.put(localNodeName, this.hazelcastInstance.getCluster().getLocalMember());
        this.activeNodesNamesByUuid.put(this.nodeUuid, localNodeName);
        this.activeNodesUuidByName.put(localNodeName, this.nodeUuid);
        this.configurationMap = new OHazelcastDistributedMap(this, this.hazelcastInstance);
        OServer.registerServerInstance((String)localNodeName, (OServer)this.serverInstance);
        this.initRegisteredNodeIds();
        ODocument nodeCfg = new ODocument();
        nodeCfg.setTrackingChanges(false);
        HashSet node2Remove = new HashSet();
        for (Map.Entry entry : this.configurationMap.getHazelcastMap().entrySet()) {
            ODocument nCfg;
            if (!((String)entry.getKey()).startsWith(CONFIG_NODE_PREFIX) || !this.nodeName.equals((nCfg = (ODocument)entry.getValue()).field("name"))) continue;
            node2Remove.add(entry.getKey());
        }
        for (String n : node2Remove) {
            this.configurationMap.getHazelcastMap().remove((Object)n);
        }
        nodeCfg.field("id", (Object)this.nodeId);
        nodeCfg.field("uuid", (Object)this.nodeUuid);
        nodeCfg.field("name", (Object)this.nodeName);
        ORecordInternal.setRecordSerializer((ORecord)nodeCfg, (ORecordSerializer)ODatabaseDocumentAbstract.getDefaultSerializer());
        this.configurationMap.put(CONFIG_NODE_PREFIX + this.nodeUuid, (Object)nodeCfg);
        for (Member m : this.hazelcastInstance.getCluster().getMembers()) {
            if (m.getUuid().equals(this.nodeUuid)) continue;
            boolean found = false;
            for (int retry = 0; retry < 10; ++retry) {
                String memberName = this.getNodeName(m, false);
                if (memberName != null && !memberName.startsWith("ext:")) {
                    found = true;
                    this.activeNodes.put(memberName, m);
                    this.activeNodesNamesByUuid.put(m.getUuid(), memberName);
                    this.activeNodesUuidByName.put(memberName, m.getUuid());
                    break;
                }
                Thread.sleep(1000L);
            }
            if (found) continue;
            ODistributedServerLog.warn((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot find configuration for member: %s, uuid", (Object[])new Object[]{m, m.getUuid()});
        }
        ODistributedServerLog.info((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Servers in cluster: %s", (Object[])new Object[]{this.activeNodes.keySet()});
        this.publishLocalNodeConfiguration();
        if (!this.configurationMap.containsKey(CONFIG_NODE_PREFIX + this.nodeUuid)) {
            ODistributedServerLog.error((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on registering local node on cluster", (Object[])new Object[0]);
            throw new ODistributedStartupException("Error on registering local node on cluster");
        }
        this.distributedPlugin.connectToAllNodes(this.activeNodes.keySet());
        this.publishLocalNodeConfiguration();
        new Thread(() -> {
            this.distributedPlugin.installNewDatabasesFromCluster();
            this.distributedPlugin.loadLocalDatabases();
            this.distributedPlugin.notifyStarted();
        }).start();
        this.membershipListenerMapRegistration = this.configurationMap.getHazelcastMap().addEntryListener((EntryListener)this, true);
        this.membershipListenerRegistration = this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)this);
        this.setNodeStatus(ODistributedServerManager.NODE_STATUS.ONLINE);
        this.publishLocalNodeConfiguration();
        long delay = OGlobalConfiguration.DISTRIBUTED_PUBLISH_NODE_STATUS_EVERY.getValueAsLong();
        if (delay > 0L) {
            this.publishLocalNodeConfigurationTask = Orient.instance().scheduleTask(this::publishLocalNodeConfiguration, delay, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRegisteredNodeIds() {
        ILock lock = this.hazelcastInstance.getLock("orientdb.registeredNodes");
        lock.lock();
        try {
            this.registeredNodeById.clear();
            this.registeredNodeByName.clear();
            ODocument registeredNodesFromCluster = new ODocument();
            String registeredNodesFromClusterAsJson = (String)this.configurationMap.get(CONFIG_REGISTEREDNODES);
            if (registeredNodesFromClusterAsJson != null) {
                registeredNodesFromCluster.fromJSON(registeredNodesFromClusterAsJson);
                this.registeredNodeById.addAll((Collection)registeredNodesFromCluster.field("ids", OType.EMBEDDEDLIST));
                this.registeredNodeByName.putAll((Map)registeredNodesFromCluster.field("names", OType.EMBEDDEDMAP));
                if (this.registeredNodeByName.containsKey(this.nodeName)) {
                    this.nodeId = (Integer)this.registeredNodeByName.get(this.nodeName);
                } else {
                    this.registeredNodeById.add(this.nodeName);
                    this.nodeId = this.registeredNodeById.size() - 1;
                    this.registeredNodeByName.put(this.nodeName, this.nodeId);
                }
            } else if (this.hazelcastInstance.getCluster().getMembers().size() <= 1) {
                this.nodeId = 0;
                this.registeredNodeById.add(this.nodeName);
                this.registeredNodeByName.put(this.nodeName, this.nodeId);
            } else {
                this.repairActiveServers();
            }
            ODistributedServerLog.info((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Registered local server with nodeId=%d", (Object[])new Object[]{this.nodeId});
            registeredNodesFromCluster.field("ids", this.registeredNodeById, new OType[]{OType.EMBEDDEDLIST});
            registeredNodesFromCluster.field("names", this.registeredNodeByName, new OType[]{OType.EMBEDDEDMAP});
            this.configurationMap.put(CONFIG_REGISTEREDNODES, (Object)registeredNodesFromCluster.toJSON());
        }
        finally {
            lock.unlock();
        }
        if (this.nodeId == -1) {
            throw new OConfigurationException("Cannot join the cluster (nodeId=-1). Please restart the server.");
        }
    }

    private void repairActiveServers() {
        ODistributedServerLog.warn((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on retrieving '%s' from cluster configuration. Repairing the configuration...", (Object[])new Object[]{CONFIG_REGISTEREDNODES});
        Set members = this.hazelcastInstance.getCluster().getMembers();
        for (Member m : members) {
            ODocument node = (ODocument)this.configurationMap.get(CONFIG_NODE_PREFIX + m.getUuid());
            if (node == null) continue;
            String mName = (String)node.field("name");
            Integer mId = (Integer)node.field("id");
            if (mId == null) {
                ODistributedServerLog.warn((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Found server '%s' with a NULL id", (Object[])new Object[]{mName});
                continue;
            }
            if (mId < 0) {
                ODistributedServerLog.warn((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Found server '%s' with an invalid id %d", (Object[])new Object[]{mName, mId});
                continue;
            }
            if (this.nodeName.equals(mName)) {
                this.nodeId = mId;
            }
            if (mId >= this.registeredNodeById.size()) {
                while (mId > this.registeredNodeById.size()) {
                    this.registeredNodeById.add(null);
                }
                this.registeredNodeById.add(mName);
            } else {
                this.registeredNodeById.set(mId, mName);
            }
            this.registeredNodeByName.put(mName, mId);
        }
        ODistributedServerLog.warn((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Repairing of '%s' completed, registered %d servers", (Object[])new Object[]{CONFIG_REGISTEREDNODES, members.size()});
    }

    public boolean isWriteQuorumPresent(String databaseName) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(databaseName);
        if (cfg != null) {
            int availableServers = this.getAvailableNodes(databaseName);
            if (availableServers == 0) {
                return false;
            }
            int quorum = cfg.getWriteQuorum(null, cfg.getMasterServers().size(), this.nodeName);
            return availableServers >= quorum;
        }
        return false;
    }

    public int getNodeIdByName(String name) {
        int id = this.tryGetNodeIdByName(name);
        if (name == null) {
            this.repairActiveServers();
            id = this.tryGetNodeIdByName(name);
        }
        return id;
    }

    public String getNodeNameById(int id) {
        String name = this.tryGetNodeNameById(id);
        if (name == null) {
            this.repairActiveServers();
            name = this.tryGetNodeNameById(id);
        }
        return name;
    }

    public boolean isNodeAvailable(String iNodeName) {
        if (iNodeName == null) {
            return false;
        }
        Member member = (Member)this.activeNodes.get(iNodeName);
        return member != null && this.hazelcastInstance.getCluster().getMembers().contains(member);
    }

    public boolean isNodeAvailable(String iNodeName, String iDatabaseName) {
        ODistributedServerManager.DB_STATUS s = this.getDatabaseStatus(iNodeName, iDatabaseName);
        return s != ODistributedServerManager.DB_STATUS.OFFLINE && s != ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
    }

    protected void publishLocalNodeConfiguration() {
        try {
            ODocument cfg = this.distributedPlugin.getLocalNodeConfiguration();
            ORecordInternal.setRecordSerializer((ORecord)cfg, (ORecordSerializer)ODatabaseDocumentAbstract.getDefaultSerializer());
            this.configurationMap.put(CONFIG_NODE_PREFIX + this.nodeUuid, (Object)cfg);
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on publishing local server configuration", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public long getClusterTime() {
        if (this.hazelcastInstance == null) {
            throw new HazelcastInstanceNotActiveException();
        }
        try {
            return this.hazelcastInstance.getCluster().getClusterTime();
        }
        catch (HazelcastInstanceNotActiveException e) {
            return -1L;
        }
    }

    public ODistributedLockManager getLockManagerRequester() {
        return this.distributedLockManager;
    }

    public ODistributedLockManager getLockManagerExecutor() {
        return this.distributedLockManager;
    }

    public void prepareHazelcastPluginShutdown() {
        try {
            HashSet databases = new HashSet();
            if (this.hazelcastInstance != null && this.hazelcastInstance.getLifecycleService().isRunning()) {
                for (Map.Entry entry : this.configurationMap.entrySet()) {
                    String nodeDb;
                    if (!((String)entry.getKey()).startsWith(CONFIG_DBSTATUS_PREFIX) || !(nodeDb = ((String)entry.getKey()).substring(CONFIG_DBSTATUS_PREFIX.length())).startsWith(this.nodeName)) continue;
                    databases.add(entry.getKey());
                }
            }
            for (String string : databases) {
                this.configurationMap.put(string, (Object)ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
            }
        }
        catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
            // empty catch block
        }
        if (this.publishLocalNodeConfigurationTask != null) {
            this.publishLocalNodeConfigurationTask.cancel();
        }
    }

    public void hazelcastPluginShutdown() {
        this.activeNodes.clear();
        this.activeNodesNamesByUuid.clear();
        this.activeNodesUuidByName.clear();
        if (this.membershipListenerRegistration != null) {
            try {
                Cluster instance = this.hazelcastInstance.getCluster();
                if (instance != null) {
                    instance.removeMembershipListener(this.membershipListenerRegistration);
                }
            }
            catch (HazelcastInstanceNotActiveException instance) {
                // empty catch block
            }
        }
        if (this.hazelcastInstance != null) {
            try {
                this.hazelcastInstance.shutdown();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on shutting down Hazelcast instance", (Throwable)e, new Object[0]);
            }
            finally {
                this.hazelcastInstance = null;
            }
        }
        OCallableUtils.executeIgnoringAnyExceptions((OCallableNoParamNoReturn)new OCallableNoParamNoReturn(){

            public void call() {
                OHazelcastClusterMetadataManager.this.configurationMap.destroy();
            }
        });
        OCallableUtils.executeIgnoringAnyExceptions((OCallableNoParamNoReturn)new OCallableNoParamNoReturn(){

            public void call() {
                OHazelcastClusterMetadataManager.this.configurationMap.getHazelcastMap().removeEntryListener(OHazelcastClusterMetadataManager.this.membershipListenerMapRegistration);
            }
        });
        this.setNodeStatus(ODistributedServerManager.NODE_STATUS.OFFLINE);
        OServer.unregisterServerInstance((String)this.nodeName);
    }

    public Member getClusterMemberByName(String rNodeName) {
        Member member = (Member)this.activeNodes.get(rNodeName);
        if (member == null) {
            block0: for (Map.Entry<String, Object> entry : this.getConfigurationMap().localEntrySet()) {
                ODocument nodeCfg;
                if (!entry.getKey().startsWith(CONFIG_NODE_PREFIX) || !rNodeName.equals((nodeCfg = (ODocument)entry.getValue()).field("name"))) continue;
                String uuid = entry.getKey().substring(CONFIG_NODE_PREFIX.length());
                for (Member m : this.hazelcastInstance.getCluster().getMembers()) {
                    if (!m.getUuid().equals(uuid)) continue;
                    member = m;
                    this.registerNode(member, rNodeName);
                    continue block0;
                }
            }
            if (member == null) {
                throw new ODistributedException("Cannot find node '" + rNodeName + "'");
            }
        }
        return member;
    }

    public HazelcastInstance getHazelcastInstance() {
        int retry = 1;
        while (this.hazelcastInstance == null && !Thread.currentThread().isInterrupted()) {
            if (retry > 25) {
                throw new ODistributedException("Hazelcast instance is not available");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            ++retry;
        }
        return this.hazelcastInstance;
    }

    protected HazelcastInstance configureHazelcast() throws FileNotFoundException {
        if (this.hazelcastConfig == null) {
            this.hazelcastConfig = new FileSystemXmlConfig(this.hazelcastConfigFile);
            this.hazelcastConfig.setClassLoader(this.getClass().getClassLoader());
        }
        this.hazelcastConfig.getMapConfig(CONFIG_REGISTEREDNODES).setBackupCount(6);
        this.hazelcastConfig.getMapConfig("orientdb").setMergePolicy(OHazelcastMergeStrategy.class.getName());
        this.hazelcastConfig.setProperty("hazelcast.shutdownhook.enabled", "false");
        return Hazelcast.newHazelcastInstance((Config)this.hazelcastConfig);
    }

    public String getPublicAddress() {
        return this.hazelcastConfig.getNetworkConfig().getPublicAddress();
    }

    public OHazelcastDistributedMap getConfigurationMap() {
        return this.configurationMap;
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    public boolean updateCachedDatabaseConfiguration(String databaseName, OModifiableDistributedConfiguration cfg, boolean iDeployToCluster) {
        this.distributedPlugin.getDistributedStrategy().validateConfiguration((ODistributedConfiguration)cfg);
        boolean updated = this.tryUpdatingDatabaseConfigurationLocally(databaseName, cfg);
        if (!updated && !this.getConfigurationMap().containsKey(CONFIG_DATABASE_PREFIX + databaseName)) {
            updated = true;
        }
        ODocument document = cfg.getDocument();
        if (updated) {
            if (iDeployToCluster) {
                ORecordInternal.setRecordSerializer((ORecord)document, (ORecordSerializer)ODatabaseDocumentAbstract.getDefaultSerializer());
                this.configurationMap.put(CONFIG_DATABASE_PREFIX + databaseName, (Object)document);
                this.distributedPlugin.onDbConfigUpdated(databaseName, document, updated, iDeployToCluster);
            } else {
                this.configurationMap.putInLocalCache(CONFIG_DATABASE_PREFIX + databaseName, document);
            }
            this.serverInstance.getClientConnectionManager().pushDistribCfg2Clients(this.getClusterConfiguration());
            this.distributedPlugin.dumpServersStatus();
        }
        return updated;
    }

    public boolean tryUpdatingDatabaseConfigurationLocally(String iDatabaseName, OModifiableDistributedConfiguration cfg) {
        int currVersion;
        boolean modified;
        Integer oldVersion;
        ODistributedDatabaseImpl local = this.distributedPlugin.getMessageService().getDatabase(iDatabaseName);
        if (local == null) {
            return false;
        }
        ODistributedConfiguration dCfg = local.getDistributedConfiguration();
        ODocument oldCfg = dCfg != null ? dCfg.getDocument() : null;
        Integer n = oldVersion = oldCfg != null ? (Integer)oldCfg.field("version") : null;
        if (oldVersion == null) {
            oldVersion = 0;
        }
        boolean bl = modified = (currVersion = cfg.getVersion()) > oldVersion;
        if (oldCfg != null && !modified) {
            OLogManager.instance().debug((Object)this, "Skip saving of distributed configuration file for database '%s' because is unchanged (version %d)", new Object[]{iDatabaseName, currVersion});
            return false;
        }
        local.setDistributedConfiguration(cfg);
        ODistributedServerLog.info((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Broadcasting new distributed configuration for database: %s (version=%d)\n", (Object[])new Object[]{iDatabaseName, currVersion});
        return modified;
    }

    public void entryAdded(EntryEvent<String, Object> iEvent) {
        if (this.hazelcastInstance == null || !this.hazelcastInstance.getLifecycleService().isRunning()) {
            return;
        }
        try {
            if (iEvent.getMember() == null) {
                return;
            }
            String eventNodeName = this.getNodeName(iEvent.getMember(), true);
            if ("?".equals(eventNodeName)) {
                return;
            }
            String key = (String)iEvent.getKey();
            if (key.startsWith(CONFIG_NODE_PREFIX)) {
                if (!iEvent.getMember().equals(this.hazelcastInstance.getCluster().getLocalMember())) {
                    ODocument cfg = (ODocument)iEvent.getValue();
                    String joinedNodeName = (String)cfg.field("name");
                    if (this.nodeName.equals(joinedNodeName)) {
                        ODistributedServerLog.error((Object)this, (String)joinedNodeName, (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)("Found a new node (%s) with the same name as current: '" + joinedNodeName + "'. The node has been excluded. Change the name in its config/orientdb-dserver-config.xml file"), (Object[])new Object[]{iEvent.getMember()});
                        throw new ODistributedException("Found a new node (" + iEvent.getMember().toString() + ") with the same name as current: '" + joinedNodeName + "'. The node has been excluded. Change the name in its config/orientdb-dserver-config.xml file");
                    }
                    this.registerNode(iEvent.getMember(), joinedNodeName);
                }
            } else if (key.startsWith(CONFIG_DBSTATUS_PREFIX)) {
                ODistributedServerLog.info((Object)this, (String)this.nodeName, (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Received new status %s=%s", (Object[])new Object[]{key.substring(CONFIG_DBSTATUS_PREFIX.length()), iEvent.getValue()});
                String dbNode = key.substring(CONFIG_DBSTATUS_PREFIX.length());
                String nodeName = dbNode.substring(0, dbNode.indexOf("."));
                String databaseName = dbNode.substring(dbNode.indexOf(".") + 1);
                this.distributedPlugin.onDatabaseEvent(nodeName, databaseName, (ODistributedServerManager.DB_STATUS)iEvent.getValue());
                this.distributedPlugin.invokeOnDatabaseStatusChange(nodeName, databaseName, (ODistributedServerManager.DB_STATUS)iEvent.getValue());
                if (!iEvent.getMember().equals(this.hazelcastInstance.getCluster().getLocalMember()) && ODistributedServerManager.DB_STATUS.ONLINE.equals(iEvent.getValue())) {
                    this.distributedPlugin.onDbStatusOnline(databaseName);
                }
            }
        }
        catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
            OLogManager.instance().error((Object)this, "Hazelcast is not running", e, new Object[0]);
        }
    }

    public void entryUpdated(EntryEvent<String, Object> iEvent) {
        if (this.hazelcastInstance == null || !this.hazelcastInstance.getLifecycleService().isRunning()) {
            return;
        }
        try {
            String key = (String)iEvent.getKey();
            String eventNodeName = this.getNodeName(iEvent.getMember(), true);
            if ("?".equals(eventNodeName)) {
                return;
            }
            if (key.startsWith(CONFIG_NODE_PREFIX)) {
                ODistributedServerLog.debug((Object)this, (String)this.nodeName, (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Updated node configuration id=%s name=%s", (Object[])new Object[]{iEvent.getMember(), eventNodeName});
                ODocument cfg = (ODocument)iEvent.getValue();
                String name = (String)cfg.field("name");
                if (!this.activeNodes.containsKey(name)) {
                    this.updateLastClusterChange();
                }
                this.activeNodes.put(name, iEvent.getMember());
                if (iEvent.getMember().getUuid() != null) {
                    this.activeNodesNamesByUuid.put(iEvent.getMember().getUuid(), name);
                    this.activeNodesUuidByName.put(name, iEvent.getMember().getUuid());
                }
                this.distributedPlugin.dumpServersStatus();
            } else if (key.startsWith(CONFIG_DBSTATUS_PREFIX)) {
                ODistributedServerLog.info((Object)this, (String)this.nodeName, (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Received updated status %s=%s", (Object[])new Object[]{key.substring(CONFIG_DBSTATUS_PREFIX.length()), iEvent.getValue()});
                String dbNode = key.substring(CONFIG_DBSTATUS_PREFIX.length());
                String nodeName = dbNode.substring(0, dbNode.indexOf("."));
                String databaseName = dbNode.substring(dbNode.indexOf(".") + 1);
                this.distributedPlugin.onDatabaseEvent(nodeName, databaseName, (ODistributedServerManager.DB_STATUS)iEvent.getValue());
                this.distributedPlugin.invokeOnDatabaseStatusChange(nodeName, databaseName, (ODistributedServerManager.DB_STATUS)iEvent.getValue());
                if (!iEvent.getMember().equals(this.hazelcastInstance.getCluster().getLocalMember()) && ODistributedServerManager.DB_STATUS.ONLINE.equals(iEvent.getValue())) {
                    this.distributedPlugin.onDbStatusOnline(databaseName);
                }
            } else if (key.startsWith(CONFIG_REGISTEREDNODES)) {
                ODistributedServerLog.info((Object)this, (String)this.nodeName, (String)eventNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Received updated about registered nodes", (Object[])new Object[0]);
                this.reloadRegisteredNodes((String)iEvent.getValue());
            }
        }
        catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
            OLogManager.instance().error((Object)this, "Hazelcast is not running", e, new Object[0]);
        }
    }

    public void entryRemoved(EntryEvent<String, Object> iEvent) {
        if (this.hazelcastInstance == null || !this.hazelcastInstance.getLifecycleService().isRunning()) {
            return;
        }
        try {
            String key = (String)iEvent.getKey();
            String eventNodeName = this.getNodeName(iEvent.getMember(), true);
            if ("?".equals(eventNodeName)) {
                return;
            }
            if (key.startsWith(CONFIG_NODE_PREFIX)) {
                if (eventNodeName != null) {
                    ODistributedServerLog.debug((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Removed node configuration id=%s name=%s", (Object[])new Object[]{iEvent.getMember(), eventNodeName});
                    this.activeNodes.remove(eventNodeName);
                    this.activeNodesNamesByUuid.remove(iEvent.getMember().getUuid());
                    this.activeNodesUuidByName.remove(eventNodeName);
                    this.distributedPlugin.onServerRemoved(eventNodeName);
                }
                this.updateLastClusterChange();
                this.distributedPlugin.dumpServersStatus();
            } else if (key.startsWith(CONFIG_DATABASE_PREFIX)) {
                String dbName = key.substring(CONFIG_DATABASE_PREFIX.length());
                this.updateLastClusterChange();
            } else if (key.startsWith(CONFIG_DBSTATUS_PREFIX)) {
                ODistributedServerLog.debug((Object)this, (String)this.nodeName, (String)this.getNodeName(iEvent.getMember(), true), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Received removed status %s=%s", (Object[])new Object[]{key.substring(CONFIG_DBSTATUS_PREFIX.length()), iEvent.getValue()});
                String dbNode = key.substring(CONFIG_DBSTATUS_PREFIX.length());
                String nodeName = dbNode.substring(0, dbNode.indexOf("."));
                String databaseName = dbNode.substring(dbNode.indexOf(".") + 1);
                this.distributedPlugin.onDatabaseEvent(nodeName, databaseName, (ODistributedServerManager.DB_STATUS)iEvent.getValue());
            }
        }
        catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
            OLogManager.instance().error((Object)this, "Hazelcast is not running", e, new Object[0]);
        }
    }

    public void entryEvicted(EntryEvent<String, Object> iEvent) {
    }

    public void mapEvicted(MapEvent iEvent) {
    }

    public void mapCleared(MapEvent event) {
    }

    public void memberRemoved(MembershipEvent iEvent) {
        new Thread(() -> {
            try {
                this.updateLastClusterChange();
                if (iEvent.getMember() == null) {
                    return;
                }
                String nodeLeftName = this.getNodeName(iEvent.getMember(), true);
                if (nodeLeftName == null) {
                    return;
                }
                this.distributedPlugin.removeServer(nodeLeftName, true);
            }
            catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
                OLogManager.instance().error((Object)this, "Hazelcast is not running", e, new Object[0]);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on removing the server '%s'", (Throwable)e, new Object[]{this.getNodeName(iEvent.getMember(), true)});
            }
        }).start();
    }

    public void memberAdded(MembershipEvent iEvent) {
        new Thread(() -> {
            if (this.hazelcastInstance == null || !this.hazelcastInstance.getLifecycleService().isRunning()) {
                return;
            }
            try {
                this.updateLastClusterChange();
                String addedNodeName = this.getNodeName(iEvent.getMember(), true);
                ODistributedServerLog.info((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Added new node id=%s name=%s", (Object[])new Object[]{iEvent.getMember(), addedNodeName});
                this.registerNode(iEvent.getMember(), addedNodeName);
                this.autoRemovalOfServers.remove(addedNodeName);
            }
            catch (HazelcastInstanceNotActiveException | RetryableHazelcastException e) {
                OLogManager.instance().error((Object)this, "Hazelcast is not running", e, new Object[0]);
            }
        }).start();
    }

    public void stateChanged(LifecycleEvent event) {
        LifecycleEvent.LifecycleState state = event.getState();
        if (state == LifecycleEvent.LifecycleState.MERGING) {
            this.setNodeStatus(ODistributedServerManager.NODE_STATUS.MERGING);
        } else if (state == LifecycleEvent.LifecycleState.MERGED) {
            ODistributedServerLog.info((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Server merged the existent cluster, merging databases...", (Object[])new Object[0]);
            this.configurationMap.clearLocalCache();
            String oldUuid = this.nodeUuid;
            this.nodeUuid = this.hazelcastInstance.getCluster().getLocalMember().getUuid();
            ODistributedServerLog.info((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Replacing old UUID %s with the new %s", (Object[])new Object[]{oldUuid, this.nodeUuid});
            this.activeNodesNamesByUuid.remove(oldUuid);
            this.configurationMap.remove(CONFIG_NODE_PREFIX + oldUuid);
            this.activeNodes.put(this.nodeName, this.hazelcastInstance.getCluster().getLocalMember());
            this.activeNodesNamesByUuid.put(this.nodeUuid, this.nodeName);
            this.activeNodesUuidByName.put(this.nodeName, this.nodeUuid);
            this.publishLocalNodeConfiguration();
            this.setNodeStatus(ODistributedServerManager.NODE_STATUS.ONLINE);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (final String databaseName : OHazelcastClusterMetadataManager.this.distributedPlugin.getMessageService().getDatabases()) {
                            OHazelcastClusterMetadataManager.this.executeInDistributedDatabaseLock(databaseName, 20000L, null, new OCallable<Object, OModifiableDistributedConfiguration>(){

                                public Object call(OModifiableDistributedConfiguration cfg) {
                                    ODistributedServerLog.debug((Object)this, (String)OHazelcastClusterMetadataManager.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Replacing local database '%s' configuration with the most recent from the joined cluster...", (Object[])new Object[]{databaseName});
                                    cfg.override((ODocument)OHazelcastClusterMetadataManager.this.configurationMap.get(OHazelcastClusterMetadataManager.CONFIG_DATABASE_PREFIX + databaseName));
                                    return null;
                                }
                            });
                        }
                    }
                    finally {
                        ODistributedServerLog.warn((Object)this, (String)OHazelcastClusterMetadataManager.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Network merged ...", (Object[])new Object[0]);
                        OHazelcastClusterMetadataManager.this.setNodeStatus(ODistributedServerManager.NODE_STATUS.ONLINE);
                    }
                }
            });
            t.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new OUncaughtExceptionHandler());
            t.start();
        }
    }

    public void removeDbFromClusterMetadata(ODatabaseInternal iDatabase) {
        String dbName = iDatabase.getName();
        if (this.configurationMap != null) {
            this.configurationMap.remove(CONFIG_DBSTATUS_PREFIX + this.nodeName + "." + dbName);
        }
    }

    public void dropDatabaseConfiguration(String dbName) {
        this.configurationMap.remove(CONFIG_DATABASE_PREFIX + dbName);
        this.configurationMap.remove("deploydb." + dbName);
        ODistributedServerLog.info((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Dropped last copy of database '%s', removing it from the cluster", (Object[])new Object[]{dbName});
    }

    public Set<String> dropDbFromConfiguration(String dbName) {
        ODistributedConfiguration dCfg = this.getDatabaseConfiguration(dbName);
        Set servers = dCfg.getAllConfiguredServers();
        long start = System.currentTimeMillis();
        boolean allServersAreOnline = false;
        block2: while (!allServersAreOnline && System.currentTimeMillis() - start < 5000L) {
            allServersAreOnline = true;
            for (String s : servers) {
                ODistributedServerManager.DB_STATUS st = this.getDatabaseStatus(s, dbName);
                if (st != ODistributedServerManager.DB_STATUS.NOT_AVAILABLE && st != ODistributedServerManager.DB_STATUS.SYNCHRONIZING && st != ODistributedServerManager.DB_STATUS.BACKUP) continue;
                allServersAreOnline = false;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue block2;
                }
            }
        }
        return servers;
    }

    public ODocument getNodeConfigurationByUuid(String iNodeId, boolean useCache) {
        if (this.configurationMap == null) {
            return null;
        }
        ODocument doc = useCache ? (ODocument)this.configurationMap.getLocalCachedValue(CONFIG_NODE_PREFIX + iNodeId) : (ODocument)this.configurationMap.get(CONFIG_NODE_PREFIX + iNodeId);
        if (doc == null) {
            ODistributedServerLog.debug((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Cannot find node with id '%s'", (Object[])new Object[]{iNodeId});
        }
        return doc;
    }

    public ODocument getNodeConfigurationByName(String nodeName, boolean useCache) {
        String uuid = this.getNodeUuidByName(nodeName);
        return this.getNodeConfigurationByUuid(uuid, useCache);
    }

    public ODistributedServerManager.DB_STATUS getDatabaseStatus(String iNode, String iDatabaseName) {
        if ("OSystem".equals(iDatabaseName)) {
            if (this.getActiveServers().contains(iNode)) {
                return ODistributedServerManager.DB_STATUS.ONLINE;
            }
            return ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
        }
        ODistributedServerManager.DB_STATUS status = (ODistributedServerManager.DB_STATUS)this.configurationMap.getLocalCachedValue(CONFIG_DBSTATUS_PREFIX + iNode + "." + iDatabaseName);
        return status != null ? status : ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
    }

    public ODistributedServerManager.DB_STATUS getDatabaseStatus(String iNode, String iDatabaseName, boolean useCache) {
        if ("OSystem".equals(iDatabaseName)) {
            if (this.getActiveServers().contains(iNode)) {
                return ODistributedServerManager.DB_STATUS.ONLINE;
            }
            return ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
        }
        String key = CONFIG_DBSTATUS_PREFIX + iNode + "." + iDatabaseName;
        ODistributedServerManager.DB_STATUS status = (ODistributedServerManager.DB_STATUS)(useCache ? this.configurationMap.getLocalCachedValue(key) : this.configurationMap.get(key));
        return status != null ? status : ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
    }

    public void setDatabaseStatus(String iNode, String iDatabaseName, ODistributedServerManager.DB_STATUS iStatus) {
        String key = CONFIG_DBSTATUS_PREFIX + iNode + "." + iDatabaseName;
        ODistributedServerManager.DB_STATUS currStatus = (ODistributedServerManager.DB_STATUS)this.configurationMap.get(key);
        if (currStatus == null || currStatus != iStatus) {
            this.configurationMap.put(key, (Object)iStatus);
            this.distributedPlugin.invokeOnDatabaseStatusChange(iNode, iDatabaseName, iStatus);
        }
    }

    public Set<String> getDatabases() {
        HashSet<String> dbs = new HashSet<String>();
        for (String key : this.configurationMap.keySet()) {
            if (!key.startsWith(CONFIG_DATABASE_PREFIX)) continue;
            String databaseName = key.substring(CONFIG_DATABASE_PREFIX.length());
            dbs.add(databaseName);
        }
        return dbs;
    }

    public void reloadRegisteredNodes(String registeredNodesFromClusterAsJson) {
        ODocument registeredNodesFromCluster = new ODocument();
        if (registeredNodesFromClusterAsJson == null) {
            registeredNodesFromClusterAsJson = (String)this.configurationMap.get(CONFIG_REGISTEREDNODES);
        }
        if (registeredNodesFromClusterAsJson == null) {
            throw new ODistributedException("Cannot find distributed 'registeredNodes' configuration");
        }
        registeredNodesFromCluster.fromJSON(registeredNodesFromClusterAsJson);
        this.registeredNodeById.clear();
        this.registeredNodeById.addAll((Collection)registeredNodesFromCluster.field("ids", OType.EMBEDDEDLIST));
        this.registeredNodeByName.clear();
        this.registeredNodeByName.putAll((Map)registeredNodesFromCluster.field("names", OType.EMBEDDEDMAP));
    }

    private List<String> getRegisteredNodes() {
        ArrayList<String> registeredNodes = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.configurationMap.entrySet()) {
            if (!entry.getKey().toString().startsWith(CONFIG_NODE_PREFIX)) continue;
            registeredNodes.add(entry.getKey().toString().substring(CONFIG_NODE_PREFIX.length()));
        }
        return registeredNodes;
    }

    public void removeNodeFromConfiguration(String nodeLeftName, boolean removeOnlyDynamicServers) {
        ODistributedServerLog.info((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Removing server '%s' from all the databases (removeOnlyDynamicServers=%s)...", (Object[])new Object[]{nodeLeftName, removeOnlyDynamicServers});
        for (String dbName : this.distributedPlugin.getManagedDatabases()) {
            this.removeNodeFromConfiguration(nodeLeftName, dbName, removeOnlyDynamicServers, false);
        }
    }

    public boolean removeNodeFromConfiguration(final String nodeLeftName, String databaseName, boolean removeOnlyDynamicServers, boolean statusOffline) {
        ODistributedServerLog.debug((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Removing server '%s' from database configuration '%s' (removeOnlyDynamicServers=%s)...", (Object[])new Object[]{nodeLeftName, databaseName, removeOnlyDynamicServers});
        OModifiableDistributedConfiguration cfg = this.getDatabaseConfiguration(databaseName).modify();
        if (removeOnlyDynamicServers) {
            String dc = cfg.getDataCenterOfServer(nodeLeftName);
            if (dc != null) {
                ODistributedServerLog.info((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot remove server '%s' because it is enlisted in data center '%s' configuration for database '%s'", (Object[])new Object[]{nodeLeftName, dc, databaseName});
                return false;
            }
            Set registeredServers = cfg.getRegisteredServers();
            if (registeredServers.contains(nodeLeftName)) {
                ODistributedServerLog.info((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot remove server '%s' because it is enlisted in 'servers' of the distributed configuration for database '%s'", (Object[])new Object[]{nodeLeftName, databaseName});
                return false;
            }
        }
        boolean found = this.executeInDistributedDatabaseLock(databaseName, 20000L, cfg, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

            public Boolean call(OModifiableDistributedConfiguration cfg) {
                return cfg.removeServer(nodeLeftName) != null;
            }
        });
        ODistributedServerManager.DB_STATUS nodeLeftStatus = this.getDatabaseStatus(nodeLeftName, databaseName);
        if (statusOffline && nodeLeftStatus != ODistributedServerManager.DB_STATUS.OFFLINE) {
            this.setDatabaseStatus(nodeLeftName, databaseName, ODistributedServerManager.DB_STATUS.OFFLINE);
        } else if (!statusOffline && nodeLeftStatus != ODistributedServerManager.DB_STATUS.NOT_AVAILABLE) {
            this.setDatabaseStatus(nodeLeftName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
        }
        return found;
    }

    public Member removeFromLocalActiveServerList(String nodeLeftName) {
        Member member = (Member)this.activeNodes.remove(nodeLeftName);
        if (member == null) {
            return null;
        }
        if (member.getUuid() != null) {
            this.activeNodesNamesByUuid.remove(member.getUuid());
        }
        this.activeNodesUuidByName.remove(nodeLeftName);
        return member;
    }

    public void removeServerFromCluster(Member member, String nodeLeftName, boolean removeOnlyDynamicServers) {
        if (this.hazelcastInstance == null || !this.hazelcastInstance.getLifecycleService().isRunning()) {
            return;
        }
        long autoRemoveOffLineServer = OGlobalConfiguration.DISTRIBUTED_AUTO_REMOVE_OFFLINE_SERVERS.getValueAsLong();
        if (autoRemoveOffLineServer == 0L) {
            this.removeNodeFromConfiguration(nodeLeftName, removeOnlyDynamicServers);
        } else if (autoRemoveOffLineServer > 0L) {
            this.autoRemovalOfServers.put(nodeLeftName, System.currentTimeMillis());
            Orient.instance().scheduleTask(() -> {
                try {
                    Long lastTimeNodeLeft = (Long)this.autoRemovalOfServers.get(nodeLeftName);
                    if (lastTimeNodeLeft == null) {
                        return;
                    }
                    if (System.currentTimeMillis() - lastTimeNodeLeft >= autoRemoveOffLineServer) {
                        this.removeNodeFromConfiguration(nodeLeftName, removeOnlyDynamicServers);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, autoRemoveOffLineServer, 0L);
        }
        for (String databaseName : this.distributedPlugin.getManagedDatabases()) {
            ODistributedServerManager.DB_STATUS nodeLeftStatus = this.getDatabaseStatus(nodeLeftName, databaseName);
            if (nodeLeftStatus == ODistributedServerManager.DB_STATUS.OFFLINE || nodeLeftStatus == ODistributedServerManager.DB_STATUS.NOT_AVAILABLE) continue;
            this.configurationMap.put(CONFIG_DBSTATUS_PREFIX + nodeLeftName + "." + databaseName, (Object)ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
        }
        ODistributedServerLog.warn((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Node removed id=%s name=%s", (Object[])new Object[]{member, nodeLeftName});
        if (nodeLeftName.startsWith("ext:")) {
            List<String> registeredNodes = this.getRegisteredNodes();
            ODistributedServerLog.error((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Removed node id=%s name=%s has not being recognized. Remove the node manually (registeredNodes=%s)", (Object[])new Object[]{member, nodeLeftName, registeredNodes});
        }
    }

    public Set<String> getActiveServers() {
        return this.activeNodes.keySet();
    }

    protected void registerNode(Member member, String joinedNodeName) {
        if (this.activeNodes.containsKey(joinedNodeName)) {
            return;
        }
        if (joinedNodeName.startsWith("ext:")) {
            return;
        }
        if (this.activeNodes.putIfAbsent(joinedNodeName, member) == null) {
            if (!this.distributedPlugin.onNodeJoining(joinedNodeName)) {
                ODistributedServerLog.info((Object)this, (String)this.nodeName, (String)this.getNodeName(member, true), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Denied node to join the cluster id=%s name=%s", (Object[])new Object[]{member, this.getNodeName(member, true)});
                this.activeNodes.remove(joinedNodeName);
                return;
            }
            this.activeNodesNamesByUuid.put(member.getUuid(), joinedNodeName);
            this.activeNodesUuidByName.put(joinedNodeName, member.getUuid());
            this.distributedPlugin.onNodeJoined(joinedNodeName, member);
        }
    }

    public String getNodeName(Member iMember, boolean useCache) {
        if (iMember == null || iMember.getUuid() == null) {
            return "?";
        }
        if (this.nodeUuid.equals(iMember.getUuid())) {
            return this.nodeName;
        }
        String name = (String)this.activeNodesNamesByUuid.get(iMember.getUuid());
        if (name != null) {
            return name;
        }
        ODocument cfg = this.getNodeConfigurationByUuid(iMember.getUuid(), useCache);
        if (cfg != null) {
            return (String)cfg.field("name");
        }
        return "ext:" + iMember.getUuid();
    }

    public ODocument getClusterConfiguration() {
        ODocument cluster = new ODocument();
        cluster.field("localName", (Object)this.distributedPlugin.getName());
        cluster.field("localId", (Object)this.nodeUuid);
        ArrayList<ODocument> members = new ArrayList<ODocument>();
        cluster.field("members", members, new OType[]{OType.EMBEDDEDLIST});
        for (Member member : this.activeNodes.values()) {
            ODocument memberConfig = this.getNodeConfigurationByUuid(member.getUuid(), true).copy();
            if (memberConfig == null) continue;
            members.add(memberConfig);
            String nodeName = this.getNodeName(member, true);
            HashMap<String, String> dbStatus = new HashMap<String, String>();
            memberConfig.field("databasesStatus", dbStatus, new OType[]{OType.EMBEDDEDMAP});
            for (String db : this.distributedPlugin.getManagedDatabases()) {
                ODistributedServerManager.DB_STATUS nodeDbState = this.getDatabaseStatus(nodeName, db);
                dbStatus.put(db, nodeDbState.toString());
            }
        }
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryGetNodeNameById(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Node id " + id + " is invalid");
        }
        List<String> list = this.registeredNodeById;
        synchronized (list) {
            if (id < this.registeredNodeById.size()) {
                return this.registeredNodeById.get(id);
            }
        }
        return null;
    }

    public int tryGetNodeIdByName(String name) {
        Integer val = (Integer)this.registeredNodeByName.get(name);
        if (val == null) {
            return -1;
        }
        return val;
    }

    public String getNodeUuidByName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Node name " + name + " is invalid");
        }
        return (String)this.activeNodesUuidByName.get(name);
    }

    public int getAvailableNodes(String iDatabaseName) {
        int availableNodes = 0;
        for (Map.Entry entry : this.activeNodes.entrySet()) {
            if (!this.isNodeAvailable((String)entry.getKey(), iDatabaseName)) continue;
            ++availableNodes;
        }
        return availableNodes;
    }

    public List<String> getOnlineNodes(String iDatabaseName) {
        ArrayList<String> onlineNodes = new ArrayList<String>(this.activeNodes.size());
        for (Map.Entry entry : this.activeNodes.entrySet()) {
            if (!this.isNodeOnline((String)entry.getKey(), iDatabaseName)) continue;
            onlineNodes.add((String)entry.getKey());
        }
        return onlineNodes;
    }

    public Set<String> getAvailableNodeNames(String iDatabaseName) {
        HashSet<String> nodes = new HashSet<String>();
        for (Map.Entry entry : this.activeNodes.entrySet()) {
            if (!this.isNodeAvailable((String)entry.getKey(), iDatabaseName)) continue;
            nodes.add((String)entry.getKey());
        }
        return nodes;
    }

    public int getAvailableNodes(Collection<String> iNodes, String databaseName) {
        Iterator<String> it = iNodes.iterator();
        while (it.hasNext()) {
            String node = it.next();
            if (this.isNodeAvailable(node, databaseName)) continue;
            it.remove();
        }
        return iNodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeInDistributedDatabaseLock(String databaseName, long timeoutLocking, OModifiableDistributedConfiguration lastCfg, OCallable<T, OModifiableDistributedConfiguration> iCallback) {
        boolean updated;
        Object result;
        this.getLockManagerExecutor().acquireExclusiveLock(databaseName, this.nodeName, timeoutLocking);
        try {
            if (lastCfg == null) {
                lastCfg = this.getDatabaseConfiguration(databaseName).modify();
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Current distributed configuration for database '%s': %s", (Object[])new Object[]{databaseName, lastCfg.getDocument().toJSON()});
            }
            try {
                result = iCallback.call((Object)lastCfg);
            }
            catch (Throwable throwable) {
                if (ODistributedServerLog.isDebugEnabled()) {
                    ODistributedServerLog.debug((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"New distributed configuration for database '%s': %s", (Object[])new Object[]{databaseName, lastCfg.getDocument().toJSON()});
                }
                boolean updated2 = this.updateCachedDatabaseConfiguration(databaseName, lastCfg, true);
                throw throwable;
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"New distributed configuration for database '%s': %s", (Object[])new Object[]{databaseName, lastCfg.getDocument().toJSON()});
            }
            updated = this.updateCachedDatabaseConfiguration(databaseName, lastCfg, true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.getLockManagerRequester().releaseExclusiveLock(databaseName, this.nodeName);
        }
        if (updated) {
            this.distributedPlugin.notifyClients(databaseName);
            this.serverInstance.getClientConnectionManager().pushDistribCfg2Clients(this.getClusterConfiguration());
        }
        return (T)result;
    }

    public ODistributedConfiguration getDatabaseConfiguration(String iDatabaseName) {
        return this.getDatabaseConfiguration(iDatabaseName, true);
    }

    public ODistributedConfiguration getDatabaseConfiguration(String iDatabaseName, boolean createIfNotPresent) {
        ODistributedDatabaseImpl local = this.distributedPlugin.getMessageService().getDatabase(iDatabaseName);
        if (local == null) {
            return null;
        }
        return local.getDistributedConfiguration();
    }

    public void setNodeStatus(ODistributedServerManager.NODE_STATUS iStatus) {
        if (this.status.equals((Object)iStatus)) {
            return;
        }
        this.status = iStatus;
        ODistributedServerLog.info((Object)this, (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Updated node status to '%s'", (Object[])new Object[]{this.status});
    }

    public ODistributedServerManager.NODE_STATUS getNodeStatus() {
        return this.status;
    }

    public boolean checkNodeStatus(ODistributedServerManager.NODE_STATUS iStatus2Check) {
        return this.status.equals((Object)iStatus2Check);
    }

    public boolean isNodeOnline(String iNodeName, String iDatabaseName) {
        return this.getDatabaseStatus(iNodeName, iDatabaseName) == ODistributedServerManager.DB_STATUS.ONLINE;
    }

    public void updateLastClusterChange() {
        this.lastClusterChangeOn = System.currentTimeMillis();
    }

    public long getLastClusterChangeOn() {
        return this.lastClusterChangeOn;
    }

    public int getLocalNodeId() {
        return this.nodeId;
    }

    public String getLocalNodeUuid() {
        return this.nodeUuid;
    }

    public String getLocalNodeName() {
        return this.nodeName;
    }
}

