/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.orient.server.distributed.ODistributedLockManager;
import com.orientechnologies.orient.server.distributed.task.ODistributedLockException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class OHazelcastLockManager
implements ODistributedLockManager {
    private HazelcastInstance hazelcast;
    private Set<String> lockedResurces = new HashSet<String>();
    private static final ThreadLocal<Map<String, OModifiableInteger>> ACQUIRED_REENTRANT = ThreadLocal.withInitial(() -> new HashMap());

    public OHazelcastLockManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusiveLock(String resource, String nodeSource, long timeout) {
        block8: {
            OModifiableInteger counter = ACQUIRED_REENTRANT.get().get(resource);
            if (counter != null) {
                counter.increment();
                return;
            }
            if (timeout != 0L) {
                try {
                    if (!this.hazelcast.getLock(resource).tryLock(timeout, TimeUnit.MILLISECONDS)) {
                        throw new ODistributedLockException(String.format("Timed out after %d ms attempting to obtain lock for resource '%s' on node '%s'", timeout, resource, nodeSource));
                    }
                    break block8;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ODistributedLockException(String.format("Interrupted while attempting to obtain lock for resource '%s' on node '%s'", timeout, resource, nodeSource));
                }
            }
            this.hazelcast.getLock(resource).lock();
        }
        OHazelcastLockManager oHazelcastLockManager = this;
        synchronized (oHazelcastLockManager) {
            this.lockedResurces.add(resource);
        }
        ACQUIRED_REENTRANT.get().put(resource, new OModifiableInteger(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExclusiveLock(String resource, String nodeSource) {
        OModifiableInteger counter = ACQUIRED_REENTRANT.get().get(resource);
        if (counter == null) {
            return;
        }
        if (counter.getValue() > 0) {
            counter.decrement();
            return;
        }
        ACQUIRED_REENTRANT.get().remove(resource);
        this.hazelcast.getLock(resource).unlock();
        OHazelcastLockManager oHazelcastLockManager = this;
        synchronized (oHazelcastLockManager) {
            this.lockedResurces.remove(resource);
        }
    }

    public void handleUnreachableServer(String nodeLeftName) {
    }

    public void shutdown() {
    }
}

