/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRetryAbstract;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLCreateEdge
extends OCommandExecutorSQLRetryAbstract
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "CREATE EDGE";
    private String from;
    private String to;
    private OClass clazz;
    private String clusterName;
    private LinkedHashMap<String, Object> fields;

    public OCommandExecutorSQLCreateEdge parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLCreateEdge.getDatabase();
        this.init((OCommandRequestText)iRequest);
        this.parserRequiredKeyword(new String[]{"CREATE"});
        this.parserRequiredKeyword(new String[]{"EDGE"});
        String className = null;
        String temp = this.parseOptionalWord(true, new String[0]);
        while (temp != null) {
            if (temp.equals("CLUSTER")) {
                this.clusterName = this.parserRequiredWord(false);
            } else if (temp.equals("FROM")) {
                this.from = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
            } else if (temp.equals("TO")) {
                this.to = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
            } else if (temp.equals("SET")) {
                this.fields = new LinkedHashMap();
                this.parseSetFields(this.fields);
            } else if (temp.equals("CONTENT")) {
                this.parseContent();
            } else if (temp.equals("RETRY")) {
                this.parseRetry();
            } else if (className == null && temp.length() > 0) {
                className = temp;
            }
            temp = this.parseOptionalWord(true, new String[0]);
            if (!this.parserIsEnded()) continue;
        }
        if (className == null) {
            className = "E";
        }
        this.clazz = database.getMetadata().getSchema().getClass(className);
        if (this.clazz == null) {
            throw new OCommandSQLParsingException("Class " + className + " was not found");
        }
        return this;
    }

    public Object execute(final Map<Object, Object> iArgs) {
        if (this.clazz == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        return OGraphCommandExecutorSQLFactory.runInTx(new OGraphCommandExecutorSQLFactory.GraphCallBack<List<Object>>(){

            @Override
            public List<Object> call(OrientBaseGraph graph) {
                Set fromIds = OSQLEngine.getInstance().parseRIDTarget((ODatabaseRecord)graph.getRawGraph(), OCommandExecutorSQLCreateEdge.this.from, OCommandExecutorSQLCreateEdge.this.context, iArgs);
                Set toIds = OSQLEngine.getInstance().parseRIDTarget((ODatabaseRecord)graph.getRawGraph(), OCommandExecutorSQLCreateEdge.this.to, OCommandExecutorSQLCreateEdge.this.context, iArgs);
                ArrayList<Object> edges = new ArrayList<Object>();
                for (OIdentifiable from : fromIds) {
                    OrientVertex fromVertex = graph.getVertex(from);
                    if (fromVertex == null) {
                        throw new OCommandExecutionException("Source vertex '" + from + "' not exists");
                    }
                    for (OIdentifiable to : toIds) {
                        OrientVertex toVertex = from.equals(to) ? fromVertex : graph.getVertex(to);
                        String clsName = OCommandExecutorSQLCreateEdge.this.clazz.getName();
                        if (OCommandExecutorSQLCreateEdge.this.fields != null) {
                            for (Map.Entry f : OCommandExecutorSQLCreateEdge.this.fields.entrySet()) {
                                if (!(f.getValue() instanceof OSQLFunctionRuntime)) continue;
                                OCommandExecutorSQLCreateEdge.this.fields.put(f.getKey(), ((OSQLFunctionRuntime)f.getValue()).getValue(to, null, OCommandExecutorSQLCreateEdge.this.context));
                            }
                        }
                        OrientEdge edge = null;
                        for (int r = 0; r < OCommandExecutorSQLCreateEdge.this.retry; ++r) {
                            try {
                                edge = fromVertex.addEdge(null, toVertex, clsName, OCommandExecutorSQLCreateEdge.this.clusterName, OCommandExecutorSQLCreateEdge.this.fields);
                                if (OCommandExecutorSQLCreateEdge.this.fields != null && !OCommandExecutorSQLCreateEdge.this.fields.isEmpty()) {
                                    if (!edge.getRecord().getIdentity().isValid()) {
                                        edge.convertToDocument();
                                    }
                                    OSQLHelper.bindParameters((ODocument)edge.getRecord(), (Map)OCommandExecutorSQLCreateEdge.this.fields, (OCommandParameters)new OCommandParameters(iArgs), (OCommandContext)OCommandExecutorSQLCreateEdge.this.context);
                                }
                                if (OCommandExecutorSQLCreateEdge.this.content != null) {
                                    if (!edge.getRecord().getIdentity().isValid()) {
                                        edge.convertToDocument();
                                    }
                                    edge.getRecord().merge(OCommandExecutorSQLCreateEdge.this.content, true, false);
                                }
                                edge.save(OCommandExecutorSQLCreateEdge.this.clusterName);
                                break;
                            }
                            catch (OConcurrentModificationException e) {
                                if (r + 1 >= OCommandExecutorSQLCreateEdge.this.retry) {
                                    throw e;
                                }
                                if (OCommandExecutorSQLCreateEdge.this.wait > 0) {
                                    try {
                                        Thread.sleep(OCommandExecutorSQLCreateEdge.this.wait);
                                    }
                                    catch (InterruptedException e1) {
                                        // empty catch block
                                    }
                                }
                                fromVertex.getRecord().reload(null, true);
                                toVertex.getRecord().reload(null, true);
                                continue;
                            }
                        }
                        edges.add(edge);
                    }
                }
                return edges;
            }
        });
    }

    public String getSyntax() {
        return "CREATE EDGE [<class>] [CLUSTER <cluster>] FROM <rid>|(<query>|[<rid>]*) TO <rid>|(<query>|[<rid>]*) [SET <field> = <expression>[,]*]|CONTENT {<JSON>} [RETRY <retry> [WAIT <pauseBetweenRetriesInMs]]";
    }
}

