/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRetryAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLDeleteEdge
extends OCommandExecutorSQLRetryAbstract
implements OCommandDistributedReplicateRequest,
OCommandResultListener {
    public static final String NAME = "DELETE EDGE";
    private ORecordId rid;
    private String fromExpr;
    private String toExpr;
    private int removed = 0;
    private OCommandRequest query;
    private OSQLFilter compiledFilter;
    private OrientGraph graph;

    public OCommandExecutorSQLDeleteEdge parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        this.parserRequiredKeyword(new String[]{"DELETE"});
        this.parserRequiredKeyword(new String[]{"EDGE"});
        OrientEdgeType clazz = null;
        String where = null;
        String temp = this.parseOptionalWord(true, new String[0]);
        OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(false);
        while (temp != null) {
            if (temp.equals("FROM")) {
                this.fromExpr = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                if (this.rid != null) {
                    this.throwSyntaxErrorException("FROM '" + this.fromExpr + "' is not allowed when specify a RID (" + this.rid + ")");
                }
            } else if (temp.equals("TO")) {
                this.toExpr = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                if (this.rid != null) {
                    this.throwSyntaxErrorException("TO '" + this.toExpr + "' is not allowed when specify a RID (" + this.rid + ")");
                }
            } else if (temp.startsWith("#")) {
                this.rid = new ORecordId(temp);
                if (this.fromExpr != null || this.toExpr != null) {
                    this.throwSyntaxErrorException("Specifying the RID " + this.rid + " is not allowed with FROM/TO");
                }
            } else {
                if (temp.equals("WHERE")) {
                    if (clazz == null) {
                        clazz = graph.getEdgeType("E");
                    }
                    where = this.parserGetCurrentPosition() > -1 ? " " + this.parserText.substring(this.parserGetCurrentPosition()) : "";
                    this.compiledFilter = OSQLEngine.getInstance().parseCondition(where, this.getContext(), "WHERE");
                    break;
                }
                if (temp.equals("RETRY")) {
                    this.parseRetry();
                } else if (temp.length() > 0 && (clazz = graph.getEdgeType(temp)) == null) {
                    throw new OCommandSQLParsingException("Class '" + temp + " was not found");
                }
            }
            temp = this.parseOptionalWord(true, new String[0]);
            if (!this.parserIsEnded()) continue;
        }
        where = where == null ? "" : " WHERE " + where;
        if (this.fromExpr == null && this.toExpr == null && this.rid == null) {
            this.query = clazz == null ? graph.getRawGraph().command((OCommandRequest)new OSQLAsynchQuery("select from E" + where, (OCommandResultListener)this)) : graph.getRawGraph().command((OCommandRequest)new OSQLAsynchQuery("select from " + clazz.getName() + where, (OCommandResultListener)this));
        }
        return this;
    }

    public Object execute(final Map<Object, Object> iArgs) {
        if (this.fromExpr == null && this.toExpr == null && this.rid == null && this.query == null && this.compiledFilter == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        for (int r = 0; r < this.retry; ++r) {
            try {
                if (this.rid != null) {
                    OGraphCommandExecutorSQLFactory.runInTx(new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                        @Override
                        public Object call(OrientBaseGraph graph) {
                            OrientEdge e = graph.getEdge(OCommandExecutorSQLDeleteEdge.this.rid);
                            if (e != null) {
                                e.remove();
                                OCommandExecutorSQLDeleteEdge.this.removed = 1;
                            }
                            return null;
                        }
                    });
                    break;
                }
                final HashSet edges = new HashSet();
                if (this.query == null) {
                    OGraphCommandExecutorSQLFactory.runInTx(new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                        @Override
                        public Object call(OrientBaseGraph graph) {
                            Set fromIds = null;
                            if (OCommandExecutorSQLDeleteEdge.this.fromExpr != null) {
                                fromIds = OSQLEngine.getInstance().parseRIDTarget((ODatabaseRecord)graph.getRawGraph(), OCommandExecutorSQLDeleteEdge.this.fromExpr, OCommandExecutorSQLDeleteEdge.this.context, iArgs);
                            }
                            Set toIds = null;
                            if (OCommandExecutorSQLDeleteEdge.this.toExpr != null) {
                                toIds = OSQLEngine.getInstance().parseRIDTarget((ODatabaseRecord)graph.getRawGraph(), OCommandExecutorSQLDeleteEdge.this.toExpr, OCommandExecutorSQLDeleteEdge.this.context, iArgs);
                            }
                            if (fromIds != null && toIds != null) {
                                for (OIdentifiable fromId : fromIds) {
                                    OrientVertex v = graph.getVertex(fromId);
                                    if (v == null) continue;
                                    for (Edge e : v.getEdges(Direction.OUT, new String[0])) {
                                        OIdentifiable inV = ((OrientEdge)e).getInVertex();
                                        if (inV == null || !toIds.contains(inV.getIdentity())) continue;
                                        edges.add((OrientEdge)e);
                                    }
                                }
                            } else if (fromIds != null) {
                                for (OIdentifiable fromId : fromIds) {
                                    edges.add((OrientEdge)((Object)graph.getVertex(fromId).getEdges(Direction.OUT, new String[0])));
                                }
                            } else if (toIds != null) {
                                for (OIdentifiable toId : toIds) {
                                    edges.add((OrientEdge)((Object)graph.getVertex(toId).getEdges(Direction.IN, new String[0])));
                                }
                            } else {
                                throw new OCommandExecutionException("Invalid target");
                            }
                            if (OCommandExecutorSQLDeleteEdge.this.compiledFilter != null) {
                                Iterator it = edges.iterator();
                                while (it.hasNext()) {
                                    OrientEdge edge = (OrientEdge)it.next();
                                    if (((Boolean)OCommandExecutorSQLDeleteEdge.this.compiledFilter.evaluate((ORecord)edge.getRecord(), null, OCommandExecutorSQLDeleteEdge.this.context)).booleanValue()) continue;
                                    it.remove();
                                }
                            }
                            OCommandExecutorSQLDeleteEdge.this.removed = edges.size();
                            for (OrientEdge edge : edges) {
                                edge.remove();
                            }
                            return null;
                        }
                    });
                    break;
                }
                this.graph = OGraphCommandExecutorSQLFactory.getGraph(false);
                OGraphCommandExecutorSQLFactory.runInTx(this.graph, new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                    @Override
                    public Object call(OrientBaseGraph graph) {
                        return OCommandExecutorSQLDeleteEdge.this.query.execute(new Object[]{iArgs});
                    }
                });
                break;
            }
            catch (OConcurrentModificationException e) {
                if (r + 1 >= this.retry) {
                    throw e;
                }
                if (this.wait <= 0) continue;
                try {
                    Thread.sleep(this.wait);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        return this.removed;
    }

    public boolean result(Object iRecord) {
        OrientEdge e;
        OIdentifiable id = (OIdentifiable)iRecord;
        if (this.compiledFilter != null && !((Boolean)this.compiledFilter.evaluate((ORecord)((ODocument)id.getRecord()), null, this.context)).booleanValue()) {
            return true;
        }
        if (id.getIdentity().isValid() && (e = this.graph.getEdge(id)) != null) {
            e.remove();
            ++this.removed;
        }
        return true;
    }

    public String getSyntax() {
        return "DELETE EDGE <rid>|FROM <rid>|TO <rid>|<[<class>] [WHERE <conditions>]>";
    }

    public void end() {
    }

    public int getSecurityOperationType() {
        return ORole.PERMISSION_DELETE;
    }
}

