/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLDeleteVertex
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest,
OCommandResultListener {
    public static final String NAME = "DELETE VERTEX";
    private ORecordId rid;
    private int removed = 0;
    private ODatabaseRecord database;
    private OCommandRequest query;
    private String returning = "COUNT";
    private List<ORecord<?>> allDeletedRecords;
    private OrientGraph graph;

    public OCommandExecutorSQLDeleteVertex parse(OCommandRequest iRequest) {
        this.database = OCommandExecutorSQLDeleteVertex.getDatabase();
        this.init((OCommandRequestText)iRequest);
        this.parserRequiredKeyword(new String[]{"DELETE"});
        this.parserRequiredKeyword(new String[]{"VERTEX"});
        OClass clazz = null;
        String where = null;
        String word = this.parseOptionalWord(true, new String[0]);
        while (word != null) {
            if (word.startsWith("#")) {
                this.rid = new ORecordId(word);
            } else if (word.equalsIgnoreCase("from")) {
                StringBuilder q = new StringBuilder();
                int newPos = OStringSerializerHelper.getEmbedded((String)this.parserText, (int)this.parserGetCurrentPosition(), (int)-1, (StringBuilder)q);
                this.query = this.database.command((OCommandRequest)new OSQLAsynchQuery(q.toString(), (OCommandResultListener)this));
                this.parserSetCurrentPosition(newPos);
            } else {
                if (word.equals("WHERE")) {
                    if (clazz == null) {
                        clazz = this.database.getMetadata().getSchema().getClass("V");
                    }
                    where = this.parserGetCurrentPosition() > -1 ? " " + this.parserText.substring(this.parserGetPreviousPosition()) : "";
                    this.query = this.database.command((OCommandRequest)new OSQLAsynchQuery("select from " + clazz.getName() + where, (OCommandResultListener)this));
                    break;
                }
                if (word.length() > 0 && (clazz = this.database.getMetadata().getSchema().getClass(word)) == null) {
                    throw new OCommandSQLParsingException("Class '" + word + " was not found");
                }
            }
            word = this.parseOptionalWord(true, new String[0]);
            if (!this.parserIsEnded()) continue;
        }
        where = where == null ? "" : " WHERE " + where;
        if (this.query == null && this.rid == null) {
            this.query = clazz == null ? this.database.command((OCommandRequest)new OSQLAsynchQuery("select from V" + where, (OCommandResultListener)this)) : this.database.command((OCommandRequest)new OSQLAsynchQuery("select from " + clazz.getName() + where, (OCommandResultListener)this));
        }
        return this;
    }

    public Object execute(final Map<Object, Object> iArgs) {
        if (this.rid == null && this.query == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (this.rid != null) {
            OGraphCommandExecutorSQLFactory.runInTx(new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                @Override
                public Object call(OrientBaseGraph graph) {
                    OrientVertex v = graph.getVertex(OCommandExecutorSQLDeleteVertex.this.rid);
                    if (v != null) {
                        v.remove();
                        OCommandExecutorSQLDeleteVertex.this.removed = 1;
                    }
                    return null;
                }
            });
        } else if (this.query != null) {
            this.graph = OGraphCommandExecutorSQLFactory.getGraph(false);
            OGraphCommandExecutorSQLFactory.runInTx(this.graph, new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                @Override
                public Object call(OrientBaseGraph graph) {
                    return OCommandExecutorSQLDeleteVertex.this.query.execute(new Object[]{iArgs});
                }
            });
        } else {
            throw new OCommandExecutionException("Invalid target");
        }
        return this.removed;
    }

    public boolean result(Object iRecord) {
        OrientVertex v;
        OIdentifiable id = (OIdentifiable)iRecord;
        if (id.getIdentity().isValid() && (v = this.graph.getVertex(id)) != null) {
            v.remove();
            ++this.removed;
        }
        return true;
    }

    public String getSyntax() {
        return "DELETE VERTEX [FROM <query>]|<rid>|<[<class>] [WHERE <conditions>] [LIMIT <max-records>]>";
    }

    public void end() {
    }

    public int getSecurityOperationType() {
        return ORole.PERMISSION_DELETE;
    }
}

