/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFactory;
import com.orientechnologies.orient.graph.sql.OCommandExecutorSQLCreateEdge;
import com.orientechnologies.orient.graph.sql.OCommandExecutorSQLCreateVertex;
import com.orientechnologies.orient.graph.sql.OCommandExecutorSQLDeleteEdge;
import com.orientechnologies.orient.graph.sql.OCommandExecutorSQLDeleteVertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OGraphCommandExecutorSQLFactory
implements OCommandExecutorSQLFactory {
    private static final Map<String, Class<? extends OCommandExecutorSQLAbstract>> COMMANDS;

    public static OrientGraph getGraph(boolean autoStartTx) {
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (!(database instanceof ODatabaseDocumentTx)) {
            database = new ODatabaseDocumentTx((ODatabaseRecordTx)database);
        }
        return new OrientGraph((ODatabaseDocumentTx)database, autoStartTx);
    }

    public static OrientBaseGraph getNoTxGraph() {
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (!(database instanceof ODatabaseDocumentTx)) {
            database = new ODatabaseDocumentTx((ODatabaseRecordTx)database);
        }
        return new OrientGraphNoTx((ODatabaseDocumentTx)database);
    }

    public static <T> T runInTx(OrientGraph graph, GraphCallBack<T> callBack) {
        ODatabaseRecord databaseRecord = OGraphCommandExecutorSQLFactory.getDatabase();
        boolean txWasActive = databaseRecord.getTransaction().isActive();
        if (!txWasActive) {
            graph.getRawGraph().begin();
        }
        try {
            T result = callBack.call(graph);
            if (!txWasActive) {
                graph.commit();
            }
            return result;
        }
        catch (RuntimeException e) {
            if (!txWasActive) {
                graph.rollback();
            }
            throw e;
        }
    }

    public static <T> T runInTx(GraphCallBack<T> callBack) {
        return OGraphCommandExecutorSQLFactory.runInTx(OGraphCommandExecutorSQLFactory.getGraph(false), callBack);
    }

    public static ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    public Set<String> getCommandNames() {
        return COMMANDS.keySet();
    }

    public OCommandExecutorSQLAbstract createCommand(String name) throws OCommandExecutionException {
        Class<? extends OCommandExecutorSQLAbstract> clazz = COMMANDS.get(name);
        if (clazz == null) {
            throw new OCommandExecutionException("Unknown command name :" + name);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error in creation of command " + name + "(). Probably there is not an empty constructor or the constructor generates errors", (Throwable)e);
        }
    }

    static {
        HashMap<String, Class> commands = new HashMap<String, Class>();
        commands.put("CREATE EDGE", OCommandExecutorSQLCreateEdge.class);
        commands.put("DELETE EDGE", OCommandExecutorSQLDeleteEdge.class);
        commands.put("CREATE VERTEX", OCommandExecutorSQLCreateVertex.class);
        commands.put("DELETE VERTEX", OCommandExecutorSQLDeleteVertex.class);
        COMMANDS = Collections.unmodifiableMap(commands);
    }

    public static interface GraphCallBack<T> {
        public T call(OrientBaseGraph var1);
    }
}

