/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionConfigurableAbstract;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;

public class OSQLFunctionLabel
extends OSQLFunctionConfigurableAbstract {
    public static final String NAME = "label";

    public OSQLFunctionLabel() {
        super(NAME, 0, 0);
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        final OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(false);
        if (iCurrentResult != null) {
            return OSQLEngine.foreachRecord((OCallable)new OCallable<Object, OIdentifiable>(){

                public Object call(OIdentifiable iArgument) {
                    return OSQLFunctionLabel.this.getLabel(graph, iArgument);
                }
            }, (Object)iCurrentResult, (OCommandContext)iContext);
        }
        return this.getLabel(graph, iCurrentRecord);
    }

    private Object getLabel(OrientBaseGraph graph, OIdentifiable iCurrentRecord) {
        ODocument rec = (ODocument)iCurrentRecord.getRecord();
        if (rec.getSchemaClass().isSubClassOf("V")) {
            OrientVertex vertex = graph.getVertex(iCurrentRecord);
            return vertex.getLabel();
        }
        if (rec.getSchemaClass().isSubClassOf("E")) {
            OrientEdge edge = graph.getEdge(iCurrentRecord);
            return edge.getLabel();
        }
        throw new OCommandExecutionException("Invalid record: is neither a vertex nor an edge. Found class: " + rec.getSchemaClass());
    }

    public String getSyntax() {
        return "Syntax error: label()";
    }
}

