/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionPathFinder;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;

public class OSQLFunctionShortestPath
extends OSQLFunctionPathFinder {
    public static final String NAME = "shortestPath";
    protected static final float DISTANCE = 1.0f;

    public OSQLFunctionShortestPath() {
        super(NAME, 2, 3);
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(false);
        ORecordInternal record = (ORecordInternal)(iCurrentRecord != null ? iCurrentRecord.getRecord() : null);
        Object source = iParams[0];
        if (OMultiValue.isMultiValue((Object)source)) {
            if (OMultiValue.getSize((Object)source) > 1) {
                throw new IllegalArgumentException("Only one sourceVertex is allowed");
            }
            source = OMultiValue.getFirstValue((Object)source);
        }
        this.paramSourceVertex = graph.getVertex(OSQLHelper.getValue((Object)source, (ORecordInternal)record, (OCommandContext)iContext));
        Object dest = iParams[1];
        if (OMultiValue.isMultiValue((Object)dest)) {
            if (OMultiValue.getSize((Object)dest) > 1) {
                throw new IllegalArgumentException("Only one destinationVertex is allowed");
            }
            dest = OMultiValue.getFirstValue((Object)dest);
        }
        this.paramDestinationVertex = graph.getVertex(OSQLHelper.getValue((Object)dest, (ORecordInternal)record, (OCommandContext)iContext));
        if (iParams.length > 2) {
            this.paramDirection = Direction.valueOf((String)iParams[2].toString().toUpperCase());
        }
        return super.execute(iContext);
    }

    @Override
    protected float getDistance(OrientVertex node, OrientVertex target) {
        return 1.0f;
    }

    public String getSyntax() {
        return "shortestPath(<sourceVertex>, <destinationVertex>, [<direction>])";
    }
}

