/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.MetaGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.impls.orient.OrientElementScanIterable;
import com.tinkerpop.blueprints.impls.orient.OrientGraphCommand;
import com.tinkerpop.blueprints.impls.orient.OrientGraphContext;
import com.tinkerpop.blueprints.impls.orient.OrientGraphQuery;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionVertex;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public abstract class OrientBaseGraph
implements IndexableGraph,
MetaGraph<ODatabaseDocumentTx>,
KeyIndexableGraph {
    public static final String CONNECTION_OUT = "out";
    public static final String CONNECTION_IN = "in";
    public static final String CLASS_PREFIX = "class:";
    public static final String CLUSTER_PREFIX = "cluster:";
    protected static final String ADMIN = "admin";
    private static final Object manualIndexLock = new Object();
    private final ThreadLocal<OrientGraphContext> threadContext = new ThreadLocal();
    private final Set<OrientGraphContext> contexts = new HashSet<OrientGraphContext>();
    private final ODatabaseDocumentPool pool;
    protected Settings settings = new Settings();
    private String url;
    private String username;
    private String password;

    public OrientBaseGraph(ODatabaseDocumentTx iDatabase, String iUserName, String iUserPassword) {
        this.pool = null;
        this.username = iUserName;
        this.password = iUserPassword;
        this.reuse(iDatabase);
        this.readDatabaseConfiguration();
    }

    public OrientBaseGraph(ODatabaseDocumentPool pool) {
        this.pool = pool;
        ODatabaseDocumentTx db = (ODatabaseDocumentTx)pool.acquire();
        this.username = db.getUser() != null ? db.getUser().getName() : null;
        this.reuse(db);
        this.readDatabaseConfiguration();
    }

    public OrientBaseGraph(String url) {
        this(url, ADMIN, ADMIN);
    }

    public OrientBaseGraph(String url, String username, String password) {
        this.pool = null;
        this.url = OFileUtils.getPath((String)url);
        this.username = username;
        this.password = password;
        this.openOrCreate();
        this.readDatabaseConfiguration();
    }

    public OrientBaseGraph(Configuration configuration) {
        this(configuration.getString("blueprints.orientdb.url", null), configuration.getString("blueprints.orientdb.username", null), configuration.getString("blueprints.orientdb.password", null));
        Boolean lightweightEdges;
        Boolean useVertexFieldsForEdgeLabels;
        Boolean useCustomClassesForVertex;
        Boolean useCustomClassesForEdges;
        Boolean keepInMemoryReferences;
        Boolean saveOriginalIds = configuration.getBoolean("blueprints.orientdb.saveOriginalIds", null);
        if (saveOriginalIds != null) {
            this.setSaveOriginalIds(saveOriginalIds);
        }
        if ((keepInMemoryReferences = configuration.getBoolean("blueprints.orientdb.keepInMemoryReferences", null)) != null) {
            this.setKeepInMemoryReferences(keepInMemoryReferences);
        }
        if ((useCustomClassesForEdges = configuration.getBoolean("blueprints.orientdb.useCustomClassesForEdges", null)) != null) {
            this.setUseClassForEdgeLabel(useCustomClassesForEdges);
        }
        if ((useCustomClassesForVertex = configuration.getBoolean("blueprints.orientdb.useCustomClassesForVertex", null)) != null) {
            this.setUseClassForVertexLabel(useCustomClassesForVertex);
        }
        if ((useVertexFieldsForEdgeLabels = configuration.getBoolean("blueprints.orientdb.useVertexFieldsForEdgeLabels", null)) != null) {
            this.setUseVertexFieldsForEdgeLabels(useVertexFieldsForEdgeLabels);
        }
        if ((lightweightEdges = configuration.getBoolean("blueprints.orientdb.lightweightEdges", null)) != null) {
            this.setUseLightweightEdges(lightweightEdges);
        }
    }

    public static void encodeClassNames(String ... iLabels) {
        if (iLabels != null) {
            for (int i = 0; i < iLabels.length; ++i) {
                iLabels[i] = OrientBaseGraph.encodeClassName(iLabels[i]);
            }
        }
    }

    public static String encodeClassName(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        if (Character.isDigit(iClassName.charAt(0))) {
            iClassName = "-" + iClassName;
        }
        try {
            return URLEncoder.encode(iClassName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return iClassName;
        }
    }

    public static String decodeClassName(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        if (iClassName.charAt(0) == '-') {
            iClassName = iClassName.substring(1);
        }
        try {
            return URLDecoder.decode(iClassName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return iClassName;
        }
    }

    public void drop() {
        this.getRawGraph().drop();
    }

    public <T extends Element> Index<T> createIndex(final String indexName, final Class<T> indexClass, Parameter ... indexParameters) {
        final OrientGraphContext context = this.getContext(true);
        return (Index)this.executeOutsideTx(new OCallable<Index<T>, OrientBaseGraph>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Index<T> call(OrientBaseGraph g) {
                Object object = manualIndexLock;
                synchronized (object) {
                    ODatabaseDocumentTx database = context.rawGraph;
                    OIndexManagerProxy indexManager = database.getMetadata().getIndexManager();
                    if (indexManager.getIndex(indexName) != null) {
                        throw ExceptionFactory.indexAlreadyExists((String)indexName);
                    }
                    OrientIndex index = new OrientIndex(g, indexName, indexClass, null);
                    OrientBaseGraph.this.saveIndexConfiguration();
                    return index;
                }
            }
        }, "create index '", indexName, "'");
    }

    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        OrientGraphContext context = this.getContext(true);
        ODatabaseDocumentTx database = context.rawGraph;
        OIndexManagerProxy indexManager = database.getMetadata().getIndexManager();
        OIndex idx = indexManager.getIndex(indexName);
        if (idx == null || !this.hasIndexClass(idx)) {
            return null;
        }
        OrientIndex index = new OrientIndex(this, idx);
        if (indexClass.isAssignableFrom(index.getIndexClass())) {
            return index;
        }
        throw ExceptionFactory.indexDoesNotSupportClass((String)indexName, indexClass);
    }

    public Iterable<Index<? extends Element>> getIndices() {
        OrientGraphContext context = this.getContext(true);
        return this.loadManualIndexes(context);
    }

    public void dropIndex(final String indexName) {
        this.executeOutsideTx(new OCallable<Object, OrientBaseGraph>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(OrientBaseGraph g) {
                try {
                    Object object = manualIndexLock;
                    synchronized (object) {
                        OIndexManagerProxy indexManager = OrientBaseGraph.this.getRawGraph().getMetadata().getIndexManager();
                        OIndex index = indexManager.getIndex(indexName);
                        String recordMapIndexName = (String)index.getConfiguration().field("record_map_name");
                        indexManager.dropIndex(indexName);
                        if (recordMapIndexName != null) {
                            OrientBaseGraph.this.getRawGraph().getMetadata().getIndexManager().dropIndex(recordMapIndexName);
                        }
                        OrientBaseGraph.this.saveIndexConfiguration();
                        return null;
                    }
                }
                catch (Exception e) {
                    g.rollback();
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }, "drop index '", indexName, "'");
    }

    public OrientVertex addVertex(Object id) {
        return this.addVertex(id, (Object[])null);
    }

    public OrientVertex addVertex(Object id, Object ... prop) {
        String className = null;
        String clusterName = null;
        Object[] fields = null;
        if (id != null) {
            if (id instanceof String) {
                String[] args;
                for (String s : args = ((String)id).split(",")) {
                    if (s.startsWith(CLASS_PREFIX)) {
                        className = s.substring(CLASS_PREFIX.length());
                        continue;
                    }
                    if (!s.startsWith(CLUSTER_PREFIX)) continue;
                    clusterName = s.substring(CLUSTER_PREFIX.length());
                }
            }
            if (this.settings.saveOriginalIds) {
                fields = new Object[]{OrientElement.DEF_ORIGINAL_ID_FIELDNAME, id};
            }
        }
        this.setCurrentGraphInThreadLocal();
        this.autoStartTransaction();
        OrientVertex vertex = new OrientVertex(this, className, fields);
        vertex.setProperties(prop);
        if (clusterName != null) {
            vertex.save(clusterName);
        } else {
            vertex.save();
        }
        return vertex;
    }

    public OrientVertex addVertex(String iClassName, String iClusterName) {
        this.setCurrentGraphInThreadLocal();
        this.autoStartTransaction();
        OrientVertex vertex = new OrientVertex(this, iClassName, new Object[0]);
        if (iClusterName != null) {
            vertex.save(iClusterName);
        } else {
            vertex.save();
        }
        return vertex;
    }

    public OrientVertex addTemporaryVertex(String iClassName, Object ... prop) {
        this.setCurrentGraphInThreadLocal();
        this.autoStartTransaction();
        OrientVertex vertex = new OrientVertex(this, iClassName, new Object[0]);
        vertex.setProperties(prop);
        return vertex;
    }

    public OrientEdge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Object[] fields;
        Object[] objectArray;
        String className = null;
        String clusterName = null;
        if (id != null && id instanceof String) {
            String[] args;
            for (String s : args = ((String)id).split(",")) {
                if (s.startsWith(CLASS_PREFIX)) {
                    className = s.substring(CLASS_PREFIX.length());
                    continue;
                }
                if (!s.startsWith(CLUSTER_PREFIX)) continue;
                clusterName = s.substring(CLUSTER_PREFIX.length());
            }
        }
        if (id != null && id instanceof String && id.toString().startsWith(CLASS_PREFIX)) {
            className = id.toString().substring(CLASS_PREFIX.length());
        }
        if (this.settings.saveOriginalIds && id != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = OrientElement.DEF_ORIGINAL_ID_FIELDNAME;
            objectArray = objectArray2;
            objectArray2[1] = id;
        } else {
            objectArray = fields = null;
        }
        if (outVertex instanceof PartitionVertex) {
            outVertex = ((PartitionVertex)outVertex).getBaseVertex();
        }
        if (inVertex instanceof PartitionVertex) {
            inVertex = ((PartitionVertex)inVertex).getBaseVertex();
        }
        return ((OrientVertex)outVertex).addEdge(label, (OrientVertex)inVertex, className, clusterName, fields);
    }

    public OrientVertex getVertex(Object id) {
        ORID rid;
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        if (id instanceof OrientVertex) {
            return (OrientVertex)id;
        }
        if (id instanceof ODocument) {
            return new OrientVertex(this, (OIdentifiable)id);
        }
        this.setCurrentGraphInThreadLocal();
        if (id instanceof OIdentifiable) {
            rid = ((OIdentifiable)id).getIdentity();
        } else {
            try {
                rid = new ORecordId(id.toString());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        if (!rid.isValid()) {
            return null;
        }
        ODocument doc = (ODocument)rid.getRecord();
        if (doc == null) {
            return null;
        }
        return new OrientVertex(this, (OIdentifiable)doc);
    }

    public void removeVertex(Vertex vertex) {
        vertex.remove();
    }

    public Iterable<Vertex> getVertices() {
        return this.getVerticesOfClass("V", true);
    }

    public Iterable<Vertex> getVertices(boolean iPolymorphic) {
        return this.getVerticesOfClass("V", iPolymorphic);
    }

    public Iterable<Vertex> getVerticesOfClass(String iClassName) {
        return this.getVerticesOfClass(iClassName, true);
    }

    public Iterable<Vertex> getVerticesOfClass(String iClassName, boolean iPolymorphic) {
        this.getContext(true);
        return new OrientElementScanIterable(this, iClassName, iPolymorphic);
    }

    public Iterable<Vertex> getVertices(String iKey, Object iValue) {
        OIndex idx;
        String key;
        String indexName;
        if (iKey.equals("@class")) {
            return this.getVerticesOfClass(iValue.toString());
        }
        int pos = iKey.indexOf(46);
        if (pos > -1) {
            indexName = iKey;
            String className = iKey.substring(0, pos);
            key = iKey.substring(iKey.indexOf(46) + 1);
            OClass clazz = this.getContext((boolean)true).rawGraph.getMetadata().getSchema().getClass(className);
            Set indexes = clazz.getIndexes();
            for (OIndex index : indexes) {
                int point;
                String oInName = index.getName();
                String okey = oInName.substring((point = oInName.indexOf(".")) + 1);
                if (!okey.equals(key)) continue;
                indexName = oInName;
                break;
            }
        } else {
            indexName = "V." + iKey;
            key = iKey;
        }
        if ((idx = this.getContext((boolean)true).rawGraph.getMetadata().getIndexManager().getIndex(indexName)) != null) {
            List<Object> indexValue = idx.get(iValue = this.convertKey(idx, iValue));
            if (indexValue != null && !(indexValue instanceof Iterable)) {
                indexValue = Arrays.asList(indexValue);
            }
            return new OrientElementIterable(this, (Iterable)indexValue);
        }
        return this.query().has(key, iValue).vertices();
    }

    public Iterable<Vertex> getVertices(String label, String[] iKey, Object[] iValue) {
        OIndex idx;
        OClass clazz = this.getContext((boolean)true).rawGraph.getMetadata().getSchema().getClass(label);
        Set indexes = clazz.getInvolvedIndexes(Arrays.asList(iKey));
        if (indexes.iterator().hasNext() && (idx = (OIndex)indexes.iterator().next()) != null) {
            List<Object> keys = Arrays.asList(this.convertKeys(idx, iValue));
            OCompositeKey compositeKey = new OCompositeKey(keys);
            List<Object> indexValue = idx.get((Object)compositeKey);
            if (indexValue != null && !(indexValue instanceof Iterable)) {
                indexValue = Arrays.asList(indexValue);
            }
            return new OrientElementIterable(this, (Iterable)indexValue);
        }
        GraphQuery query = this.query();
        for (int i = 0; i < iKey.length; ++i) {
            query.has(iKey[i], iValue[i]);
        }
        return query.vertices();
    }

    public Iterable<Edge> getEdges() {
        return this.getEdgesOfClass("E", true);
    }

    public Iterable<Edge> getEdges(boolean iPolymorphic) {
        return this.getEdgesOfClass("E", iPolymorphic);
    }

    public Iterable<Edge> getEdgesOfClass(String iClassName) {
        return this.getEdgesOfClass(iClassName, true);
    }

    public Iterable<Edge> getEdgesOfClass(String iClassName, boolean iPolymorphic) {
        this.getContext(true);
        return new OrientElementScanIterable(this, iClassName, iPolymorphic);
    }

    public Iterable<Edge> getEdges(String iKey, Object iValue) {
        String key;
        String indexName;
        if (iKey.equals("@class")) {
            return this.getEdgesOfClass(iValue.toString());
        }
        int pos = iKey.indexOf(46);
        if (pos > -1) {
            indexName = iKey;
            key = iKey.substring(iKey.indexOf(46) + 1);
        } else {
            indexName = "E." + iKey;
            key = iKey;
        }
        OIndex idx = this.getContext((boolean)true).rawGraph.getMetadata().getIndexManager().getIndex(indexName);
        if (idx != null) {
            List<Object> indexValue = idx.get(iValue = this.convertKey(idx, iValue));
            if (indexValue != null && !(indexValue instanceof Iterable)) {
                indexValue = Arrays.asList(indexValue);
            }
            return new OrientElementIterable(this, (Iterable)indexValue);
        }
        return this.query().has(key, iValue).edges();
    }

    public OrientEdge getEdge(Object id) {
        OIdentifiable rec;
        if (null == id) {
            throw ExceptionFactory.edgeIdCanNotBeNull();
        }
        if (id instanceof OrientEdge) {
            return (OrientEdge)id;
        }
        if (id instanceof ODocument) {
            return new OrientEdge(this, (OIdentifiable)id);
        }
        if (id instanceof OIdentifiable) {
            rec = (OIdentifiable)id;
        } else {
            String str = id.toString();
            int pos = str.indexOf("->");
            if (pos > -1) {
                String from = str.substring(0, pos);
                String to = str.substring(pos + 2);
                return new OrientEdge(this, (OIdentifiable)new ORecordId(from), (OIdentifiable)new ORecordId(to));
            }
            try {
                rec = new ORecordId(str);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        ODocument doc = (ODocument)rec.getRecord();
        if (doc == null) {
            return null;
        }
        return new OrientEdge(this, rec);
    }

    public void removeEdge(Edge edge) {
        edge.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrientBaseGraph reuse(ODatabaseDocumentTx iDatabase) {
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)iDatabase);
        this.url = iDatabase.getURL();
        OrientBaseGraph orientBaseGraph = this;
        synchronized (orientBaseGraph) {
            OrientGraphContext context = this.threadContext.get();
            if (context == null || !context.rawGraph.getName().equals(iDatabase.getName()) || context.rawGraph.isClosed()) {
                this.removeContext();
                context = new OrientGraphContext();
                context.rawGraph = iDatabase;
                OrientBaseGraph.checkForGraphSchema(iDatabase);
                this.threadContext.set(context);
                this.contexts.add(context);
            }
        }
        return this;
    }

    public boolean isClosed() {
        OrientGraphContext context = this.getContext(false);
        return context == null || context.rawGraph.isClosed();
    }

    public void shutdown() {
        this.removeContext();
        this.url = null;
        this.username = null;
        this.password = null;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.getRawGraph().getURL());
    }

    public ODatabaseDocumentTx getRawGraph() {
        return this.getContext((boolean)true).rawGraph;
    }

    public void commit() {
    }

    public void rollback() {
    }

    public OrientVertexType getVertexBaseType() {
        return new OrientVertexType(this, this.getRawGraph().getMetadata().getSchema().getClass("V"));
    }

    public final OrientVertexType getVertexType(String iTypeName) {
        OClass cls = this.getRawGraph().getMetadata().getSchema().getClass(iTypeName);
        if (cls == null) {
            return null;
        }
        OrientVertexType.checkType(cls);
        return new OrientVertexType(this, cls);
    }

    public OrientVertexType createVertexType(String iClassName) {
        return this.createVertexType(iClassName, (String)null);
    }

    public OrientVertexType createVertexType(String iClassName, String iSuperClassName) {
        return this.createVertexType(iClassName, (OClass)(iSuperClassName == null ? this.getVertexBaseType() : this.getVertexType(iSuperClassName)));
    }

    public OrientVertexType createVertexType(final String iClassName, final OClass iSuperClass) {
        OrientVertexType.checkType(iSuperClass);
        return this.executeOutsideTx(new OCallable<OrientVertexType, OrientBaseGraph>(){

            public OrientVertexType call(OrientBaseGraph g) {
                return new OrientVertexType(g, OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().createClass(iClassName, iSuperClass));
            }
        }, "create vertex type '", iClassName, "' as subclass of '", iSuperClass.getName(), "'");
    }

    public final void dropVertexType(final String iTypeName) {
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            public OClass call(OrientBaseGraph g) {
                OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().dropClass(iTypeName);
                return null;
            }
        }, "drop vertex type '", iTypeName, "'");
    }

    public OrientEdgeType getEdgeBaseType() {
        return new OrientEdgeType(this);
    }

    public final OrientEdgeType getEdgeType(String iTypeName) {
        OClass cls = this.getRawGraph().getMetadata().getSchema().getClass(iTypeName);
        if (cls == null) {
            return null;
        }
        OrientEdgeType.checkType(cls);
        return new OrientEdgeType(this, cls);
    }

    public OrientEdgeType createEdgeType(String iClassName) {
        return this.createEdgeType(iClassName, (String)null);
    }

    public OrientEdgeType createEdgeType(String iClassName, String iSuperClassName) {
        return this.createEdgeType(iClassName, (OClass)(iSuperClassName == null ? this.getEdgeBaseType() : this.getEdgeType(iSuperClassName)));
    }

    public OrientEdgeType createEdgeType(final String iClassName, final OClass iSuperClass) {
        OrientEdgeType.checkType(iSuperClass);
        return this.executeOutsideTx(new OCallable<OrientEdgeType, OrientBaseGraph>(){

            public OrientEdgeType call(OrientBaseGraph g) {
                return new OrientEdgeType(g, OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().createClass(iClassName, iSuperClass));
            }
        }, "create edge type '", iClassName, "' as subclass of '", iSuperClass.getName(), "'");
    }

    public final void dropEdgeType(final String iTypeName) {
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            public OClass call(OrientBaseGraph g) {
                OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().dropClass(iTypeName);
                return null;
            }
        }, "drop edge type '", iTypeName, "'");
    }

    public OrientElement detach(OrientElement iElement) {
        iElement.detach();
        return iElement;
    }

    public OrientElement attach(OrientElement iElement) {
        return iElement.attach(this);
    }

    public OrientElement getElement(Object id) {
        OIdentifiable rec;
        if (null == id) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (id instanceof OrientElement) {
            return (OrientElement)id;
        }
        if (id instanceof OIdentifiable) {
            rec = (OIdentifiable)id;
        } else {
            try {
                rec = new ORecordId(id.toString());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        ODocument doc = (ODocument)rec.getRecord();
        if (doc != null) {
            OClass schemaClass = doc.getSchemaClass();
            if (schemaClass != null && schemaClass.isSubClassOf("E")) {
                return new OrientEdge(this, (OIdentifiable)doc);
            }
            return new OrientVertex(this, (OIdentifiable)doc);
        }
        return null;
    }

    public <T extends Element> void dropKeyIndex(final String key, final Class<T> elementClass) {
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            public OClass call(OrientBaseGraph g) {
                String className = OrientBaseGraph.this.getClassName(elementClass);
                OrientBaseGraph.this.getRawGraph().getMetadata().getIndexManager().dropIndex(className + "." + key);
                return null;
            }
        }, "drop key index '", elementClass.getSimpleName(), ".", key, "'");
    }

    public <T extends Element> void createKeyIndex(final String key, final Class<T> elementClass, final Parameter ... indexParameters) {
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            public OClass call(OrientBaseGraph g) {
                ODatabaseDocumentTx db;
                OSchema schema;
                OClass cls;
                OProperty property;
                String indexType = OClass.INDEX_TYPE.NOTUNIQUE.name();
                OType keyType = OType.STRING;
                String className = null;
                String ancestorClassName = OrientBaseGraph.this.getClassName(elementClass);
                for (Parameter p : indexParameters) {
                    if (p.getKey().equals("type")) {
                        indexType = p.getValue().toString().toUpperCase();
                        continue;
                    }
                    if (p.getKey().equals("keytype")) {
                        keyType = OType.valueOf((String)p.getValue().toString().toUpperCase());
                        continue;
                    }
                    if (!p.getKey().equals("class")) continue;
                    className = p.getValue().toString();
                }
                if (className == null) {
                    className = ancestorClassName;
                }
                if ((property = (cls = (schema = (db = OrientBaseGraph.this.getRawGraph()).getMetadata().getSchema()).getOrCreateClass(className, schema.getClass(ancestorClassName))).getProperty(key)) != null) {
                    keyType = property.getType();
                }
                db.getMetadata().getIndexManager().createIndex(className + "." + key, indexType, (OIndexDefinition)new OPropertyIndexDefinition(className, key, keyType), cls.getPolymorphicClusterIds(), null, null);
                return null;
            }
        }, "create key index on '", elementClass.getSimpleName(), ".", key, "'");
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        return this.getIndexedKeys(elementClass, false);
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass, boolean includeClassNames) {
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        OSchema schema = this.getRawGraph().getMetadata().getSchema();
        String elementOClassName = this.getClassName(elementClass);
        HashSet<String> result = new HashSet<String>();
        Collection indexes = this.getRawGraph().getMetadata().getIndexManager().getIndexes();
        for (OIndex index : indexes) {
            String oClassName;
            OClass oClass;
            String indexName = index.getName();
            int point = indexName.indexOf(".");
            if (point <= 0 || !(oClass = schema.getClass(oClassName = indexName.substring(0, point))).isSubClassOf(elementOClassName)) continue;
            if (includeClassNames) {
                result.add(index.getName());
                continue;
            }
            result.add((String)index.getDefinition().getFields().get(0));
        }
        return result;
    }

    public GraphQuery query() {
        return new OrientGraphQuery((Graph)this);
    }

    public OTraverse traverse() {
        return new OTraverse();
    }

    public OCommandRequest command(OCommandRequest iCommand) {
        return new OrientGraphCommand(this, this.getRawGraph().command(iCommand));
    }

    public long countVertices() {
        return this.getRawGraph().countClass("V");
    }

    public long countVertices(String iClassName) {
        return this.getRawGraph().countClass(iClassName);
    }

    public long countEdges() {
        if (this.settings.useLightweightEdges) {
            throw new UnsupportedOperationException("Graph set to use Lightweight Edges, count against edges is not supported");
        }
        return this.getRawGraph().countClass("E");
    }

    public long countEdges(String iClassName) {
        if (this.settings.useLightweightEdges) {
            throw new UnsupportedOperationException("Graph set to use Lightweight Edges, count against edges is not supported");
        }
        return this.getRawGraph().countClass(iClassName);
    }

    public boolean isUseLightweightEdges() {
        return this.settings.useLightweightEdges;
    }

    public void setUseLightweightEdges(boolean useDynamicEdges) {
        this.settings.useLightweightEdges = useDynamicEdges;
    }

    public boolean isSaveOriginalIds() {
        return this.settings.saveOriginalIds;
    }

    public void setSaveOriginalIds(boolean saveIds) {
        this.settings.saveOriginalIds = saveIds;
    }

    public boolean isKeepInMemoryReferences() {
        return this.settings.keepInMemoryReferences;
    }

    public void setKeepInMemoryReferences(boolean useReferences) {
        this.settings.keepInMemoryReferences = useReferences;
    }

    public boolean isUseClassForEdgeLabel() {
        return this.settings.useClassForEdgeLabel;
    }

    public void setUseClassForEdgeLabel(boolean useCustomClassesForEdges) {
        this.settings.useClassForEdgeLabel = useCustomClassesForEdges;
    }

    public boolean isUseClassForVertexLabel() {
        return this.settings.useClassForVertexLabel;
    }

    public void setUseClassForVertexLabel(boolean useCustomClassesForVertex) {
        this.settings.useClassForVertexLabel = useCustomClassesForVertex;
    }

    public boolean isUseVertexFieldsForEdgeLabels() {
        return this.settings.useVertexFieldsForEdgeLabels;
    }

    public void setUseVertexFieldsForEdgeLabels(boolean useVertexFieldsForEdgeLabels) {
        this.settings.useVertexFieldsForEdgeLabels = useVertexFieldsForEdgeLabels;
    }

    public boolean isStandardElementConstraints() {
        return this.settings.standardElementConstraints;
    }

    public void setStandardElementConstraints(boolean allowsPropertyValueNull) {
        this.settings.standardElementConstraints = allowsPropertyValueNull;
    }

    public boolean isWarnOnForceClosingTx() {
        return this.settings.warnOnForceClosingTx;
    }

    public OrientBaseGraph setWarnOnForceClosingTx(boolean warnOnSchemaChangeInTx) {
        this.settings.warnOnForceClosingTx = warnOnSchemaChangeInTx;
        return this;
    }

    public THREAD_MODE getThreadMode() {
        return this.settings.threadMode;
    }

    public OrientBaseGraph setThreadMode(THREAD_MODE iControl) {
        this.settings.threadMode = iControl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeContext() {
        ArrayList<OrientGraphContext> contextsToRemove = new ArrayList<OrientGraphContext>();
        Set<OrientGraphContext> set = this.contexts;
        synchronized (set) {
            for (OrientGraphContext contextItem : this.contexts) {
                if (contextItem.thread.isAlive()) continue;
                contextsToRemove.add(contextItem);
            }
        }
        OrientGraphContext context = this.getContext(false);
        if (context != null) {
            contextsToRemove.add(context);
        }
        for (OrientGraphContext contextItem : contextsToRemove) {
            try {
                if (contextItem.rawGraph.isClosed()) continue;
                contextItem.rawGraph.commit();
            }
            catch (RuntimeException e) {
                OLogManager.instance().error((Object)this, "Error during context close for db " + this.url, (Throwable)e, new Object[0]);
                throw e;
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error during context close for db " + this.url, (Throwable)e, new Object[0]);
                throw new OException("Error during context close for db " + this.url, (Throwable)e);
            }
            finally {
                try {
                    contextItem.rawGraph.close();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error during context close for db " + this.url, (Throwable)e, new Object[0]);
                }
            }
        }
        Set<OrientGraphContext> set2 = this.contexts;
        synchronized (set2) {
            for (OrientGraphContext contextItem : contextsToRemove) {
                this.contexts.remove(contextItem);
            }
        }
        this.threadContext.set(null);
    }

    protected static void checkForGraphSchema(ODatabaseDocumentTx iDatabase) {
        OSchema schema = iDatabase.getMetadata().getSchema();
        schema.getOrCreateClass("ORIDs");
        OClass vertexBaseClass = schema.getClass("V");
        OClass edgeBaseClass = schema.getClass("E");
        if (vertexBaseClass == null) {
            schema.createClass("V").setOverSize(2.0f);
        }
        if (edgeBaseClass == null) {
            schema.createClass("E");
        }
        boolean warn = false;
        String MSG_SUFFIX = ". Probably you are using a database created with a previous version of OrientDB. Export in graphml format and reimport it";
        if (vertexBaseClass != null) {
            if (!vertexBaseClass.getName().equals("V")) {
                OLogManager.instance().warn(null, "Found Vertex class %s. Probably you are using a database created with a previous version of OrientDB. Export in graphml format and reimport it", new Object[]{vertexBaseClass.getName()});
                warn = true;
            }
            if (vertexBaseClass.existsProperty(CONNECTION_OUT) || vertexBaseClass.existsProperty(CONNECTION_IN)) {
                OLogManager.instance().warn(null, "Found property in/out against V", new Object[0]);
                warn = true;
            }
        }
        if (edgeBaseClass != null) {
            if (!warn && !edgeBaseClass.getName().equals("E")) {
                OLogManager.instance().warn(null, "Found Edge class %s. Probably you are using a database created with a previous version of OrientDB. Export in graphml format and reimport it", new Object[]{edgeBaseClass.getName()});
                warn = true;
            }
            if (edgeBaseClass.existsProperty(CONNECTION_OUT) || edgeBaseClass.existsProperty(CONNECTION_IN)) {
                OLogManager.instance().warn(null, "Found property in/out against E", new Object[0]);
                warn = true;
            }
        }
    }

    protected void autoStartTransaction() {
    }

    protected void saveIndexConfiguration() {
        this.getRawGraph().getMetadata().getIndexManager().getConfiguration().save();
    }

    protected OrientGraphContext getContext(boolean create) {
        OrientGraphContext context = this.threadContext.get();
        if ((context == null || !context.rawGraph.getURL().equals(this.url)) && create) {
            context = this.openOrCreate();
        }
        return context;
    }

    protected <T> String getClassName(Class<T> elementClass) {
        if (elementClass.isAssignableFrom(Vertex.class)) {
            return "V";
        }
        if (elementClass.isAssignableFrom(Edge.class)) {
            return "E";
        }
        throw new IllegalArgumentException("Class '" + elementClass + "' is neither a Vertex, nor an Edge");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RET> RET executeOutsideTx(OCallable<RET, OrientBaseGraph> iCallable, String ... iOperationStrings) throws RuntimeException {
        boolean committed;
        ODatabaseDocumentTx raw = this.getRawGraph();
        if (raw.getTransaction().isActive()) {
            if (this.settings.warnOnForceClosingTx && OLogManager.instance().isWarnEnabled()) {
                StringBuilder msg = new StringBuilder();
                for (String s : iOperationStrings) {
                    msg.append(s);
                }
                OLogManager.instance().warn((Object)this, "Requested command '%s' must be executed outside active transaction: the transaction will be committed and reopen right after it. To avoid this behavior execute it outside a transaction", new Object[]{msg.toString()});
            }
            raw.commit();
            committed = true;
        } else {
            committed = false;
        }
        try {
            Object object = iCallable.call((Object)this);
            return (RET)object;
        }
        finally {
            if (committed) {
                this.autoStartTransaction();
            }
        }
    }

    protected Object convertKey(OIndex<?> idx, Object iValue) {
        if (iValue != null) {
            OType[] types = idx.getKeyTypes();
            iValue = types.length == 0 ? iValue.toString() : OType.convert((Object)iValue, (Class)types[0].getDefaultJavaType());
        }
        return iValue;
    }

    protected Object[] convertKeys(OIndex<?> idx, Object[] iValue) {
        OType[] types;
        if (iValue != null && (types = idx.getKeyTypes()).length == iValue.length) {
            Object[] newValue = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                newValue[i] = OType.convert((Object)iValue[i], (Class)types[i].getDefaultJavaType());
            }
            iValue = newValue;
        }
        return iValue;
    }

    protected void setCurrentGraphInThreadLocal() {
        OrientGraphContext ctx;
        if (this.settings.threadMode == THREAD_MODE.MANUAL) {
            return;
        }
        ODatabaseRecord tlDb = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (!(this.settings.threadMode != THREAD_MODE.ALWAYS_AUTOSET && tlDb != null || (ctx = this.getContext(true)) == null || tlDb != null && tlDb == ctx.rawGraph)) {
            ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)this.getRawGraph());
        }
    }

    private void readDatabaseConfiguration() {
        List custom = (List)this.getRawGraph().get(ODatabase.ATTRIBUTES.CUSTOM);
        for (OStorageEntryConfiguration c : custom) {
            if (c.name.equals("useLightweightEdges")) {
                this.setUseLightweightEdges(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("useClassForEdgeLabel")) {
                this.setUseClassForEdgeLabel(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("useClassForVertexLabel")) {
                this.setUseClassForVertexLabel(Boolean.parseBoolean(c.value));
                continue;
            }
            if (!c.name.equals("useVertexFieldsForEdgeLabels")) continue;
            this.setUseVertexFieldsForEdgeLabels(Boolean.parseBoolean(c.value));
        }
        this.loadManualIndexes(this.threadContext.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrientGraphContext openOrCreate() {
        if (this.url == null) {
            throw new IllegalStateException("Database is closed");
        }
        OrientBaseGraph orientBaseGraph = this;
        synchronized (orientBaseGraph) {
            OrientGraphContext context = this.threadContext.get();
            if (context != null) {
                this.removeContext();
            }
            context = new OrientGraphContext();
            this.threadContext.set(context);
            Set<OrientGraphContext> set = this.contexts;
            synchronized (set) {
                this.contexts.add(context);
            }
            if (this.pool == null) {
                context.rawGraph = new ODatabaseDocumentTx(this.url);
                if (this.url.startsWith("remote:") || context.rawGraph.exists()) {
                    context.rawGraph.open(this.username, this.password);
                } else {
                    context.rawGraph.create();
                }
            } else {
                context.rawGraph = (ODatabaseDocumentTx)this.pool.acquire();
            }
            OrientBaseGraph.checkForGraphSchema(context.rawGraph);
            return context;
        }
    }

    private List<Index<? extends Element>> loadManualIndexes(OrientGraphContext context) {
        ArrayList<Index<? extends Element>> result = new ArrayList<Index<? extends Element>>();
        for (OIndex idx : context.rawGraph.getMetadata().getIndexManager().getIndexes()) {
            if (!this.hasIndexClass(idx)) continue;
            result.add(new OrientIndex(this, idx));
        }
        return result;
    }

    private boolean hasIndexClass(OIndex<?> idx) {
        ODocument metadata = idx.getMetadata();
        return metadata != null && metadata.field("blueprintsIndexClass") != null || idx.getConfiguration().field("blueprintsIndexClass") != null;
    }

    public class Settings {
        protected boolean useLightweightEdges = true;
        protected boolean useClassForEdgeLabel = true;
        protected boolean useClassForVertexLabel = true;
        protected boolean keepInMemoryReferences = false;
        protected boolean useVertexFieldsForEdgeLabels = true;
        protected boolean saveOriginalIds = false;
        protected boolean standardElementConstraints = true;
        protected boolean warnOnForceClosingTx = true;
        protected THREAD_MODE threadMode = THREAD_MODE.AUTOSET_IFNULL;

        public Settings copy() {
            Settings copy = new Settings();
            copy.useLightweightEdges = this.useLightweightEdges;
            copy.useClassForEdgeLabel = this.useClassForEdgeLabel;
            copy.useClassForVertexLabel = this.useClassForVertexLabel;
            copy.keepInMemoryReferences = this.keepInMemoryReferences;
            copy.useVertexFieldsForEdgeLabels = this.useVertexFieldsForEdgeLabels;
            copy.saveOriginalIds = this.saveOriginalIds;
            copy.standardElementConstraints = this.standardElementConstraints;
            copy.warnOnForceClosingTx = this.warnOnForceClosingTx;
            copy.threadMode = this.threadMode;
            return copy;
        }
    }

    public static enum THREAD_MODE {
        MANUAL,
        AUTOSET_IFNULL,
        ALWAYS_AUTOSET;

    }
}

