/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OrientEdge
extends OrientElement
implements Edge {
    private static final long serialVersionUID = 1L;
    protected OIdentifiable vOut;
    protected OIdentifiable vIn;
    protected String label;

    public OrientEdge() {
        super(null, null);
    }

    protected OrientEdge(OrientBaseGraph rawGraph, OIdentifiable rawEdge) {
        super(rawGraph, rawEdge);
    }

    protected OrientEdge(OrientBaseGraph rawGraph, String iLabel, Object ... fields) {
        super(rawGraph, null);
        this.rawElement = this.createDocument(iLabel);
        this.setProperties(fields);
    }

    protected OrientEdge(OrientBaseGraph rawGraph, OIdentifiable out, OIdentifiable in) {
        this(rawGraph, out, in, null);
    }

    protected OrientEdge(OrientBaseGraph rawGraph, OIdentifiable out, OIdentifiable in, String iLabel) {
        super(rawGraph, null);
        this.vOut = out;
        this.vIn = in;
        this.label = iLabel;
    }

    public static OIdentifiable getConnection(ODocument iEdgeRecord, Direction iDirection) {
        return (OIdentifiable)iEdgeRecord.rawField(iDirection == Direction.OUT ? "out" : "in");
    }

    public static boolean isLabeled(String iEdgeLabel, String[] iLabels) {
        if (iLabels != null && iLabels.length > 0) {
            if (iEdgeLabel != null) {
                for (String l : iLabels) {
                    if (!l.equals(iEdgeLabel)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static String getRecordLabel(OIdentifiable iEdge) {
        if (iEdge == null) {
            return null;
        }
        ODocument edge = (ODocument)iEdge.getRecord();
        if (edge == null) {
            return null;
        }
        return (String)edge.field("label");
    }

    private static void removeLightweightConnection(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove) {
        if (iVertex == null || iVertexToRemove == null) {
            return;
        }
        Object fieldValue = iVertex.field(iFieldName);
        if (fieldValue instanceof OIdentifiable) {
            if (fieldValue.equals(iVertexToRemove)) {
                iVertex.removeField(iFieldName);
            }
        } else if (fieldValue instanceof ORidBag) {
            ((ORidBag)fieldValue).remove(iVertexToRemove);
        }
    }

    public OrientVertex getVertex(Direction direction) {
        if (this.graph != null) {
            this.graph.setCurrentGraphInThreadLocal();
        }
        if (direction.equals((Object)Direction.OUT)) {
            return new OrientVertex(this.graph, this.getOutVertex());
        }
        if (direction.equals((Object)Direction.IN)) {
            return new OrientVertex(this.graph, this.getInVertex());
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    public OIdentifiable getOutVertex() {
        ODocument doc;
        if (this.vOut != null) {
            return this.vOut;
        }
        if (this.graph != null) {
            this.graph.setCurrentGraphInThreadLocal();
        }
        if ((doc = this.getRecord()) == null) {
            return null;
        }
        if (this.settings != null && this.settings.keepInMemoryReferences) {
            return (OIdentifiable)doc.rawField("out");
        }
        return (OIdentifiable)doc.field("out");
    }

    public OIdentifiable getInVertex() {
        ODocument doc;
        if (this.vIn != null) {
            return this.vIn;
        }
        if (this.graph != null) {
            this.graph.setCurrentGraphInThreadLocal();
        }
        if ((doc = this.getRecord()) == null) {
            return null;
        }
        if (this.settings != null && this.settings.keepInMemoryReferences) {
            return (OIdentifiable)doc.rawField("in");
        }
        return (OIdentifiable)doc.field("in");
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.rawElement != null) {
            ODocument doc;
            String clsName;
            if (this.settings != null && this.settings.useClassForEdgeLabel && !"E".equals(clsName = this.getRecord().getClassName()) && !"OGraphEdge".equals(clsName)) {
                return OrientBaseGraph.decodeClassName(clsName);
            }
            if (this.graph != null) {
                this.graph.setCurrentGraphInThreadLocal();
            }
            if ((doc = (ODocument)this.rawElement.getRecord()) == null) {
                return null;
            }
            String label = (String)doc.field("label");
            if (label != null) {
                return OrientBaseGraph.decodeClassName(label);
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (this.rawElement == null && object instanceof OrientEdge) {
            OrientEdge other = (OrientEdge)object;
            return this.vOut.equals(other.vOut) && this.vIn.equals(other.vIn) && (this.label == null && other.label == null || this.label.equals(other.label));
        }
        return super.equals(object);
    }

    @Override
    public Object getId() {
        if (this.rawElement == null) {
            return this.vOut.getIdentity() + "->" + this.vIn.getIdentity();
        }
        if (this.graph != null) {
            this.graph.setCurrentGraphInThreadLocal();
        }
        return super.getId();
    }

    @Override
    public <T> T getProperty(String key) {
        this.graph.setCurrentGraphInThreadLocal();
        if (this.rawElement == null) {
            return null;
        }
        return super.getProperty(key);
    }

    public boolean isLightweight() {
        return this.rawElement == null;
    }

    public Set<String> getPropertyKeys() {
        if (this.rawElement == null) {
            return Collections.emptySet();
        }
        this.graph.setCurrentGraphInThreadLocal();
        HashSet<String> result = new HashSet<String>();
        for (String field : this.getRecord().fieldNames()) {
            if (field.equals("out") || field.equals("in") || !this.settings.useClassForEdgeLabel && field.equals("label")) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.graph.setCurrentGraphInThreadLocal();
        if (this.rawElement == null) {
            this.convertToDocument();
        }
        super.setProperty(key, value);
    }

    @Override
    public <T> T removeProperty(String key) {
        this.graph.setCurrentGraphInThreadLocal();
        if (this.rawElement != null) {
            return super.removeProperty(key);
        }
        return null;
    }

    @Override
    public void remove() {
        this.checkClass();
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        for (Index<? extends Element> index : this.graph.getIndices()) {
            if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
            OrientIndex idx = (OrientIndex)index;
            idx.removeElement(this);
        }
        OIdentifiable inVertexEdge = this.vIn != null ? this.vIn : this.rawElement;
        ODocument outVertex = (ODocument)this.getOutVertex().getRecord();
        String edgeClassName = OrientBaseGraph.encodeClassName(this.getLabel());
        boolean useVertexFieldsForEdgeLabels = this.settings.useVertexFieldsForEdgeLabels;
        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, edgeClassName, useVertexFieldsForEdgeLabels);
        this.dropEdgeFromVertex(inVertexEdge, outVertex, outFieldName, outVertex.field(outFieldName));
        OIdentifiable outVertexEdge = this.vOut != null ? this.vOut : this.rawElement;
        ODocument inVertex = (ODocument)this.getInVertex().getRecord();
        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, edgeClassName, useVertexFieldsForEdgeLabels);
        this.dropEdgeFromVertex(outVertexEdge, inVertex, inFieldName, inVertex.field(inFieldName));
        outVertex.save();
        inVertex.save();
        if (this.rawElement != null) {
            super.remove();
        }
    }

    @Override
    public final String getBaseClassName() {
        return "E";
    }

    @Override
    public String getElementType() {
        return "Edge";
    }

    public String toString() {
        if (this.graph != null) {
            this.graph.setCurrentGraphInThreadLocal();
        }
        if (this.getLabel() == null) {
            return "e[" + this.getId() + "]" + "[" + this.getVertex(Direction.OUT).getId() + "->" + this.getVertex(Direction.IN).getId() + "]";
        }
        return StringFactory.edgeString((Edge)this);
    }

    @Override
    public ODocument getRecord() {
        if (this.rawElement == null) {
            ODocument tmp = new ODocument(this.getClassName(this.label)).setTrackingChanges(false);
            tmp.field("in", (Object)this.vIn);
            tmp.field("out", (Object)this.vOut);
            if (this.label != null && this.settings != null && !this.settings.useClassForEdgeLabel) {
                tmp.field("label", (Object)this.label);
            }
            return tmp;
        }
        return super.getRecord();
    }

    public void convertToDocument() {
        if (this.rawElement != null) {
            return;
        }
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        ODocument vOutRecord = (ODocument)this.vOut.getRecord();
        ODocument vInRecord = (ODocument)this.vIn.getRecord();
        ODocument doc = this.createDocument(this.label);
        doc.field("out", this.settings.keepInMemoryReferences ? vOutRecord.getIdentity() : vOutRecord);
        doc.field("in", this.settings.keepInMemoryReferences ? vInRecord.getIdentity() : vInRecord);
        this.rawElement = doc;
        boolean useVertexFieldsForEdgeLabels = this.settings.useVertexFieldsForEdgeLabels;
        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, this.label, useVertexFieldsForEdgeLabels);
        OrientEdge.removeLightweightConnection(vOutRecord, outFieldName, (OIdentifiable)vInRecord);
        OrientVertex.createLink(vOutRecord, (OIdentifiable)doc, outFieldName);
        vOutRecord.save();
        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, this.label, useVertexFieldsForEdgeLabels);
        OrientEdge.removeLightweightConnection(vInRecord, inFieldName, (OIdentifiable)vOutRecord);
        OrientVertex.createLink(vInRecord, (OIdentifiable)doc, inFieldName);
        vInRecord.save();
        this.vOut = null;
        this.vIn = null;
        this.label = null;
    }

    public String getClassName(String iLabel) {
        if (iLabel != null && (this.settings == null || this.settings.useClassForEdgeLabel)) {
            return this.checkForClassInSchema(iLabel);
        }
        return "E";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.vOut != null ? this.vOut.getIdentity() : null);
        out.writeObject(this.vIn != null ? this.vIn.getIdentity() : null);
        out.writeUTF(this.label != null ? this.label : "");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.vOut = (OIdentifiable)in.readObject();
        this.vIn = (OIdentifiable)in.readObject();
        this.label = in.readUTF();
        if (this.label.isEmpty()) {
            this.label = null;
        }
    }

    protected boolean isLabeled(String[] iLabels) {
        return OrientEdge.isLabeled(this.getLabel(), iLabels);
    }

    protected ODocument createDocument(String iLabel) {
        String className = this.getClassName(iLabel);
        ODocument doc = new ODocument(className);
        if (iLabel != null && !this.settings.useClassForEdgeLabel) {
            doc.field("label", (Object)iLabel);
        }
        return doc;
    }

    protected void dropEdgeFromVertex(OIdentifiable iEdge, ODocument iVertex, String iFieldName, Object iFieldValue) {
        if (iFieldValue == null) {
            OLogManager.instance().debug((Object)this, "Edge not found in vertex's property %s.%s while removing the edge %s", new Object[]{iVertex.getIdentity(), iFieldName, iEdge.getIdentity()});
        } else if (iFieldValue instanceof OIdentifiable) {
            if (iFieldValue.equals(iEdge)) {
                iVertex.removeField(iFieldName);
            } else {
                OLogManager.instance().warn((Object)this, "Edge not found in vertex's property %s.%s link while removing the edge %s", new Object[]{iVertex.getIdentity(), iFieldName, iEdge.getIdentity()});
            }
        } else if (iFieldValue instanceof ORidBag) {
            ORidBag bag = (ORidBag)iFieldValue;
            bag.remove(iEdge);
        } else if (iFieldValue instanceof Collection) {
            Collection coll = (Collection)iFieldValue;
            if (!coll.remove(iEdge)) {
                OLogManager.instance().warn((Object)this, "Edge not found in vertex's property %s.%s set while removing the edge %s", new Object[]{iVertex.getIdentity(), iFieldName, iEdge.getIdentity()});
            }
            if (coll.size() == 1) {
                iVertex.field(iFieldName, coll.iterator().next());
            } else if (coll.size() == 0) {
                iVertex.removeField(iFieldName);
            }
        } else {
            throw new IllegalStateException("Wrong type found in the field '" + iFieldName + "': " + iFieldValue.getClass());
        }
    }
}

