/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.iterator.OLazyWrapperIterator;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;

public class OrientEdgeIterator
extends OLazyWrapperIterator<OrientEdge> {
    private final OrientVertex sourceVertex;
    private final OrientVertex targetVertex;
    private final OPair<Direction, String> connection;
    private final String[] labels;

    public OrientEdgeIterator(OrientVertex iSourceVertex, OrientVertex iTargetVertex, Iterator<?> iterator, OPair<Direction, String> connection, String[] iLabels, int iSize) {
        super(iterator, iSize);
        this.sourceVertex = iSourceVertex;
        this.targetVertex = iTargetVertex;
        this.connection = connection;
        this.labels = iLabels;
    }

    public OrientEdge createWrapper(Object iObject) {
        OrientEdge edge;
        if (iObject instanceof OrientEdge) {
            return (OrientEdge)iObject;
        }
        OIdentifiable rec = (OIdentifiable)iObject;
        ORecord record = rec.getRecord();
        if (record == null) {
            OLogManager.instance().warn((Object)this, "Record (%s) is null", new Object[]{rec});
            return null;
        }
        if (!(record instanceof ODocument)) {
            OLogManager.instance().warn((Object)this, "Found a record (%s) that is not an edge. Record: %s", new Object[]{rec, record});
            return null;
        }
        ODocument value = (ODocument)rec.getRecord();
        if (value == null || value.getSchemaClass() == null) {
            return null;
        }
        if (value.getSchemaClass().isSubClassOf("V")) {
            edge = this.connection.getKey() == Direction.OUT ? new OrientEdge(this.sourceVertex.graph, (OIdentifiable)this.sourceVertex.getIdentity(), (OIdentifiable)rec.getIdentity(), (String)this.connection.getValue()) : new OrientEdge(this.sourceVertex.graph, (OIdentifiable)rec.getIdentity(), (OIdentifiable)this.sourceVertex.getIdentity(), (String)this.connection.getValue());
        } else if (value.getSchemaClass().isSubClassOf("E")) {
            edge = new OrientEdge(this.sourceVertex.graph, (OIdentifiable)rec.getIdentity());
        } else {
            throw new IllegalStateException("Invalid content found between connections:" + value);
        }
        if (this.sourceVertex.settings.useVertexFieldsForEdgeLabels || edge.isLabeled(this.labels)) {
            return edge;
        }
        return null;
    }

    public boolean filter(OrientEdge iObject) {
        if (this.targetVertex != null && !this.targetVertex.equals(iObject.getVertex(((Direction)this.connection.getKey()).opposite()))) {
            return false;
        }
        return this.sourceVertex.settings.useVertexFieldsForEdgeLabels || iObject.isLabeled(this.labels);
    }
}

