/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.storage.OStorage;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

public abstract class OrientElement
implements Element,
OSerializableStream,
Externalizable,
OIdentifiable {
    public static final String LABEL_FIELD_NAME = "label";
    public static final Object DEF_ORIGINAL_ID_FIELDNAME = "origId";
    private static final long serialVersionUID = 1L;
    protected transient OrientBaseGraph graph;
    protected transient OrientBaseGraph.Settings settings;
    protected OIdentifiable rawElement;

    protected OrientElement(OrientBaseGraph rawGraph, OIdentifiable iRawElement) {
        this.graph = rawGraph;
        this.rawElement = iRawElement;
        if (this.graph != null) {
            this.settings = this.graph.settings;
        }
    }

    public abstract String getBaseClassName();

    public abstract String getElementType();

    public void remove() {
        this.checkIfAttached();
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        ORecordOperation oper = this.graph.getRawGraph().getTransaction().getRecordEntry(this.getIdentity());
        if (oper != null && oper.type == 2) {
            throw new IllegalStateException("The elements " + this.getIdentity() + " has already been deleted");
        }
        try {
            this.getRecord().load();
        }
        catch (ORecordNotFoundException e) {
            throw new IllegalStateException("The elements " + this.getIdentity() + " has already been deleted");
        }
        this.getRecord().delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends OrientElement> T setProperties(Object ... fields) {
        if (fields == null || fields.length <= 0 || fields[0] == null) return (T)this;
        if (!this.isDetached()) {
            this.graph.autoStartTransaction();
        }
        if (fields.length == 1) {
            Object f = fields[0];
            if (!(f instanceof Map)) throw new IllegalArgumentException("Invalid fields: expecting a pairs of fields as String,Object or a single Map<String,Object>, but found: " + f);
            for (Map.Entry entry : ((Map)f).entrySet()) {
                this.setPropertyInternal(this, (ODocument)this.rawElement.getRecord(), entry.getKey().toString(), entry.getValue());
            }
            return (T)this;
        } else {
            for (int i = 0; i < fields.length; i += 2) {
                this.setPropertyInternal(this, (ODocument)this.rawElement.getRecord(), fields[i].toString(), fields[i + 1]);
            }
        }
        return (T)this;
    }

    public void setProperty(String key, Object value) {
        this.validateProperty(this, key, value);
        if (!this.isDetached()) {
            this.graph.autoStartTransaction();
        }
        this.getRecord().field(key, value);
        if (!this.isDetached()) {
            this.save();
        }
    }

    public <T> T removeProperty(String key) {
        if (!this.isDetached()) {
            this.graph.autoStartTransaction();
        }
        Object oldValue = this.getRecord().removeField(key);
        if (!this.isDetached()) {
            this.save();
        }
        return (T)oldValue;
    }

    public <T> T getProperty(String key) {
        if (key == null) {
            return null;
        }
        if (key.equals("_class")) {
            return (T)this.getRecord().getSchemaClass().getName();
        }
        if (key.equals("_version")) {
            return (T)new Integer(this.getRecord().getVersion());
        }
        if (key.equals("_rid")) {
            return (T)this.rawElement.getIdentity().toString();
        }
        Object fieldValue = this.getRecord().field(key);
        if (fieldValue instanceof OIdentifiable && !(((OIdentifiable)fieldValue).getRecord() instanceof ORecordBytes)) {
            return (T)this.graph.getElement(fieldValue);
        }
        if (OMultiValue.isMultiValue((Object)fieldValue) && OMultiValue.getFirstValue((Object)fieldValue) instanceof OIdentifiable) {
            ODocument document;
            OIdentifiable firstValue = (OIdentifiable)OMultiValue.getFirstValue((Object)fieldValue);
            if (firstValue instanceof ODocument && (document = (ODocument)firstValue).isEmbedded()) {
                return (T)fieldValue;
            }
            return (T)new OrientElementIterable(this.graph, OMultiValue.getMultiValueIterable((Object)fieldValue));
        }
        return (T)fieldValue;
    }

    public Object getId() {
        return this.getIdentity();
    }

    public void save() {
        this.save(null);
    }

    public void save(String iClusterName) {
        this.checkIfAttached();
        this.graph.setCurrentGraphInThreadLocal();
        if (this.rawElement instanceof ODocument) {
            if (iClusterName != null) {
                ((ODocument)this.rawElement).save(iClusterName);
            } else {
                ((ODocument)this.rawElement).save();
            }
        }
    }

    public int hashCode() {
        return this.rawElement == null ? 0 : this.rawElement.hashCode();
    }

    public byte[] toStream() throws OSerializationException {
        return this.rawElement.getIdentity().toString().getBytes();
    }

    public OSerializableStream fromStream(byte[] stream) throws OSerializationException {
        ODocument record = this.getRecord();
        ((ORecordId)record.getIdentity()).fromString(new String(stream));
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rawElement != null ? this.rawElement.getIdentity() : null);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rawElement = (OIdentifiable)in.readObject();
    }

    public void lock(boolean iExclusive) {
        ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().lockRecord((OIdentifiable)this, iExclusive ? OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK : OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK);
    }

    public void unlock() {
        ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().unlockRecord((OIdentifiable)this);
    }

    public ORID getIdentity() {
        if (this.rawElement == null) {
            return ORecordId.EMPTY_RECORD_ID;
        }
        ORID rid = this.rawElement.getIdentity();
        if (!rid.isValid() && !this.isDetached()) {
            this.graph.setCurrentGraphInThreadLocal();
            this.graph.autoStartTransaction();
            this.save();
        }
        return rid;
    }

    public ODocument getRecord() {
        if (this.rawElement instanceof ODocument) {
            return (ODocument)this.rawElement;
        }
        ODocument doc = (ODocument)this.rawElement.getRecord();
        if (doc == null) {
            return null;
        }
        this.rawElement = doc;
        return doc;
    }

    public OrientElement detach() {
        this.getRecord().setLazyLoad(false);
        this.getRecord().fieldNames();
        this.settings = this.graph.settings.copy();
        this.graph = null;
        return this;
    }

    public OrientElement attach(OrientBaseGraph iNewGraph) {
        if (iNewGraph == null) {
            throw new IllegalArgumentException("Graph is null");
        }
        this.graph = iNewGraph;
        this.settings = this.graph.settings;
        return this;
    }

    public boolean isDetached() {
        return this.graph == null;
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((Element)this, (Object)object);
    }

    public int compare(OIdentifiable iFirst, OIdentifiable iSecond) {
        if (iFirst == null || iSecond == null) {
            return -1;
        }
        return iFirst.compareTo((Object)iSecond);
    }

    public int compareTo(OIdentifiable iOther) {
        if (iOther == null) {
            return 1;
        }
        ORID myRID = this.getIdentity();
        ORID otherRID = iOther.getIdentity();
        if (myRID == null && otherRID == null) {
            return 0;
        }
        return myRID.compareTo((Object)otherRID);
    }

    public OrientBaseGraph getGraph() {
        return this.graph;
    }

    public final void validateProperty(Element element, String key, Object value) throws IllegalArgumentException {
        if (this.settings.standardElementConstraints && null == value) {
            throw ExceptionFactory.propertyValueCanNotBeNull();
        }
        if (null == key) {
            throw ExceptionFactory.propertyKeyCanNotBeNull();
        }
        if (this.settings.standardElementConstraints && key.equals("id")) {
            throw ExceptionFactory.propertyKeyIdIsReserved();
        }
        if (element instanceof Edge && key.equals(LABEL_FIELD_NAME)) {
            throw ExceptionFactory.propertyKeyLabelIsReservedForEdges();
        }
        if (key.isEmpty()) {
            throw ExceptionFactory.propertyKeyCanNotBeEmpty();
        }
    }

    protected void checkClass() {
        ODocument doc = this.getRecord();
        doc.deserializeFields(new String[0]);
        OClass cls = doc.getSchemaClass();
        if (cls == null || !cls.isSubClassOf(this.getBaseClassName())) {
            throw new IllegalArgumentException("The document received is not a " + this.getElementType() + ". Found class '" + cls + "'");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String checkForClassInSchema(final String className) {
        if (className == null) {
            return null;
        }
        if (this.isDetached()) {
            return className;
        }
        final OSchema schema = this.graph.getRawGraph().getMetadata().getSchema();
        if (!schema.existsClass(className)) {
            try {
                this.graph.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

                    public OClass call(OrientBaseGraph g) {
                        return schema.createClass(className, schema.getClass(OrientElement.this.getBaseClassName()));
                    }
                }, "Committing the active transaction to create the new type '", className, "' as subclass of '", this.getBaseClassName(), "'. The transaction will be reopen right after that. To avoid this behavior create the classes outside the transaction");
                return className;
            }
            catch (OSchemaException e) {
                if (schema.existsClass(className)) return className;
                throw e;
            }
        } else {
            OClass cls = schema.getClass(className);
            if (cls.isSubClassOf(this.getBaseClassName())) return className;
            throw new IllegalArgumentException("Class '" + className + "' is not an instance of " + this.getBaseClassName());
        }
    }

    protected void setPropertyInternal(Element element, ODocument doc, String key, Object value) {
        this.validateProperty(element, key, value);
        doc.field(key, value);
    }

    protected void setCurrentGraphInThreadLocal() {
        if (!this.isDetached()) {
            this.graph.setCurrentGraphInThreadLocal();
        }
    }

    protected void checkIfAttached() {
        if (this.graph == null) {
            throw new IllegalStateException("Graph element has been detached. Attach it before");
        }
    }
}

