/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;

public class OrientGraphFactory
implements ODatabaseLifecycleListener {
    protected final String url;
    protected final String user;
    protected final String password;
    protected volatile ODatabaseDocumentPool pool;
    protected volatile boolean transactional = true;

    public OrientGraphFactory(String iURL) {
        this(iURL, "admin", "admin");
    }

    public OrientGraphFactory(String iURL, String iUser, String iPassword) {
        this.url = iURL;
        this.user = iUser;
        this.password = iPassword;
        Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
    }

    public void close() {
        if (this.pool != null) {
            this.pool.close();
            this.pool = null;
        }
        Orient.instance().removeDbLifecycleListener((ODatabaseLifecycleListener)this);
    }

    public void drop() {
        this.getDatabase(false).drop();
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.FIRST;
    }

    public OrientBaseGraph get() {
        return this.transactional ? this.getTx() : this.getNoTx();
    }

    public OrientGraph getTx() {
        if (this.pool == null) {
            return new OrientGraph(this.getDatabase());
        }
        return new OrientGraph(this.pool);
    }

    public OrientGraphNoTx getNoTx() {
        if (this.pool == null) {
            return new OrientGraphNoTx(this.getDatabase(), this.user, this.password);
        }
        return new OrientGraphNoTx(this.pool);
    }

    public ODatabaseDocumentTx getDatabase() {
        return this.getDatabase(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ODatabaseDocumentTx getDatabase(boolean iCreate) {
        if (this.pool != null) {
            return (ODatabaseDocumentTx)this.pool.acquire();
        }
        ODatabaseDocumentTx db = new ODatabaseDocumentTx(this.url);
        if (!db.getURL().startsWith("remote:") && !db.exists()) {
            if (!iCreate) throw new ODatabaseException("Database '" + this.url + "' not found");
            db.create();
            return db;
        } else {
            db.open(this.user, this.password);
        }
        return db;
    }

    public boolean exists() {
        ODatabaseDocumentTx db = this.getDatabase();
        try {
            boolean bl = db.exists();
            return bl;
        }
        finally {
            db.close();
        }
    }

    public OrientGraphFactory setupPool(int iMin, int iMax) {
        ODatabaseDocumentTx db = this.getDatabase();
        db.close();
        if (this.pool != null) {
            this.pool.close();
        }
        this.pool = new ODatabaseDocumentPool(this.url, this.user, this.password);
        this.pool.setup(iMin, iMax);
        return this;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public OrientGraphFactory setTransactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public int getAvailableInstancesInPool() {
        if (this.pool != null) {
            return this.pool.getAvailableConnections(this.url, this.user);
        }
        return 0;
    }

    public void onCreate(ODatabase iDatabase) {
        ODatabaseComplex db;
        if (iDatabase instanceof ODatabaseRecord && (db = ((ODatabaseRecord)iDatabase).getDatabaseOwner()) instanceof ODatabaseDocumentTx) {
            OrientBaseGraph.checkForGraphSchema((ODatabaseDocumentTx)db);
        }
    }

    public void onOpen(ODatabase iDatabase) {
        ODatabaseComplex db;
        if (iDatabase instanceof ODatabaseRecord && (db = ((ODatabaseRecord)iDatabase).getDatabaseOwner()) instanceof ODatabaseDocumentTx) {
            OrientBaseGraph.checkForGraphSchema((ODatabaseDocumentTx)db);
        }
    }

    public void onClose(ODatabase iDatabase) {
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

