/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphContext;
import org.apache.commons.configuration.Configuration;

public abstract class OrientTransactionalGraph
extends OrientBaseGraph
implements TransactionalGraph {
    protected boolean autoStartTx = true;

    protected OrientTransactionalGraph(ODatabaseDocumentTx iDatabase) {
        this(iDatabase, true);
    }

    protected OrientTransactionalGraph(ODatabaseDocumentTx iDatabase, boolean iAutoStartTx) {
        super(iDatabase, null, null);
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(iAutoStartTx);
        if (iAutoStartTx) {
            this.getContext((boolean)false).rawGraph.begin();
        }
    }

    protected OrientTransactionalGraph(ODatabaseDocumentPool pool) {
        super(pool);
        this.setCurrentGraphInThreadLocal();
        this.getContext((boolean)false).rawGraph.begin();
    }

    protected OrientTransactionalGraph(String url) {
        this(url, true);
    }

    protected OrientTransactionalGraph(String url, boolean iAutoStartTx) {
        super(url, "admin", "admin");
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(iAutoStartTx);
        if (iAutoStartTx) {
            this.getContext((boolean)false).rawGraph.begin();
        }
    }

    protected OrientTransactionalGraph(String url, String username, String password) {
        this(url, username, password, true);
    }

    protected OrientTransactionalGraph(String url, String username, String password, boolean iAutoStartTx) {
        super(url, username, password);
        this.setCurrentGraphInThreadLocal();
        this.setAutoStartTx(iAutoStartTx);
        if (iAutoStartTx) {
            this.getContext((boolean)false).rawGraph.begin();
        }
    }

    protected OrientTransactionalGraph(Configuration configuration) {
        super(configuration);
        Boolean autoStartTx = configuration.getBoolean("blueprints.orientdb.autoStartTx", null);
        if (autoStartTx != null) {
            this.setAutoStartTx(autoStartTx);
        }
    }

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        OrientGraphContext context = this.getContext(false);
        if (context == null) {
            return;
        }
        if (context.rawGraph.isClosed() || context.rawGraph.getTransaction() instanceof OTransactionNoTx || context.rawGraph.getTransaction().getStatus() != OTransaction.TXSTATUS.BEGUN) {
            return;
        }
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    @Override
    public void commit() {
        OrientGraphContext context = this.getContext(false);
        if (context == null) {
            return;
        }
        context.rawGraph.commit();
        if (this.autoStartTx) {
            this.getContext((boolean)false).rawGraph.begin();
        }
    }

    @Override
    public void rollback() {
        OrientGraphContext context = this.getContext(false);
        if (context == null) {
            return;
        }
        context.rawGraph.rollback();
        if (this.autoStartTx) {
            this.getContext((boolean)false).rawGraph.begin();
        }
    }

    public boolean isAutoStartTx() {
        return this.autoStartTx;
    }

    public void setAutoStartTx(boolean autoStartTx) {
        this.autoStartTx = autoStartTx;
    }

    @Override
    protected void autoStartTransaction() {
        if (!this.autoStartTx) {
            return;
        }
        OrientGraphContext context = this.getContext(true);
        if (context.rawGraph.getTransaction() instanceof OTransactionNoTx && context.rawGraph.getTransaction().getStatus() != OTransaction.TXSTATUS.BEGUN) {
            context.rawGraph.begin();
        }
    }
}

