/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeIterator;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexIterator;
import com.tinkerpop.blueprints.impls.orient.OrientVertexQuery;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionVertex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrientVertex
extends OrientElement
implements Vertex {
    public static final String CONNECTION_OUT_PREFIX = "out_";
    public static final String CONNECTION_IN_PREFIX = "in_";
    private static final long serialVersionUID = 1L;

    public OrientVertex() {
        super(null, null);
    }

    protected OrientVertex(OrientBaseGraph graph, String className, Object ... fields) {
        super(graph, null);
        if (className != null) {
            className = this.checkForClassInSchema(OrientBaseGraph.encodeClassName(className));
        }
        this.rawElement = new ODocument(className == null ? "V" : className);
        this.setProperties(fields);
    }

    protected OrientVertex(OrientBaseGraph graph, OIdentifiable record) {
        super(graph, record);
    }

    public static String getConnectionFieldName(Direction iDirection, String iClassName, boolean useVertexFieldsForEdgeLabels) {
        if (iDirection == null || iDirection == Direction.BOTH) {
            throw new IllegalArgumentException("Direction not valid");
        }
        if (useVertexFieldsForEdgeLabels) {
            String prefix;
            String string = prefix = iDirection == Direction.OUT ? CONNECTION_OUT_PREFIX : CONNECTION_IN_PREFIX;
            if (iClassName == null || iClassName.isEmpty() || iClassName.equals("E")) {
                return prefix;
            }
            return prefix + iClassName;
        }
        return iDirection == Direction.OUT ? "out" : "in";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object createLink(ODocument iFromVertex, OIdentifiable iTo, String iFieldName) {
        OIdentifiable out;
        Object found = iFromVertex.field(iFieldName);
        OClass linkClass = iFromVertex.getSchemaClass();
        if (linkClass == null) {
            throw new IllegalArgumentException("Class ot found in source vertex: " + iFromVertex);
        }
        OProperty prop = linkClass.getProperty(iFieldName);
        if (found == null) {
            if (prop == null || prop.getType().equals((Object)OType.LINK) || "true".equalsIgnoreCase(prop.getCustom("ordered"))) {
                out = iTo;
            } else if (prop.getType().equals((Object)OType.LINKBAG)) {
                ORidBag bag = new ORidBag();
                bag.add(iTo);
                out = bag;
            } else {
                if (!prop.getType().equals((Object)OType.LINKLIST)) throw new IllegalStateException("Type of field provided in schema '" + prop.getType() + " can not be used for link creation.");
                OTrackedList coll = new OTrackedList((ORecord)iFromVertex);
                coll.add(iTo);
                out = coll;
            }
        } else if (found instanceof OIdentifiable) {
            if (prop != null && prop.getType().equals((Object)OType.LINK)) {
                throw new IllegalStateException("Type of field provided in schema '" + prop.getType() + " can not be used for creation to hold several links.");
            }
            if (prop != null && "true".equalsIgnoreCase(prop.getCustom("ordered"))) {
                OTrackedList coll = new OTrackedList((ORecord)iFromVertex);
                coll.add(found);
                coll.add(iTo);
                out = coll;
            } else {
                ORidBag bag = new ORidBag();
                bag.add((OIdentifiable)found);
                bag.add(iTo);
                out = bag;
            }
        } else if (found instanceof ORidBag) {
            out = null;
            ((ORidBag)found).add(iTo);
        } else {
            if (!(found instanceof Collection)) throw new IllegalStateException("Relationship content is invalid on field " + iFieldName + ". Found: " + found);
            out = null;
            ((Collection)found).add(iTo);
        }
        if (out == null) return out;
        iFromVertex.field(iFieldName, (Object)out);
        return out;
    }

    public static Direction getConnectionDirection(String iConnectionField, boolean useVertexFieldsForEdgeLabels) {
        if (iConnectionField == null) {
            throw new IllegalArgumentException("Cannot return direction of NULL connection ");
        }
        if (useVertexFieldsForEdgeLabels) {
            if (iConnectionField.startsWith(CONNECTION_OUT_PREFIX)) {
                return Direction.OUT;
            }
            if (iConnectionField.startsWith(CONNECTION_IN_PREFIX)) {
                return Direction.IN;
            }
        } else {
            if (iConnectionField.equals("out")) {
                return Direction.OUT;
            }
            if (iConnectionField.startsWith("in")) {
                return Direction.IN;
            }
        }
        throw new IllegalArgumentException("Cannot return direction of connection " + iConnectionField);
    }

    public static String getInverseConnectionFieldName(String iFieldName, boolean useVertexFieldsForEdgeLabels) {
        if (useVertexFieldsForEdgeLabels) {
            if (iFieldName.startsWith(CONNECTION_OUT_PREFIX)) {
                if (iFieldName.length() == CONNECTION_OUT_PREFIX.length()) {
                    return CONNECTION_IN_PREFIX;
                }
                return CONNECTION_IN_PREFIX + iFieldName.substring(CONNECTION_OUT_PREFIX.length());
            }
            if (iFieldName.startsWith(CONNECTION_IN_PREFIX)) {
                if (iFieldName.length() == CONNECTION_IN_PREFIX.length()) {
                    return CONNECTION_OUT_PREFIX;
                }
                return CONNECTION_OUT_PREFIX + iFieldName.substring(CONNECTION_IN_PREFIX.length());
            }
            throw new IllegalArgumentException("Cannot find reverse connection name for field " + iFieldName);
        }
        if (iFieldName.equals("out")) {
            return "in";
        }
        if (iFieldName.equals("in")) {
            return "out";
        }
        throw new IllegalArgumentException("Cannot find reverse connection name for field " + iFieldName);
    }

    public static void removeEdges(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, boolean iAlsoInverse, boolean useVertexFieldsForEdgeLabels) {
        Object fieldValue;
        if (iVertex == null) {
            return;
        }
        Object object = fieldValue = iVertexToRemove != null ? iVertex.field(iFieldName) : iVertex.removeField(iFieldName);
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof OIdentifiable) {
            if (iVertexToRemove != null) {
                if (!fieldValue.equals(iVertexToRemove)) {
                    return;
                }
                iVertex.removeField(iFieldName);
            }
            if (iAlsoInverse) {
                OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, fieldValue, useVertexFieldsForEdgeLabels);
            }
            OrientVertex.deleteEdgeIfAny((OIdentifiable)fieldValue);
        } else if (fieldValue instanceof ORidBag) {
            ORidBag bag = (ORidBag)fieldValue;
            if (iVertexToRemove != null) {
                boolean found = false;
                Iterator it = bag.rawIterator();
                while (it.hasNext()) {
                    Direction direction;
                    ODocument curr = (ODocument)((OIdentifiable)it.next()).getRecord();
                    if (iVertexToRemove.equals(curr)) {
                        it.remove();
                        if (iAlsoInverse) {
                            OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels);
                        }
                        found = true;
                        break;
                    }
                    if (!curr.getSchemaClass().isSubClassOf("E") || !iVertexToRemove.equals(OrientEdge.getConnection(curr, (direction = OrientVertex.getConnectionDirection(iFieldName, useVertexFieldsForEdgeLabels)).opposite()))) continue;
                    it.remove();
                    if (iAlsoInverse) {
                        OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    OLogManager.instance().warn(null, "[OrientVertex.removeEdges] edge %s not found in field %s", new Object[]{iVertexToRemove, iFieldName});
                }
                OrientVertex.deleteEdgeIfAny(iVertexToRemove);
            } else {
                Iterator it = bag.rawIterator();
                while (it.hasNext()) {
                    OIdentifiable edge = (OIdentifiable)it.next();
                    if (iAlsoInverse) {
                        OrientVertex.removeInverseEdge(iVertex, iFieldName, null, edge, useVertexFieldsForEdgeLabels);
                    }
                    OrientVertex.deleteEdgeIfAny(edge);
                }
            }
            if (bag.isEmpty()) {
                iVertex.removeField(iFieldName);
            }
        } else if (fieldValue instanceof Collection) {
            Collection col = (Collection)fieldValue;
            if (iVertexToRemove != null) {
                boolean found = false;
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    Direction direction;
                    ODocument curr = (ODocument)((OIdentifiable)it.next()).getRecord();
                    if (iVertexToRemove.equals(curr)) {
                        it.remove();
                        if (iAlsoInverse) {
                            OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels);
                        }
                        found = true;
                        break;
                    }
                    if (!curr.getSchemaClass().isSubClassOf("E") || !iVertexToRemove.equals(OrientEdge.getConnection(curr, (direction = OrientVertex.getConnectionDirection(iFieldName, useVertexFieldsForEdgeLabels)).opposite()))) continue;
                    it.remove();
                    if (iAlsoInverse) {
                        OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    OLogManager.instance().warn(null, "[OrientVertex.removeEdges] edge %s not found in field %s", new Object[]{iVertexToRemove, iFieldName});
                }
                OrientVertex.deleteEdgeIfAny(iVertexToRemove);
            } else {
                for (OIdentifiable edge : col) {
                    if (iAlsoInverse) {
                        OrientVertex.removeInverseEdge(iVertex, iFieldName, null, edge, useVertexFieldsForEdgeLabels);
                    }
                    OrientVertex.deleteEdgeIfAny(edge);
                }
            }
            if (col.isEmpty()) {
                iVertex.removeField(iFieldName);
            }
        }
        iVertex.save();
    }

    private static void deleteEdgeIfAny(OIdentifiable iRecord) {
        ODocument doc;
        if (iRecord != null && (doc = (ODocument)iRecord.getRecord()) != null && doc.getSchemaClass() != null && doc.getSchemaClass().isSubClassOf("E")) {
            doc.delete();
        }
    }

    private static void removeInverseEdge(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, Object iFieldValue, boolean useVertexFieldsForEdgeLabels) {
        ODocument r = (ODocument)((OIdentifiable)iFieldValue).getRecord();
        if (r == null) {
            return;
        }
        String inverseFieldName = OrientVertex.getInverseConnectionFieldName(iFieldName, useVertexFieldsForEdgeLabels);
        if (r.getSchemaClass().isSubClassOf("V")) {
            OrientVertex.removeEdges(r, inverseFieldName, (OIdentifiable)iVertex, false, useVertexFieldsForEdgeLabels);
        } else if (r.getSchemaClass().isSubClassOf("E")) {
            OIdentifiable otherVertex = OrientEdge.getConnection(r, OrientVertex.getConnectionDirection(inverseFieldName, useVertexFieldsForEdgeLabels));
            if (otherVertex != null) {
                if (iVertexToRemove == null || otherVertex.equals(iVertexToRemove)) {
                    OrientVertex.removeEdges((ODocument)otherVertex.getRecord(), inverseFieldName, (OIdentifiable)iFieldValue, false, useVertexFieldsForEdgeLabels);
                }
            } else {
                throw new IllegalStateException("Invalid content found in " + iFieldName + " field");
            }
        }
    }

    protected static OrientEdge getEdge(OrientBaseGraph graph, ODocument doc, String fieldName, OPair<Direction, String> connection, Object fieldValue, OIdentifiable iTargetVertex, String[] iLabels) {
        OrientEdge toAdd;
        ODocument fieldRecord = (ODocument)((OIdentifiable)fieldValue).getRecord();
        if (fieldRecord == null) {
            return null;
        }
        if (fieldRecord.getSchemaClass().isSubClassOf("V")) {
            if (iTargetVertex != null && !iTargetVertex.equals(fieldValue)) {
                return null;
            }
            toAdd = connection.getKey() == Direction.OUT ? new OrientEdge(graph, (OIdentifiable)doc, (OIdentifiable)fieldRecord, (String)connection.getValue()) : new OrientEdge(graph, (OIdentifiable)fieldRecord, (OIdentifiable)doc, (String)connection.getValue());
        } else if (fieldRecord.getSchemaClass().isSubClassOf("E")) {
            OIdentifiable targetVertex;
            if (iTargetVertex != null && !iTargetVertex.equals(targetVertex = OrientEdge.getConnection(fieldRecord, ((Direction)connection.getKey()).opposite()))) {
                return null;
            }
            toAdd = new OrientEdge(graph, (OIdentifiable)fieldRecord);
        } else {
            throw new IllegalStateException("Invalid content found in " + fieldName + " field: " + fieldRecord);
        }
        return toAdd;
    }

    public Object execute(OCommandPredicate iPredicate) {
        return iPredicate.evaluate(this.rawElement.getRecord(), null, null);
    }

    public Set<String> getPropertyKeys() {
        this.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        HashSet<String> result = new HashSet<String>();
        for (String field : doc.fieldNames()) {
            if (!this.isDetached() && this.settings.useVertexFieldsForEdgeLabels) {
                if (field.startsWith(CONNECTION_OUT_PREFIX) || field.startsWith(CONNECTION_IN_PREFIX)) continue;
                result.add(field);
                continue;
            }
            if (field.equals("out") || field.equals("in")) continue;
            result.add(field);
        }
        return result;
    }

    public Iterable<Vertex> getVertices(Direction iDirection, String ... iLabels) {
        this.setCurrentGraphInThreadLocal();
        OrientBaseGraph.encodeClassNames(iLabels);
        ODocument doc = this.getRecord();
        OMultiCollectionIterator iterable = new OMultiCollectionIterator();
        for (String fieldName : doc.fieldNames()) {
            Object fieldValue;
            OPair<Direction, String> connection = this.getConnection(iDirection, fieldName, iLabels);
            if (connection == null || (fieldValue = doc.field(fieldName)) == null) continue;
            if (fieldValue instanceof OIdentifiable) {
                this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, connection, fieldValue, iLabels);
                continue;
            }
            if (fieldValue instanceof Collection) {
                Collection coll = (Collection)fieldValue;
                if (coll.size() == 1) {
                    if (coll instanceof ORecordLazyMultiValue) {
                        this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, connection, ((ORecordLazyMultiValue)coll).rawIterator().next(), iLabels);
                        continue;
                    }
                    if (coll instanceof List) {
                        this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, connection, ((List)coll).get(0), iLabels);
                        continue;
                    }
                    this.addSingleVertex(doc, (OMultiCollectionIterator<Vertex>)iterable, fieldName, connection, coll.iterator().next(), iLabels);
                    continue;
                }
                if (coll instanceof ORecordLazyMultiValue) {
                    iterable.add((Object)new OrientVertexIterator(this, ((ORecordLazyMultiValue)coll).rawIterator(), connection, iLabels, ((ORecordLazyMultiValue)coll).size()));
                    continue;
                }
                iterable.add((Object)new OrientVertexIterator(this, coll.iterator(), connection, iLabels, -1));
                continue;
            }
            if (!(fieldValue instanceof ORidBag)) continue;
            iterable.add((Object)new OrientVertexIterator(this, ((ORidBag)fieldValue).rawIterator(), connection, iLabels, -1));
        }
        return iterable;
    }

    public OrientVertexQuery query() {
        this.setCurrentGraphInThreadLocal();
        return new OrientVertexQuery(this);
    }

    public OTraverse traverse() {
        this.setCurrentGraphInThreadLocal();
        return new OTraverse().target(new OIdentifiable[]{this.getRecord()});
    }

    @Override
    public void remove() {
        this.checkClass();
        this.checkIfAttached();
        this.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        ODocument doc = this.getRecord();
        if (doc == null) {
            throw ExceptionFactory.vertexWithIdDoesNotExist((Object)this.getId());
        }
        Iterator<Index<? extends Element>> it = this.graph.getIndices().iterator();
        if (it.hasNext()) {
            HashSet<Edge> allEdges = new HashSet<Edge>();
            for (Edge e : this.getEdges(Direction.BOTH, new String[0])) {
                allEdges.add(e);
            }
            while (it.hasNext()) {
                OrientIndex idx;
                Index<? extends Element> index = it.next();
                if (Vertex.class.isAssignableFrom(index.getIndexClass())) {
                    idx = (OrientIndex)index;
                    idx.removeElement(this);
                }
                if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
                idx = (OrientIndex)index;
                for (Edge e : allEdges) {
                    idx.removeElement((OrientEdge)e);
                }
            }
        }
        for (String fieldName : doc.fieldNames()) {
            OPair<Direction, String> connection = this.getConnection(Direction.BOTH, fieldName, new String[0]);
            if (connection == null) continue;
            OrientVertex.removeEdges(doc, fieldName, null, true, this.settings.useVertexFieldsForEdgeLabels);
        }
        super.remove();
    }

    public Edge addEdge(String label, Vertex inVertex) {
        if (inVertex instanceof PartitionVertex) {
            inVertex = ((PartitionVertex)inVertex).getBaseVertex();
        }
        return this.addEdge(label, (OrientVertex)inVertex, null, null, null);
    }

    public OrientEdge addEdge(String label, OrientVertex inVertex, String iClassName) {
        return this.addEdge(label, inVertex, iClassName, null, null);
    }

    public OrientEdge addEdge(String label, OrientVertex inVertex, Object[] fields) {
        return this.addEdge(label, inVertex, null, null, fields);
    }

    public OrientEdge addEdge(String label, OrientVertex inVertex, String iClassName, String iClusterName, Object ... fields) {
        OrientEdge edge;
        ODocument to;
        OIdentifiable from;
        if (inVertex == null) {
            throw new IllegalArgumentException("destination vertex is null");
        }
        if (this.graph != null) {
            this.setCurrentGraphInThreadLocal();
            this.graph.autoStartTransaction();
        }
        ODocument outDocument = this.getRecord();
        ODocument inDocument = inVertex.getRecord();
        if ((label = OrientBaseGraph.encodeClassName(label)) == null && iClassName != null) {
            label = OrientBaseGraph.encodeClassName(iClassName);
        }
        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, label, this.settings.useVertexFieldsForEdgeLabels);
        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, label, this.settings.useVertexFieldsForEdgeLabels);
        if (label == null) {
            throw ExceptionFactory.edgeLabelCanNotBeNull();
        }
        if (this.canCreateDynamicEdge(outDocument, inDocument, outFieldName, inFieldName, fields, label)) {
            from = this.rawElement;
            to = inDocument;
            edge = new OrientEdge(this.graph, from, (OIdentifiable)to, label);
        } else {
            edge = new OrientEdge(this.graph, label, fields);
            if (this.settings.keepInMemoryReferences) {
                edge.getRecord().fields("out", (Object)this.rawElement.getIdentity(), new Object[]{"in", inDocument.getIdentity()});
            } else {
                edge.getRecord().fields("out", (Object)this.rawElement, new Object[]{"in", inDocument});
            }
            from = edge.getRecord();
            to = edge.getRecord();
        }
        if (this.settings.keepInMemoryReferences) {
            from = from.getIdentity();
            to = to.getIdentity();
        }
        OrientVertex.createLink(outDocument, (OIdentifiable)to, outFieldName);
        OrientVertex.createLink(inDocument, from, inFieldName);
        if (this.graph != null) {
            edge.save(iClusterName);
            inDocument.save();
            outDocument.save();
        }
        return edge;
    }

    public long countEdges(Direction iDirection, String ... iLabels) {
        this.checkIfAttached();
        long counter = 0L;
        OrientBaseGraph.encodeClassNames(iLabels);
        if (this.settings.useVertexFieldsForEdgeLabels || iLabels == null || iLabels.length == 0) {
            ODocument doc = this.getRecord();
            for (String fieldName : doc.fieldNames()) {
                Object fieldValue;
                OPair<Direction, String> connection = this.getConnection(iDirection, fieldName, iLabels);
                if (connection == null || (fieldValue = doc.field(fieldName)) == null) continue;
                if (fieldValue instanceof Collection) {
                    counter += (long)((Collection)fieldValue).size();
                    continue;
                }
                if (fieldValue instanceof Map) {
                    counter += (long)((Map)fieldValue).size();
                    continue;
                }
                if (fieldValue instanceof ORidBag) {
                    counter += (long)((ORidBag)fieldValue).size();
                    continue;
                }
                ++counter;
            }
        } else {
            for (Edge e : this.getEdges(iDirection, iLabels)) {
                if (e == null) continue;
                ++counter;
            }
        }
        return counter;
    }

    public Iterable<Edge> getEdges(Direction iDirection, String ... iLabels) {
        return this.getEdges(null, iDirection, iLabels);
    }

    public Iterable<Edge> getEdges(OrientVertex iDestination, Direction iDirection, String ... iLabels) {
        this.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        OrientBaseGraph.encodeClassNames(iLabels);
        OMultiCollectionIterator iterable = new OMultiCollectionIterator().setEmbedded(true);
        for (String fieldName : doc.fieldNames()) {
            OIdentifiable destinationVId;
            Object fieldValue;
            OPair<Direction, String> connection = this.getConnection(iDirection, fieldName, iLabels);
            if (connection == null || (fieldValue = doc.field(fieldName)) == null) continue;
            OIdentifiable oIdentifiable = destinationVId = iDestination != null ? (OIdentifiable)iDestination.getId() : null;
            if (fieldValue instanceof OIdentifiable) {
                this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, connection, fieldValue, destinationVId, iLabels);
                continue;
            }
            if (fieldValue instanceof Collection) {
                Collection coll = (Collection)fieldValue;
                if (coll.size() == 1) {
                    if (coll instanceof ORecordLazyMultiValue) {
                        this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, connection, ((ORecordLazyMultiValue)coll).rawIterator().next(), destinationVId, iLabels);
                        continue;
                    }
                    if (coll instanceof List) {
                        this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, connection, ((List)coll).get(0), destinationVId, iLabels);
                        continue;
                    }
                    this.addSingleEdge(doc, (OMultiCollectionIterator<Edge>)iterable, fieldName, connection, coll.iterator().next(), destinationVId, iLabels);
                    continue;
                }
                if (coll instanceof ORecordLazyMultiValue) {
                    iterable.add((Object)new OrientEdgeIterator(this, iDestination, ((ORecordLazyMultiValue)coll).rawIterator(), connection, iLabels, ((ORecordLazyMultiValue)coll).size()));
                    continue;
                }
                iterable.add((Object)new OrientEdgeIterator(this, iDestination, coll.iterator(), connection, iLabels, -1));
                continue;
            }
            if (!(fieldValue instanceof ORidBag)) continue;
            iterable.add((Object)new OrientEdgeIterator(this, iDestination, ((ORidBag)fieldValue).rawIterator(), connection, iLabels, ((ORidBag)fieldValue).size()));
        }
        return iterable;
    }

    public String getLabel() {
        String clsName;
        this.setCurrentGraphInThreadLocal();
        if (this.settings.useClassForVertexLabel && !"V".equals(clsName = this.getRecord().getClassName())) {
            return clsName;
        }
        return (String)this.getRecord().field("label");
    }

    @Override
    public String getBaseClassName() {
        return "V";
    }

    @Override
    public String getElementType() {
        return "Vertex";
    }

    public String toString() {
        String clsName;
        if (this.graph != null) {
            this.graph.setCurrentGraphInThreadLocal();
        }
        if ((clsName = this.getRecord().getClassName()).equals("V")) {
            return StringFactory.vertexString((Vertex)this);
        }
        return "v(" + clsName + ")" + "[" + this.getId() + "]";
    }

    public String getConnectionClass(Direction iDirection, String iFieldName) {
        if (iDirection == Direction.OUT) {
            if (iFieldName.length() > CONNECTION_OUT_PREFIX.length()) {
                return iFieldName.substring(CONNECTION_OUT_PREFIX.length());
            }
        } else if (iDirection == Direction.IN && iFieldName.length() > CONNECTION_IN_PREFIX.length()) {
            return iFieldName.substring(CONNECTION_IN_PREFIX.length());
        }
        return "E";
    }

    protected OPair<Direction, String> getConnection(Direction iDirection, String iFieldName, String ... iClassNames) {
        OrientEdgeType type;
        if (iDirection == Direction.OUT || iDirection == Direction.BOTH) {
            if (this.settings.useVertexFieldsForEdgeLabels) {
                if (iFieldName.startsWith(CONNECTION_OUT_PREFIX)) {
                    if (iClassNames == null || iClassNames.length == 0) {
                        return new OPair((Comparable)Direction.OUT, (Object)this.getConnectionClass(Direction.OUT, iFieldName));
                    }
                    for (String clsName : iClassNames) {
                        clsName = OrientBaseGraph.encodeClassName(clsName);
                        if (iFieldName.equals(CONNECTION_OUT_PREFIX + clsName)) {
                            return new OPair((Comparable)Direction.OUT, (Object)clsName);
                        }
                        type = this.graph.getEdgeType(clsName);
                        if (type == null) continue;
                        for (OClass subType : type.getAllBaseClasses()) {
                            clsName = subType.getName();
                            if (!iFieldName.equals(CONNECTION_OUT_PREFIX + clsName)) continue;
                            return new OPair((Comparable)Direction.OUT, (Object)clsName);
                        }
                    }
                }
            } else if (iFieldName.equals("out")) {
                return new OPair((Comparable)Direction.OUT, null);
            }
        }
        if (iDirection == Direction.IN || iDirection == Direction.BOTH) {
            if (this.settings.useVertexFieldsForEdgeLabels) {
                if (iFieldName.startsWith(CONNECTION_IN_PREFIX)) {
                    if (iClassNames == null || iClassNames.length == 0) {
                        return new OPair((Comparable)Direction.IN, (Object)this.getConnectionClass(Direction.IN, iFieldName));
                    }
                    for (String clsName : iClassNames) {
                        if (iFieldName.equals(CONNECTION_IN_PREFIX + clsName)) {
                            return new OPair((Comparable)Direction.IN, (Object)clsName);
                        }
                        type = this.graph.getEdgeType(clsName);
                        if (type == null) continue;
                        for (OClass subType : type.getAllBaseClasses()) {
                            clsName = subType.getName();
                            if (!iFieldName.equals(CONNECTION_IN_PREFIX + clsName)) continue;
                            return new OPair((Comparable)Direction.IN, (Object)clsName);
                        }
                    }
                }
            } else if (iFieldName.equals("in")) {
                return new OPair((Comparable)Direction.IN, null);
            }
        }
        return null;
    }

    protected void addSingleEdge(ODocument doc, OMultiCollectionIterator<Edge> iterable, String fieldName, OPair<Direction, String> connection, Object fieldValue, OIdentifiable iTargetVertex, String[] iLabels) {
        OrientEdge toAdd = OrientVertex.getEdge(this.graph, doc, fieldName, connection, fieldValue, iTargetVertex, iLabels);
        if (this.settings.useVertexFieldsForEdgeLabels || toAdd.isLabeled(iLabels)) {
            iterable.add((Object)toAdd);
        }
    }

    private boolean canCreateDynamicEdge(ODocument iFromVertex, ODocument iToVertex, String iOutFieldName, String iInFieldName, Object[] fields, String label) {
        this.checkIfAttached();
        if (!this.settings.useVertexFieldsForEdgeLabels && label != null) {
            return false;
        }
        if (this.settings.useLightweightEdges && (fields == null || fields.length == 0 || fields[0] == null)) {
            OrientEdgeType cls;
            Object field = iFromVertex.field(iOutFieldName);
            if (field != null && field instanceof Collection && ((Collection)field).contains(iToVertex)) {
                new OrientEdge(this.graph, (OIdentifiable)iFromVertex, (OIdentifiable)iToVertex, label).convertToDocument();
                return false;
            }
            field = iToVertex.field(iInFieldName);
            if (field != null && field instanceof Collection && ((Collection)field).contains(iFromVertex)) {
                new OrientEdge(this.graph, (OIdentifiable)iFromVertex, (OIdentifiable)iToVertex, label).convertToDocument();
                return false;
            }
            if (this.settings.useClassForEdgeLabel && (cls = this.graph.getEdgeType(label)) != null) {
                for (OProperty p : cls.properties()) {
                    if (!p.isMandatory() && !p.isNotNull() && p.getOwnerClass().getInvolvedIndexes(new String[]{p.getName()}).isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void addSingleVertex(ODocument doc, OMultiCollectionIterator<Vertex> iterable, String fieldName, OPair<Direction, String> connection, Object fieldValue, String[] iLabels) {
        OrientVertex toAdd;
        ODocument fieldRecord = (ODocument)((OIdentifiable)fieldValue).getRecord();
        if (fieldRecord.getSchemaClass().isSubClassOf("V")) {
            toAdd = new OrientVertex(this.graph, (OIdentifiable)fieldRecord);
        } else if (fieldRecord.getSchemaClass().isSubClassOf("E")) {
            if (this.settings.useVertexFieldsForEdgeLabels || OrientEdge.isLabeled(OrientEdge.getRecordLabel((OIdentifiable)fieldRecord), iLabels)) {
                OIdentifiable vertexDoc = OrientEdge.getConnection(fieldRecord, ((Direction)connection.getKey()).opposite());
                if (vertexDoc == null) {
                    fieldRecord.reload();
                    if (vertexDoc == null) {
                        OLogManager.instance().warn((Object)this, "Cannot load edge " + fieldRecord + " to get the " + ((Direction)connection.getKey()).opposite() + " vertex", new Object[0]);
                        return;
                    }
                }
                toAdd = new OrientVertex(this.graph, vertexDoc);
            } else {
                toAdd = null;
            }
        } else {
            throw new IllegalStateException("Invalid content found in " + fieldName + " field: " + fieldRecord);
        }
        if (toAdd != null) {
            iterable.add((Object)toAdd);
        }
    }
}

