/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyAbstractDelegate;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.OStorage;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElementType;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;

public class OrientVertexType
extends OrientElementType {
    public static final String CLASS_NAME = "V";

    public OrientVertexType(OrientBaseGraph graph, OClass delegate) {
        super(graph, delegate);
    }

    protected static final void checkType(OClass iType) {
        if (iType == null) {
            throw new IllegalArgumentException("Vertex class is null");
        }
        if (!iType.isSubClassOf(CLASS_NAME)) {
            throw new IllegalArgumentException("Type error. The class " + iType + " does not extend class '" + CLASS_NAME + "' and therefore cannot be considered a Vertex");
        }
    }

    public OrientVertexProperty createEdgeProperty(Direction iDirection, String iEdgeClassName) {
        iEdgeClassName = OrientBaseGraph.encodeClassName(iEdgeClassName);
        boolean useVertexFieldsForEdgeLabels = this.graph.isUseVertexFieldsForEdgeLabels();
        String fieldName = OrientVertex.getConnectionFieldName(iDirection, iEdgeClassName, useVertexFieldsForEdgeLabels);
        return new OrientVertexProperty(this.graph, this.delegate.createProperty(fieldName, OType.ANY));
    }

    public OrientVertexType getSuperClass() {
        return new OrientVertexType(this.graph, super.getSuperClass());
    }

    public OrientVertexType addCluster(String iClusterName) {
        this.delegate.addCluster(iClusterName);
        return this;
    }

    public OrientVertexType addCluster(String iClusterName, OStorage.CLUSTER_TYPE iClusterType) {
        this.delegate.addCluster(iClusterName, iClusterType);
        return this;
    }

    public OrientVertexProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass) {
        return new OrientVertexProperty(this.graph, super.createProperty(iPropertyName, iType, iLinkedClass));
    }

    public OrientVertexProperty createProperty(String iPropertyName, OType iType, OType iLinkedType) {
        return new OrientVertexProperty(this.graph, super.createProperty(iPropertyName, iType, iLinkedType));
    }

    public OrientVertexProperty createProperty(String iPropertyName, OType iType) {
        return new OrientVertexProperty(this.graph, super.createProperty(iPropertyName, iType));
    }

    @Override
    protected String getTypeName() {
        return "vertex";
    }

    public class OrientVertexProperty
    extends OPropertyAbstractDelegate {
        protected final OrientBaseGraph graph;

        public OrientVertexProperty(OrientBaseGraph iGraph, OProperty iProperty) {
            super(iProperty);
            this.graph = iGraph;
        }

        public boolean getOrdered() {
            String value = this.delegate.getCustom("ordered");
            return Boolean.parseBoolean(value);
        }

        public OrientVertexProperty setOrdered(boolean iOrdered) {
            this.delegate.setCustom("ordered", Boolean.toString(iOrdered));
            return this;
        }
    }
}

