/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.rexster.config.GraphConfiguration;
import com.tinkerpop.rexster.config.GraphConfigurationContext;
import com.tinkerpop.rexster.config.GraphConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;

public class OrientGraphConfiguration
implements GraphConfiguration {
    public Graph configureGraphInstance(GraphConfigurationContext context) throws GraphConfigurationException {
        SubnodeConfiguration orientDbSpecificConfiguration;
        String graphFile = context.getProperties().getString("graph-location");
        if (graphFile == null || graphFile.length() == 0) {
            throw new GraphConfigurationException("Check graph configuration. Missing or empty configuration element: graph-location");
        }
        HierarchicalConfiguration graphSectionConfig = (HierarchicalConfiguration)context.getProperties();
        try {
            orientDbSpecificConfiguration = graphSectionConfig.configurationAt("properties");
        }
        catch (IllegalArgumentException iae) {
            throw new GraphConfigurationException("Check graph configuration. Missing or empty configuration element: properties");
        }
        try {
            String username = orientDbSpecificConfiguration.getString("username", "");
            String password = orientDbSpecificConfiguration.getString("password", "");
            OGlobalConfiguration.CACHE_LEVEL1_ENABLED.setValue((Object)false);
            return new OrientGraph(graphFile, username, password);
        }
        catch (Exception ex) {
            throw new GraphConfigurationException((Throwable)ex);
        }
    }
}

