/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.intent.OIntent;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class OrientGraphFactory
extends OrientConfigurableGraph {
    private final String url;
    private final String user;
    private final String password;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private OIntent intent;
    private AtomicBoolean used = new AtomicBoolean(false);
    private volatile OPartitionedDatabasePool pool;
    private static OrientGraphImplFactory graphTxImplFactory = new OrientGraphImplFactory(){

        @Override
        public OrientBaseGraph getGraph(String url) {
            return new OrientGraph(url);
        }

        @Override
        public OrientBaseGraph getGraph(String url, String user, String password) {
            return new OrientGraph(url, user, password);
        }

        @Override
        public OrientBaseGraph getGraph(ODatabaseDocumentInternal database) {
            return new OrientGraph(database);
        }

        @Override
        public OrientBaseGraph getGraph(ODatabaseDocumentInternal database, String user, String password, OrientConfigurableGraph.Settings settings) {
            return new OrientGraph(database, user, password, settings);
        }

        @Override
        public OrientBaseGraph getGraph(OPartitionedDatabasePool pool, OrientConfigurableGraph.Settings settings) {
            return new OrientGraph(pool, settings);
        }

        @Override
        public OrientBaseGraph getGraph(ODatabaseDocumentInternal database, boolean autoCreateTx) {
            return new OrientGraph(database, autoCreateTx);
        }
    };
    private static OrientGraphImplFactory graphNoTxImplFactory = new OrientGraphImplFactory(){

        @Override
        public OrientBaseGraph getGraph(String url) {
            return new OrientGraphNoTx(url);
        }

        @Override
        public OrientBaseGraph getGraph(String url, String user, String password) {
            return new OrientGraphNoTx(url, user, password);
        }

        @Override
        public OrientBaseGraph getGraph(ODatabaseDocumentInternal database) {
            return new OrientGraphNoTx(database);
        }

        @Override
        public OrientBaseGraph getGraph(ODatabaseDocumentInternal database, String user, String password, OrientConfigurableGraph.Settings settings) {
            return new OrientGraphNoTx(database, user, password, settings);
        }

        @Override
        public OrientBaseGraph getGraph(OPartitionedDatabasePool pool, OrientConfigurableGraph.Settings settings) {
            return new OrientGraphNoTx(pool, settings);
        }

        @Override
        public OrientBaseGraph getGraph(ODatabaseDocumentInternal database, boolean autoCreateTx) {
            return new OrientGraphNoTx(database);
        }
    };

    public OrientGraphFactory(String iURL) {
        this(iURL, "admin", "admin");
    }

    public OrientGraphFactory(String iURL, boolean createPool) {
        this(iURL, "admin", "admin", createPool);
    }

    public OrientGraphFactory(String iURL, String iUser, String iPassword) {
        this(iURL, iUser, iPassword, true);
    }

    public OrientGraphFactory(String iURL, String iUser, String iPassword, boolean createPool) {
        this.url = iURL;
        this.user = iUser;
        this.password = iPassword;
        if (createPool) {
            this.pool = new OPartitionedDatabasePool(this.url, this.user, this.password, 8, -1).setAutoCreate(true);
        }
    }

    public OrientGraphFactory(String iURL, String iUser, String iPassword, OPartitionedDatabasePool pool) {
        this.url = iURL;
        this.user = iUser;
        this.password = iPassword;
        this.pool = pool;
    }

    public void close() {
        if (this.pool != null) {
            this.pool.close();
        }
        this.pool = null;
    }

    public void drop() {
        this.getDatabase(false, true).drop();
    }

    public OrientGraph getTx() {
        OrientGraph g = this.pool == null ? (OrientGraph)OrientGraphFactory.getTxGraphImplFactory().getGraph((ODatabaseDocumentInternal)this.getDatabase(), this.user, this.password, this.settings) : (OrientGraph)OrientGraphFactory.getTxGraphImplFactory().getGraph(this.pool, this.settings);
        this.initGraph(g);
        return g;
    }

    public OrientGraphNoTx getNoTx() {
        OrientGraphNoTx g = this.pool == null ? (OrientGraphNoTx)OrientGraphFactory.getNoTxGraphImplFactory().getGraph((ODatabaseDocumentInternal)this.getDatabase(), this.user, this.password, this.settings) : (OrientGraphNoTx)OrientGraphFactory.getNoTxGraphImplFactory().getGraph(this.pool, this.settings);
        this.initGraph(g);
        return g;
    }

    public static OrientGraphImplFactory getTxGraphImplFactory() {
        return graphTxImplFactory;
    }

    public static void setTxGraphImplFactory(OrientGraphImplFactory factory) {
        graphTxImplFactory = factory;
    }

    public static OrientGraphImplFactory getNoTxGraphImplFactory() {
        return graphNoTxImplFactory;
    }

    public static void setNoTxGraphImplFactory(OrientGraphImplFactory factory) {
        graphNoTxImplFactory = factory;
    }

    public ODatabaseDocumentTx getDatabase() {
        return this.getDatabase(true, true);
    }

    public ODatabaseDocumentTx getDatabase(boolean iCreate, boolean iOpen) {
        if (this.pool != null) {
            return this.pool.acquire();
        }
        ODatabaseDocumentTx db = new ODatabaseDocumentTx(this.url);
        if (this.properties != null) {
            this.properties.entrySet().forEach(arg_0 -> OrientGraphFactory.lambda$getDatabase$0((ODatabaseDocument)db, arg_0));
        }
        if (!db.getURL().startsWith("remote:") && !db.exists()) {
            if (iCreate) {
                db.create();
            } else if (iOpen) {
                throw new ODatabaseException("Database '" + this.url + "' not found");
            }
        } else if (iOpen) {
            db.open(this.user, this.password);
        }
        return db;
    }

    public boolean exists() {
        try (ODatabaseDocumentTx db = this.getDatabase(false, false);){
            boolean bl = db.exists();
            return bl;
        }
    }

    public OrientGraphFactory setupPool(int iMin, int iMax) {
        if (this.pool != null) {
            this.pool.close();
        }
        this.pool = new OPartitionedDatabasePool(this.url, this.user, this.password, 8, iMax).setAutoCreate(true);
        this.properties.entrySet().forEach(p -> this.pool.setProperty((String)p.getKey(), p.getValue()));
        return this;
    }

    public int getAvailableInstancesInPool() {
        if (this.pool != null) {
            return this.pool.getAvailableConnections();
        }
        return 0;
    }

    public int getCreatedInstancesInPool() {
        if (this.pool != null) {
            return this.pool.getCreatedInstances();
        }
        return 0;
    }

    @Override
    public void declareIntent(OIntent iIntent) {
        this.intent = iIntent;
    }

    protected void initGraph(OrientBaseGraph g) {
        if (this.used.compareAndSet(false, true)) {
            ODatabaseDocumentTx db = g.getRawGraph();
            boolean txActive = db.getTransaction().isActive();
            if (txActive) {
                db.commit();
            }
            if (txActive) {
                db.begin();
                db.getTransaction().setUsingLog(this.settings.isUseLog());
            }
        }
        if (this.intent != null) {
            g.declareIntent(this.intent.copy());
        }
    }

    @Override
    public Object setProperty(String iName, Object iValue) {
        if (this.pool != null) {
            this.pool.setProperty(iName, iValue);
        }
        if (iValue != null) {
            return this.properties.put(iName.toLowerCase(Locale.ENGLISH), iValue);
        }
        return this.properties.remove(iName.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Object getProperty(String iName) {
        return this.properties.get(iName.toLowerCase(Locale.ENGLISH));
    }

    @Override
    protected Map<String, Object> getProperties() {
        return this.properties;
    }

    private static /* synthetic */ void lambda$getDatabase$0(ODatabaseDocument db, Map.Entry e) {
        db.setProperty((String)e.getKey(), e.getValue());
    }

    public static interface OrientGraphImplFactory {
        public OrientBaseGraph getGraph(String var1);

        public OrientBaseGraph getGraph(String var1, String var2, String var3);

        public OrientBaseGraph getGraph(ODatabaseDocumentInternal var1);

        public OrientBaseGraph getGraph(ODatabaseDocumentInternal var1, String var2, String var3, OrientConfigurableGraph.Settings var4);

        public OrientBaseGraph getGraph(OPartitionedDatabasePool var1, OrientConfigurableGraph.Settings var2);

        public OrientBaseGraph getGraph(ODatabaseDocumentInternal var1, boolean var2);
    }
}

