/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientGraphModificationException;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import org.apache.commons.configuration.Configuration;

public class OrientGraphNoTx
extends OrientBaseGraph {
    private final Features FEATURES = new Features();

    public OrientGraphNoTx(ODatabaseDocumentInternal iDatabase) {
        super(iDatabase, null, null, null);
        this.config();
    }

    public OrientGraphNoTx(OPartitionedDatabasePool pool) {
        super(pool);
        this.config();
    }

    public OrientGraphNoTx(OPartitionedDatabasePool pool, OrientConfigurableGraph.Settings configuration) {
        super(pool, configuration);
        this.config();
    }

    public OrientGraphNoTx(String url) {
        super(url, "admin", "admin");
        this.config();
    }

    public OrientGraphNoTx(String url, String username, String password) {
        super(url, username, password);
        this.config();
    }

    public OrientGraphNoTx(Configuration configuration) {
        super(configuration);
        this.config();
    }

    public OrientGraphNoTx(ODatabaseDocumentInternal iDatabase, String user, String password) {
        super(iDatabase, user, password, null);
        this.config();
    }

    public OrientGraphNoTx(ODatabaseDocumentInternal iDatabase, String user, String password, OrientConfigurableGraph.Settings iConfiguration) {
        super(iDatabase, user, password, iConfiguration);
        this.config();
    }

    public Features getFeatures() {
        this.makeActive();
        this.FEATURES.supportsEdgeIndex = !this.isUseLightweightEdges();
        this.FEATURES.supportsEdgeKeyIndex = !this.isUseLightweightEdges();
        this.FEATURES.supportsEdgeIteration = !this.isUseLightweightEdges();
        this.FEATURES.supportsEdgeRetrieval = !this.isUseLightweightEdges();
        return this.FEATURES;
    }

    protected void config() {
        this.FEATURES.supportsDuplicateEdges = true;
        this.FEATURES.supportsSelfLoops = true;
        this.FEATURES.isPersistent = true;
        this.FEATURES.supportsVertexIteration = true;
        this.FEATURES.supportsVertexIndex = true;
        this.FEATURES.ignoresSuppliedIds = true;
        this.FEATURES.supportsTransactions = false;
        this.FEATURES.supportsVertexKeyIndex = true;
        this.FEATURES.supportsKeyIndices = true;
        this.FEATURES.isWrapper = false;
        this.FEATURES.supportsIndices = true;
        this.FEATURES.supportsVertexProperties = true;
        this.FEATURES.supportsEdgeProperties = true;
        this.FEATURES.supportsSerializableObjectProperty = true;
        this.FEATURES.supportsBooleanProperty = true;
        this.FEATURES.supportsDoubleProperty = true;
        this.FEATURES.supportsFloatProperty = true;
        this.FEATURES.supportsIntegerProperty = true;
        this.FEATURES.supportsPrimitiveArrayProperty = true;
        this.FEATURES.supportsUniformListProperty = true;
        this.FEATURES.supportsMixedListProperty = true;
        this.FEATURES.supportsLongProperty = true;
        this.FEATURES.supportsMapProperty = true;
        this.FEATURES.supportsStringProperty = true;
        this.FEATURES.supportsThreadedTransactions = false;
        this.FEATURES.supportsThreadIsolatedTransactions = false;
    }

    @Override
    OrientEdge addEdgeInternal(OrientVertex currentVertex, String label, OrientVertex inVertex, String iClassName, String iClusterName, Object ... fields) {
        return OrientGraphNoTx.addEdgeInternal(this, currentVertex, label, inVertex, iClassName, iClusterName, fields);
    }

    static OrientEdge addEdgeInternal(OrientBaseGraph graph, OrientVertex currentVertex, String label, OrientVertex inVertex, String iClassName, String iClusterName, Object ... fields) {
        OrientEdge edge = null;
        ODocument outDocument = null;
        ODocument inDocument = null;
        boolean outDocumentModified = false;
        OrientConfigurableGraph.Settings settings = graph != null ? graph.settings : new OrientConfigurableGraph.Settings();
        int maxRetries = graph != null ? graph.getMaxRetries() : 1;
        for (int retry = 0; retry < maxRetries; ++retry) {
            try {
                ODocument edgeRecord;
                ODocument to;
                OIdentifiable from;
                if (outDocument == null && (outDocument = currentVertex.getRecord()) == null) {
                    throw new IllegalArgumentException("source vertex is invalid (rid=" + currentVertex.getIdentity() + ")");
                }
                if (!ODocumentInternal.getImmutableSchemaClass(outDocument).isVertexType()) {
                    throw new IllegalArgumentException("source record is not a vertex");
                }
                if (inDocument == null && (inDocument = inVertex.getRecord()) == null) {
                    throw new IllegalArgumentException("destination vertex is invalid (rid=" + inVertex.getIdentity() + ")");
                }
                if (!ODocumentInternal.getImmutableSchemaClass(inDocument).isVertexType()) {
                    throw new IllegalArgumentException("destination record is not a vertex");
                }
                if ((label = OrientBaseGraph.encodeClassName(label)) == null && iClassName != null) {
                    label = OrientBaseGraph.encodeClassName(iClassName);
                }
                if (graph != null && graph.isUseClassForEdgeLabel()) {
                    OrientEdgeType edgeType = graph.getEdgeType(label);
                    if (edgeType == null) {
                        graph.createEdgeType(label);
                    } else {
                        label = edgeType.getName();
                    }
                }
                String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, label, settings.isUseVertexFieldsForEdgeLabels());
                String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, label, settings.isUseVertexFieldsForEdgeLabels());
                if (label == null) {
                    throw ExceptionFactory.edgeLabelCanNotBeNull();
                }
                if (currentVertex.canCreateDynamicEdge(outDocument, inDocument, outFieldName, inFieldName, fields, label)) {
                    boolean lightWeightEdge = true;
                    from = currentVertex.rawElement;
                    to = inDocument;
                    if (edge == null) {
                        edge = settings.isKeepInMemoryReferences() ? graph.getEdgeInstance((OIdentifiable)from.getIdentity(), (OIdentifiable)to.getIdentity(), label) : graph.getEdgeInstance(from, (OIdentifiable)to, label);
                    }
                    edgeRecord = null;
                } else {
                    boolean lightWeightEdge = false;
                    if (edge == null) {
                        edge = graph.getEdgeInstance(label, fields);
                        edgeRecord = edge.getRecord();
                        if (settings.isKeepInMemoryReferences()) {
                            edgeRecord.fields("out", (Object)currentVertex.rawElement.getIdentity(), new Object[]{"in", inDocument.getIdentity()});
                        } else {
                            edgeRecord.fields("out", (Object)currentVertex.rawElement, new Object[]{"in", inDocument});
                        }
                    } else {
                        edgeRecord = edge.getRecord();
                    }
                    from = edgeRecord;
                    to = edgeRecord;
                }
                if (settings.isKeepInMemoryReferences()) {
                    from = from.getIdentity();
                    to = to.getIdentity();
                }
                if (graph != null && edgeRecord != null) {
                    edgeRecord.save(iClusterName);
                }
                if (!outDocumentModified) {
                    OrientVertex.createLink(graph, outDocument, (OIdentifiable)to, outFieldName);
                    if (graph != null) {
                        outDocument.save();
                        outDocumentModified = true;
                    }
                }
                OrientVertex.createLink(graph, inDocument, from, inFieldName);
                if (graph == null) break;
                inDocument.save();
                break;
            }
            catch (ONeedRetryException e) {
                if (!outDocumentModified) {
                    outDocument.reload();
                    continue;
                }
                if (inDocument == null) continue;
                inDocument.reload();
                continue;
            }
            catch (RuntimeException e) {
                try {
                    edge.remove();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            catch (Exception e) {
                try {
                    edge.remove();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw OException.wrapException((OException)new OrientGraphModificationException("Error on addEdge in non tx environment"), (Throwable)e);
            }
        }
        return edge;
    }

    @Override
    public void removeEdgeInternal(OrientEdge edge) {
        OrientGraphNoTx.removeEdgeInternal(this, edge);
    }

    public static void removeEdgeInternal(OrientBaseGraph graph, OrientEdge edge) {
        ODocument outVertexRecord = null;
        boolean outVertexChanged = false;
        ODocument inVertexRecord = null;
        boolean inVertexChanged = false;
        OrientConfigurableGraph.Settings settings = graph != null ? graph.settings : new OrientConfigurableGraph.Settings();
        int maxRetries = graph != null ? graph.getMaxRetries() : 1;
        for (int retry = 0; retry < maxRetries; ++retry) {
            try {
                OIdentifiable inVertexEdge = edge.vIn != null ? edge.vIn : edge.rawElement;
                String edgeClassName = OrientBaseGraph.encodeClassName(edge.getLabel());
                boolean useVertexFieldsForEdgeLabels = settings.isUseVertexFieldsForEdgeLabels();
                OIdentifiable outVertex = edge.getOutVertex();
                if (outVertex != null) {
                    outVertexRecord = (ODocument)outVertex.getRecord();
                    if (outVertexRecord != null) {
                        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, edgeClassName, useVertexFieldsForEdgeLabels);
                        outVertexChanged = edge.dropEdgeFromVertex(inVertexEdge, outVertexRecord, outFieldName, outVertexRecord.field(outFieldName));
                    } else {
                        OLogManager.instance().debug((Object)graph, "Found broken link to outgoing vertex " + outVertex.getIdentity() + " while removing edge " + edge.getId(), new Object[0]);
                    }
                }
                OIdentifiable outVertexEdge = edge.vOut != null ? edge.vOut : edge.rawElement;
                OIdentifiable inVertex = edge.getInVertex();
                inVertexRecord = null;
                inVertexChanged = false;
                if (inVertex != null) {
                    inVertexRecord = (ODocument)inVertex.getRecord();
                    if (inVertexRecord != null) {
                        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, edgeClassName, useVertexFieldsForEdgeLabels);
                        inVertexChanged = edge.dropEdgeFromVertex(outVertexEdge, inVertexRecord, inFieldName, inVertexRecord.field(inFieldName));
                    } else {
                        OLogManager.instance().debug((Object)graph, "Found broken link to incoming vertex " + inVertex.getIdentity() + " while removing edge " + edge.getId(), new Object[0]);
                    }
                }
                if (outVertexChanged) {
                    outVertexRecord.save();
                }
                if (inVertexChanged) {
                    inVertexRecord.save();
                }
                if (edge.rawElement == null) break;
                edge.removeRecord();
                break;
            }
            catch (ONeedRetryException e) {
                if (outVertexChanged) {
                    outVertexRecord.reload();
                    continue;
                }
                if (!inVertexChanged) continue;
                inVertexRecord.reload();
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw OException.wrapException((OException)new OrientGraphModificationException("Error on addEdge in non tx environment"), (Throwable)e);
            }
        }
    }

    @Override
    void removeEdgesInternal(OrientVertex vertex, ODocument iVertex, OIdentifiable iVertexToRemove, boolean iAlsoInverse, boolean useVertexFieldsForEdgeLabels, boolean autoScaleEdgeType) {
        Exception lastException = null;
        boolean forceReload = false;
        int maxRetries = this.getMaxRetries();
        for (int retry = 0; retry < maxRetries; ++retry) {
            try {
                for (String fieldName : iVertex.fieldNames()) {
                    OPair<Direction, String> connection = vertex.getConnection(Direction.BOTH, fieldName, new String[0]);
                    if (connection == null) continue;
                    OrientGraphNoTx.removeEdges(this, iVertex, fieldName, iVertexToRemove, iAlsoInverse, useVertexFieldsForEdgeLabels, autoScaleEdgeType, forceReload);
                }
                return;
            }
            catch (Exception e) {
                forceReload = true;
                lastException = e;
                continue;
            }
        }
        if (lastException instanceof RuntimeException) {
            throw (RuntimeException)lastException;
        }
        throw OException.wrapException((OException)new OrientGraphModificationException("Error on removing edges after vertex (" + iVertex.getIdentity() + ") delete in non tx environment"), (Throwable)lastException);
    }
}

