/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientTransactionalGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import org.apache.commons.configuration.Configuration;

public class OrientGraph
extends OrientTransactionalGraph {
    private boolean featuresInitialized = false;
    protected final Features features = new Features();

    public OrientGraph(ODatabaseDocumentInternal iDatabase, String iUserName, String iUserPasswd) {
        super(iDatabase, true, iUserName, iUserPasswd);
    }

    public OrientGraph(ODatabaseDocumentInternal iDatabase, boolean iAutoStartTx) {
        super(iDatabase, iAutoStartTx, null, null);
    }

    public OrientGraph(String url) {
        super(url, "admin", "admin");
    }

    public OrientGraph(String url, boolean iAutoStartTx) {
        super(url, "admin", "admin", iAutoStartTx);
    }

    public OrientGraph(String url, String username, String password) {
        super(url, username, password);
    }

    public OrientGraph(String url, String username, String password, boolean iAutoStartTx) {
        super(url, username, password, iAutoStartTx);
    }

    public OrientGraph(OPartitionedDatabasePool pool) {
        super(pool);
    }

    public OrientGraph(OPartitionedDatabasePool pool, OrientConfigurableGraph.Settings configuration) {
        super(pool, configuration);
    }

    public OrientGraph(Configuration iConfiguration) {
        super(iConfiguration);
    }

    public OrientGraph(ODatabaseDocumentInternal iDatabase) {
        super(iDatabase);
    }

    public OrientGraph(ODatabaseDocumentInternal iDatabase, String iUser, String iPassword, OrientConfigurableGraph.Settings iConfiguration) {
        super(iDatabase, iUser, iPassword, iConfiguration);
    }

    public Features getFeatures() {
        this.makeActive();
        if (!this.featuresInitialized) {
            this.features.supportsDuplicateEdges = true;
            this.features.supportsSelfLoops = true;
            this.features.isPersistent = true;
            this.features.supportsVertexIteration = true;
            this.features.supportsVertexIndex = true;
            this.features.ignoresSuppliedIds = true;
            this.features.supportsTransactions = true;
            this.features.supportsVertexKeyIndex = true;
            this.features.supportsKeyIndices = true;
            this.features.isWrapper = false;
            this.features.supportsIndices = true;
            this.features.supportsVertexProperties = true;
            this.features.supportsEdgeProperties = true;
            this.features.supportsSerializableObjectProperty = true;
            this.features.supportsBooleanProperty = true;
            this.features.supportsDoubleProperty = true;
            this.features.supportsFloatProperty = true;
            this.features.supportsIntegerProperty = true;
            this.features.supportsPrimitiveArrayProperty = true;
            this.features.supportsUniformListProperty = true;
            this.features.supportsMixedListProperty = true;
            this.features.supportsLongProperty = true;
            this.features.supportsMapProperty = true;
            this.features.supportsStringProperty = true;
            this.features.supportsThreadedTransactions = false;
            this.features.supportsThreadIsolatedTransactions = false;
            this.features.supportsEdgeIndex = !this.isUseLightweightEdges();
            this.features.supportsEdgeKeyIndex = !this.isUseLightweightEdges();
            this.features.supportsEdgeIteration = !this.isUseLightweightEdges();
            this.features.supportsEdgeRetrieval = !this.isUseLightweightEdges();
            this.featuresInitialized = true;
        }
        return this.features;
    }

    @Override
    OrientEdge addEdgeInternal(OrientVertex currentVertex, String label, OrientVertex inVertex, String iClassName, String iClusterName, Object ... fields) {
        ODocument to;
        OIdentifiable from;
        if (currentVertex.checkDeletedInTx()) {
            throw new ORecordNotFoundException(currentVertex.getIdentity(), "The vertex " + currentVertex.getIdentity() + " has been deleted");
        }
        if (inVertex.checkDeletedInTx()) {
            throw new ORecordNotFoundException(inVertex.getIdentity(), "The vertex " + inVertex.getIdentity() + " has been deleted");
        }
        this.autoStartTransaction();
        ODocument outDocument = currentVertex.getRecord();
        if (outDocument == null) {
            throw new IllegalArgumentException("source vertex is invalid (rid=" + currentVertex.getIdentity() + ")");
        }
        if (!ODocumentInternal.getImmutableSchemaClass((ODocument)outDocument).isVertexType()) {
            throw new IllegalArgumentException("source record is not a vertex");
        }
        ODocument inDocument = inVertex.getRecord();
        if (inDocument == null) {
            throw new IllegalArgumentException("destination vertex is invalid (rid=" + inVertex.getIdentity() + ")");
        }
        if (!ODocumentInternal.getImmutableSchemaClass((ODocument)outDocument).isVertexType()) {
            throw new IllegalArgumentException("destination record is not a vertex");
        }
        if ((label = OrientBaseGraph.encodeClassName(label)) == null && iClassName != null) {
            label = OrientBaseGraph.encodeClassName(iClassName);
        }
        if (this.isUseClassForEdgeLabel()) {
            OrientEdgeType edgeType = this.getEdgeType(label);
            if (edgeType == null) {
                this.createEdgeType(label);
            } else {
                label = edgeType.getName();
            }
        }
        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, label, this.settings.isUseVertexFieldsForEdgeLabels());
        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, label, this.settings.isUseVertexFieldsForEdgeLabels());
        if (label == null) {
            throw ExceptionFactory.edgeLabelCanNotBeNull();
        }
        OrientEdge edge = null;
        if (currentVertex.canCreateDynamicEdge(outDocument, inDocument, outFieldName, inFieldName, fields, label)) {
            from = currentVertex.rawElement;
            to = inDocument;
            if (edge == null) {
                edge = this.settings.isKeepInMemoryReferences() ? this.getEdgeInstance((OIdentifiable)from.getIdentity(), (OIdentifiable)to.getIdentity(), label) : this.getEdgeInstance(from, (OIdentifiable)to, label);
            }
        } else {
            if (edge == null) {
                edge = this.getEdgeInstance(label, fields);
                if (this.settings.isKeepInMemoryReferences()) {
                    edge.getRecord().fields("out", (Object)currentVertex.rawElement.getIdentity(), new Object[]{"in", inDocument.getIdentity()});
                } else {
                    edge.getRecord().fields("out", (Object)currentVertex.rawElement, new Object[]{"in", inDocument});
                }
            }
            from = edge.getRecord();
            to = edge.getRecord();
        }
        if (this.settings.isKeepInMemoryReferences()) {
            from = from.getIdentity();
            to = to.getIdentity();
        }
        OrientVertex.createLink(this, outDocument, (OIdentifiable)to, outFieldName);
        OrientVertex.createLink(this, inDocument, from, inFieldName);
        if (!edge.isLightweight()) {
            edge.save(iClusterName);
        } else {
            outDocument.save();
        }
        return edge;
    }

    @Override
    public void removeEdgeInternal(OrientEdge edge) {
        OIdentifiable inVertexEdge = edge.vIn != null ? edge.vIn : edge.rawElement;
        String edgeClassName = OrientBaseGraph.encodeClassName(edge.getLabel());
        boolean useVertexFieldsForEdgeLabels = this.settings.isUseVertexFieldsForEdgeLabels();
        OIdentifiable outVertex = edge.getOutVertex();
        ODocument outVertexRecord = null;
        boolean outVertexChanged = false;
        if (outVertex != null && (outVertexRecord = (ODocument)outVertex.getRecord()) != null) {
            String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, edgeClassName, useVertexFieldsForEdgeLabels);
            outVertexChanged = edge.dropEdgeFromVertex(inVertexEdge, outVertexRecord, outFieldName, outVertexRecord.field(outFieldName));
        }
        OIdentifiable outVertexEdge = edge.vOut != null ? edge.vOut : edge.rawElement;
        OIdentifiable inVertex = edge.getInVertex();
        ODocument inVertexRecord = null;
        boolean inVertexChanged = false;
        if (inVertex != null && (inVertexRecord = (ODocument)inVertex.getRecord()) != null) {
            String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, edgeClassName, useVertexFieldsForEdgeLabels);
            inVertexChanged = edge.dropEdgeFromVertex(outVertexEdge, inVertexRecord, inFieldName, inVertexRecord.field(inFieldName));
        }
        if (outVertexChanged) {
            outVertexRecord.save();
        }
        if (inVertexChanged) {
            inVertexRecord.save();
        }
        if (edge.rawElement != null) {
            edge.removeRecord();
        }
    }

    @Override
    void removeEdgesInternal(OrientVertex vertex, ODocument iVertex, OIdentifiable iVertexToRemove, boolean iAlsoInverse, boolean useVertexFieldsForEdgeLabels, boolean autoScaleEdgeType) {
        for (String fieldName : iVertex.fieldNames()) {
            OPair<Direction, String> connection = vertex.getConnection(Direction.BOTH, fieldName, new String[0]);
            if (connection == null) continue;
            OrientGraph.removeEdges(this, iVertex, fieldName, iVertexToRemove, iAlsoInverse, useVertexFieldsForEdgeLabels, autoScaleEdgeType, false);
        }
    }
}

