/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Contains;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import com.tinkerpop.blueprints.util.DefaultGraphQuery;
import com.tinkerpop.blueprints.util.DefaultQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class OrientGraphQuery
extends DefaultGraphQuery {
    protected static final char SPACE = ' ';
    protected static final String OPERATOR_DIFFERENT = "<>";
    protected static final String OPERATOR_NOT = "not ";
    protected static final String OPERATOR_IS_NOT = "is not";
    protected static final String OPERATOR_LET = "<=";
    protected static final char OPERATOR_LT = '<';
    protected static final String OPERATOR_GTE = ">=";
    protected static final char OPERATOR_GT = '>';
    protected static final String OPERATOR_EQUALS = "=";
    protected static final String OPERATOR_IS = "is";
    protected static final String OPERATOR_IN = " in ";
    protected static final String OPERATOR_LIKE = " like ";
    protected static final String QUERY_FILTER_AND = " and ";
    protected static final String QUERY_FILTER_OR = " or ";
    protected static final char QUERY_STRING = '\'';
    protected static final char QUERY_SEPARATOR = ',';
    protected static final char COLLECTION_BEGIN = '[';
    protected static final char COLLECTION_END = ']';
    protected static final char PARENTHESIS_BEGIN = '(';
    protected static final char PARENTHESIS_END = ')';
    protected static final String QUERY_LABEL_BEGIN = " label in [";
    protected static final String QUERY_LABEL_END = "]";
    protected static final String QUERY_WHERE = " where ";
    protected static final String QUERY_SELECT_FROM = "select from ";
    protected static final String SKIP = " SKIP ";
    protected static final String LIMIT = " LIMIT ";
    protected static final String ORDERBY = " ORDER BY ";
    public int skip = 0;
    public String orderBy = "";
    public String orderByDir = "desc";
    protected String fetchPlan;

    protected OrientGraphQuery(Graph iGraph) {
        super(iGraph);
    }

    public Query labels(String ... labels) {
        this.labels = labels;
        return this;
    }

    public Query skip(int iSkip) {
        this.skip = iSkip;
        return this;
    }

    public Query order(String props) {
        this.order(props, this.orderByDir);
        return this;
    }

    public Query order(String props, String dir) {
        this.orderBy = props;
        this.orderByDir = dir;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Iterable<Vertex> vertices() {
        if (this.limit == 0) {
            return Collections.emptyList();
        }
        OTransaction transaction = ((OrientBaseGraph)this.graph).getRawGraph().getTransaction();
        if (this.hasCustomPredicate()) {
            String[] classes = this.allSubClassesLabels();
            return new OrientGraphQueryIterable(true, classes);
        }
        StringBuilder text = new StringBuilder(512);
        text.append(QUERY_SELECT_FROM);
        if (((OrientBaseGraph)this.graph).isUseClassForVertexLabel() && this.labels != null && this.labels.length > 0) {
            if (this.labels.length != 1) {
                String[] classes = this.allSubClassesLabels();
                return new OrientGraphQueryIterable(true, classes);
            }
            text.append(OrientBaseGraph.encodeClassName(this.labels[0]));
        } else {
            text.append("V");
        }
        List<Object> queryParams = this.manageFilters(text);
        if (!((OrientBaseGraph)this.graph).isUseClassForVertexLabel()) {
            this.manageLabels(queryParams.size() > 0, text);
        }
        if (this.orderBy.length() > 1) {
            text.append(ORDERBY);
            text.append(this.orderBy);
            text.append(" ").append(this.orderByDir).append(" ");
        }
        if (this.skip > 0 && this.skip < Integer.MAX_VALUE) {
            text.append(SKIP);
            text.append(this.skip);
        }
        if (this.limit > 0 && this.limit < Integer.MAX_VALUE) {
            text.append(LIMIT);
            text.append(this.limit);
        }
        OSQLSynchQuery query = new OSQLSynchQuery(text.toString());
        if (this.fetchPlan != null) {
            query.setFetchPlan(this.fetchPlan);
        }
        return new OrientElementIterable((OrientBaseGraph)this.graph, ((OrientBaseGraph)this.graph).getRawGraph().query((OQuery)query, queryParams.toArray()));
    }

    private String[] allSubClassesLabels() {
        String[] classes = null;
        if (this.labels != null && this.labels.length > 0) {
            ArrayList<String> tmpClasses = new ArrayList<String>();
            for (String label : this.labels) {
                OrientVertexType vertexType = ((OrientBaseGraph)this.graph).getVertexType(label);
                tmpClasses.add(vertexType.getName());
                Collection allSubclasses = vertexType.getAllSubclasses();
                for (OClass klass : allSubclasses) {
                    tmpClasses.add(klass.getName());
                }
            }
            classes = tmpClasses.toArray(new String[tmpClasses.size()]);
        }
        return classes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterable<Edge> edges() {
        if (this.limit == 0) {
            return Collections.emptyList();
        }
        if (((OrientBaseGraph)this.graph).getRawGraph().getTransaction().isActive() || this.hasCustomPredicate()) {
            return new OrientGraphQueryIterable(false, this.labels);
        }
        if (((OrientBaseGraph)this.graph).isUseLightweightEdges()) {
            return new OrientGraphQueryIterable(false, this.labels);
        }
        StringBuilder text = new StringBuilder(512);
        text.append(QUERY_SELECT_FROM);
        if (((OrientBaseGraph)this.graph).isUseClassForEdgeLabel() && this.labels != null && this.labels.length > 0) {
            if (this.labels.length != 1) return new OrientGraphQueryIterable(false, this.labels);
            text.append(OrientBaseGraph.encodeClassName(this.labels[0]));
        } else {
            text.append("E");
        }
        List<Object> queryParams = this.manageFilters(text);
        if (!((OrientBaseGraph)this.graph).isUseClassForEdgeLabel()) {
            this.manageLabels(queryParams.size() > 0, text);
        }
        OSQLSynchQuery query = new OSQLSynchQuery(text.toString());
        if (this.fetchPlan != null) {
            query.setFetchPlan(this.fetchPlan);
        }
        if (this.limit <= 0 || this.limit >= Integer.MAX_VALUE) return new OrientElementIterable((OrientBaseGraph)this.graph, ((OrientBaseGraph)this.graph).getRawGraph().query((OQuery)query, queryParams.toArray()));
        query.setLimit(this.limit);
        return new OrientElementIterable((OrientBaseGraph)this.graph, ((OrientBaseGraph)this.graph).getRawGraph().query((OQuery)query, queryParams.toArray()));
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    protected void manageLabels(boolean usedWhere, StringBuilder text) {
        if (this.labels != null && this.labels.length > 0) {
            if (!usedWhere) {
                text.append(QUERY_WHERE);
            } else {
                text.append(QUERY_FILTER_AND);
            }
            text.append(QUERY_LABEL_BEGIN);
            for (int i = 0; i < this.labels.length; ++i) {
                if (i > 0) {
                    text.append(',');
                }
                text.append('\'');
                text.append(this.labels[i]);
                text.append('\'');
            }
            text.append(QUERY_LABEL_END);
        }
    }

    protected boolean hasCustomPredicate() {
        for (DefaultQuery.HasContainer has : this.hasContainers) {
            if (has.predicate instanceof Contains || has.predicate instanceof Compare) continue;
            return true;
        }
        return false;
    }

    protected List<Object> manageFilters(StringBuilder text) {
        boolean firstPredicate = true;
        ArrayList<Object> params = new ArrayList<Object>();
        for (DefaultQuery.HasContainer has : this.hasContainers) {
            if (!firstPredicate) {
                text.append(QUERY_FILTER_AND);
            } else {
                text.append(QUERY_WHERE);
                firstPredicate = false;
            }
            if (has.predicate instanceof Contains) {
                if (has.predicate == Contains.NOT_IN) {
                    text.append(OPERATOR_NOT);
                    text.append('(');
                }
                text.append('`').append(has.key).append('`');
                if (has.value instanceof String) {
                    text.append(OPERATOR_LIKE);
                    text.append("?");
                    params.add(has.value);
                } else {
                    text.append(OPERATOR_IN);
                    text.append('[');
                    boolean firstItem = true;
                    for (Object o : (Collection)has.value) {
                        if (!firstItem) {
                            text.append(',');
                        } else {
                            firstItem = false;
                        }
                        text.append("?");
                        params.add(o);
                    }
                    text.append(']');
                }
                if (has.predicate != Contains.NOT_IN) continue;
                text.append(')');
                continue;
            }
            text.append('`').append(has.key).append('`');
            text.append(' ');
            if (has.predicate instanceof Compare) {
                Compare compare = (Compare)has.predicate;
                boolean appendParam = true;
                switch (compare) {
                    case EQUAL: {
                        if (has.value == null) {
                            text.append(OPERATOR_IS);
                            text.append(" NULL ");
                            appendParam = false;
                            break;
                        }
                        text.append(OPERATOR_EQUALS);
                        break;
                    }
                    case GREATER_THAN: {
                        text.append('>');
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        text.append(OPERATOR_GTE);
                        break;
                    }
                    case LESS_THAN: {
                        text.append('<');
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        text.append(OPERATOR_LET);
                        break;
                    }
                    case NOT_EQUAL: {
                        if (has.value == null) {
                            text.append(OPERATOR_IS_NOT);
                            text.append(" NULL ");
                            appendParam = false;
                            break;
                        }
                        text.append(OPERATOR_DIFFERENT);
                    }
                }
                text.append(' ');
                if (appendParam) {
                    text.append("?");
                    params.add(has.value);
                }
            }
            if (!(has.value instanceof Collection)) continue;
            text.append(')');
        }
        return params;
    }

    protected void generateFilterValue(StringBuilder text, Object iValue) {
        if (iValue instanceof String) {
            text.append('\'');
        }
        Object value = iValue instanceof Date ? Long.valueOf(((Date)iValue).getTime()) : (iValue != null ? iValue.toString().replace("'", "\\'") : null);
        text.append(value);
        if (iValue instanceof String) {
            text.append('\'');
        }
    }

    public class OrientGraphQueryIterable<T extends Element>
    extends DefaultGraphQuery.DefaultGraphQueryIterable<T> {
        public OrientGraphQueryIterable(boolean forVertex, String[] labels) {
            super((DefaultGraphQuery)OrientGraphQuery.this, forVertex);
            if (labels != null && labels.length > 0) {
                OrientGraphQuery.this.has("_class", (Predicate)Contains.IN, Arrays.asList(labels));
            }
        }

        protected Set<String> getIndexedKeys(Class<? extends Element> elementClass) {
            return ((OrientBaseGraph)OrientGraphQuery.this.graph).getIndexedKeys(elementClass, true);
        }
    }
}

