/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientProperty;
import org.apache.tinkerpop.gremlin.orientdb.StreamUtils;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;

public abstract class OrientElement
implements Element,
OIdentifiable {
    protected OElement rawElement;
    protected OrientGraph graph;

    public OrientElement(OrientGraph graph, OElement rawElement) {
        if (rawElement == null) {
            throw new IllegalArgumentException("rawElement must not be null!");
        }
        this.graph = (OrientGraph)Preconditions.checkNotNull((Object)graph);
        this.rawElement = (OElement)Preconditions.checkNotNull((Object)rawElement);
    }

    public ORID id() {
        return this.rawElement.getIdentity();
    }

    public String label() {
        this.graph.tx().readWrite();
        String internalClassName = ((OClass)this.getRawElement().getSchemaType().get()).getName();
        return this.graph.classNameToLabel(internalClassName);
    }

    public Graph graph() {
        return this.graph;
    }

    public <V> Property<V> property(String key, V value) {
        return this.property(key, value, true);
    }

    private <V> Property<V> property(String key, V value, boolean saveDocument) {
        if (key == null) {
            throw Property.Exceptions.propertyKeyCanNotBeNull();
        }
        if (value == null) {
            throw Property.Exceptions.propertyValueCanNotBeNull();
        }
        if (Graph.Hidden.isHidden((String)key)) {
            throw Property.Exceptions.propertyKeyCanNotBeAHiddenKey((String)key);
        }
        this.graph.tx().readWrite();
        OElement doc = this.getRawElement();
        doc.setProperty(key, value);
        if (saveDocument) {
            doc.save();
        }
        return new OrientProperty<V>(key, value, this);
    }

    public void property(Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Vertex.Exceptions.userSuppliedIdsNotSupported();
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            if (keyValues[i].equals(T.id) || keyValues[i].equals(T.label)) continue;
            this.property((String)keyValues[i], keyValues[i + 1], false);
        }
        this.getRawElement().save();
    }

    public <V> Iterator<? extends Property<V>> properties(String ... propertyKeys) {
        this.graph.tx().readWrite();
        ODocument record = (ODocument)this.rawElement.getRecord();
        Map properties = record.toMap();
        HashSet<String> keys = new HashSet<String>(Arrays.asList(propertyKeys));
        Stream entries = StreamUtils.asStream(properties.entrySet().iterator());
        if (keys.size() > 0) {
            entries = entries.filter(entry -> keys.contains(entry.getKey()));
        }
        Stream<OrientProperty> propertyStream = entries.map(entry -> new OrientProperty((String)entry.getKey(), entry.getValue(), this));
        return propertyStream.iterator();
    }

    public void remove() {
        this.graph.tx().readWrite();
        this.rawElement.delete();
    }

    public void save() {
        this.rawElement.save();
    }

    public OrientGraph getGraph() {
        return this.graph;
    }

    public abstract OElement getRawElement();

    public final int hashCode() {
        return ElementHelper.hashCode((Element)this);
    }

    public final boolean equals(Object object) {
        return ElementHelper.areEqual((Element)this, (Object)object);
    }

    public ORID getIdentity() {
        return this.rawElement.getIdentity();
    }

    public <T extends ORecord> T getRecord() {
        return (T)this.rawElement;
    }

    public void lock(boolean iExclusive) {
        this.rawElement.lock(iExclusive);
    }

    public boolean isLocked() {
        return this.rawElement.isLocked();
    }

    public OStorage.LOCKING_STRATEGY lockingStrategy() {
        return this.rawElement.lockingStrategy();
    }

    public void unlock() {
        this.rawElement.unlock();
    }

    public int compareTo(OIdentifiable o) {
        return this.rawElement.compareTo((Object)o);
    }

    public int compare(OIdentifiable o1, OIdentifiable o2) {
        return this.rawElement.compare((Object)o1, (Object)o2);
    }
}

