/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.executor;

import com.orientechnologies.common.concur.resource.OPartitionedObjectPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OScriptExecutor;
import com.orientechnologies.orient.core.command.script.OScriptInjection;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.command.script.OScriptResultHandler;
import com.orientechnologies.orient.core.command.script.formatter.OGroovyScriptFormatter;
import com.orientechnologies.orient.core.command.script.formatter.OScriptFormatter;
import com.orientechnologies.orient.core.command.script.transformer.result.OResultTransformer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngineFactory;
import org.apache.tinkerpop.gremlin.jsr223.CachedGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.orientdb.OrientEdge;
import org.apache.tinkerpop.gremlin.orientdb.OrientElement;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientVertex;
import org.apache.tinkerpop.gremlin.orientdb.OrientVertexProperty;
import org.apache.tinkerpop.gremlin.orientdb.executor.OGremlinExecutionPlan;
import org.apache.tinkerpop.gremlin.orientdb.executor.OGremlinScriptResultSet;
import org.apache.tinkerpop.gremlin.orientdb.executor.transformer.OElementTransformer;
import org.apache.tinkerpop.gremlin.orientdb.executor.transformer.OTraversalMetricTransformer;
import org.apache.tinkerpop.gremlin.orientdb.executor.transformer.OrientPropertyTransformer;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalExplanation;

public class OCommandGremlinExecutor
implements OScriptExecutor,
OScriptInjection,
OScriptResultHandler {
    public static final String GREMLIN_GROOVY = "gremlin-groovy";
    private final OScriptManager scriptManager;
    private GremlinGroovyScriptEngineFactory factory = new GremlinGroovyScriptEngineFactory();

    public OCommandGremlinExecutor(OScriptManager scriptManager) {
        this.factory.setCustomizerManager((GremlinScriptEngineManager)new CachedGremlinScriptEngineManager());
        this.scriptManager = scriptManager;
        this.initCustomTransformer(scriptManager);
        scriptManager.registerInjection((OScriptInjection)this);
        scriptManager.registerFormatter(GREMLIN_GROOVY, (OScriptFormatter)new OGroovyScriptFormatter());
        scriptManager.registerEngine(GREMLIN_GROOVY, (ScriptEngineFactory)this.factory);
        scriptManager.registerResultHandler(GREMLIN_GROOVY, (OScriptResultHandler)this);
    }

    private void initCustomTransformer(OScriptManager scriptManager) {
        scriptManager.getTransformer().registerResultTransformer(DefaultTraversalMetrics.class, (OResultTransformer)new OTraversalMetricTransformer());
        scriptManager.getTransformer().registerResultTransformer(OrientEdge.class, (OResultTransformer)new OElementTransformer());
        scriptManager.getTransformer().registerResultTransformer(OrientVertex.class, (OResultTransformer)new OElementTransformer());
        scriptManager.getTransformer().registerResultTransformer(OrientElement.class, (OResultTransformer)new OElementTransformer());
        scriptManager.getTransformer().registerResultTransformer(OrientVertexProperty.class, (OResultTransformer)new OrientPropertyTransformer());
    }

    public OResultSet execute(ODatabaseDocumentInternal database, String script, Object ... params) {
        throw new UnsupportedOperationException("");
    }

    public OResultSet execute(ODatabaseDocumentInternal iDatabase, String iText, Map params) {
        OPartitionedObjectPool.PoolEntry<ScriptEngine> entry = null;
        try {
            entry = this.acquireGremlinEngine(this.acquireGraph((ODatabaseDocument)iDatabase));
            ScriptEngine engine = (ScriptEngine)entry.object;
            this.bindParameters(engine, params);
            Object eval = engine.eval(iText);
            if (eval instanceof Traversal) {
                Traversal result = (Traversal)eval;
                OGremlinScriptResultSet oGremlinScriptResultSet = new OGremlinScriptResultSet(result, this.scriptManager.getTransformer(), true);
                return oGremlinScriptResultSet;
            }
            if (eval instanceof TraversalExplanation) {
                OInternalResultSet resultSet = new OInternalResultSet();
                resultSet.setPlan((OExecutionPlan)new OGremlinExecutionPlan((TraversalExplanation)eval));
                OResultInternal item = new OResultInternal();
                item.setProperty("executionPlan", (Object)((TraversalExplanation)eval).prettyPrint());
                resultSet.add((OResult)item);
                OInternalResultSet oInternalResultSet = resultSet;
                return oInternalResultSet;
            }
            OInternalResultSet resultSet = new OInternalResultSet();
            OResultInternal item = new OResultInternal();
            item.setProperty("value", eval);
            OInternalResultSet oInternalResultSet = resultSet;
            return oInternalResultSet;
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OCommandExecutionException("Error on execution of the GREMLIN script"), (Throwable)e);
        }
        finally {
            if (entry != null) {
                this.releaseGremlinEngine(iDatabase.getName(), entry);
            }
        }
    }

    protected final OPartitionedObjectPool.PoolEntry<ScriptEngine> acquireGremlinEngine(OrientGraph graph) {
        OPartitionedObjectPool.PoolEntry entry = this.scriptManager.acquireDatabaseEngine(graph.getRawDatabase().getName(), GREMLIN_GROOVY);
        ScriptEngine engine = (ScriptEngine)entry.object;
        Bindings bindings = engine.getBindings(100);
        this.bindGraph(graph, bindings);
        return entry;
    }

    protected void releaseGremlinEngine(String dbName, OPartitionedObjectPool.PoolEntry<ScriptEngine> engine) {
        this.scriptManager.releaseDatabaseEngine(GREMLIN_GROOVY, dbName, engine);
    }

    private void bindGraph(OrientGraph graph, Bindings bindings) {
        bindings.put("graph", (Object)graph);
        bindings.put("g", (Object)graph.traversal());
    }

    private void unbindGraph(Bindings bindings) {
        bindings.put("graph", (Object)null);
        bindings.put("g", (Object)null);
    }

    public void bindParameters(ScriptEngine iEngine, Map<Object, Object> iParameters) {
        if (iParameters != null && !iParameters.isEmpty()) {
            for (Map.Entry<Object, Object> param : iParameters.entrySet()) {
                String paramName = param.getKey().toString().trim();
                iEngine.getBindings(100).put(paramName, param.getValue());
            }
        }
    }

    public OrientGraph acquireGraph(final ODatabaseDocument database) {
        return new OrientGraph(null, database, (Configuration)new BaseConfiguration(){
            {
                this.setProperty(OrientGraph.CONFIG_TRANSACTIONAL, database.getTransaction().isActive());
            }
        }, null, null);
    }

    public String getEngineVersion() {
        return this.factory.getEngineVersion();
    }

    public void bind(ScriptEngine engine, Bindings binding, ODatabaseDocument database) {
        OrientGraph graph = this.acquireGraph(database);
        this.bindGraph(graph, binding);
    }

    public void unbind(ScriptEngine engine, Bindings binding) {
        this.unbindGraph(binding);
    }

    public Object handle(Object result, ScriptEngine engine, Bindings binding, ODatabaseDocument database) {
        return result;
    }
}

