/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.orientdb.traversal.step.map.OrientClassCountStep;
import org.apache.tinkerpop.gremlin.orientdb.traversal.step.sideEffect.OrientGraphStep;
import org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization.OrientGraphStepStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public class OrientGraphCountStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final OrientGraphCountStrategy INSTANCE = new OrientGraphCountStrategy();

    private OrientGraphCountStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!(traversal.getParent() instanceof EmptyStep) || TraversalHelper.onGraphComputer(traversal)) {
            return;
        }
        List steps = traversal.getSteps();
        if (steps.size() < 2) {
            return;
        }
        Step startStep = traversal.getStartStep();
        Step endStep = traversal.getEndStep();
        if (steps.size() == 2 && startStep instanceof OrientGraphStep && endStep instanceof CountGlobalStep) {
            OrientGraphStep step = (OrientGraphStep)startStep;
            if (step.getHasContainers().size() == 1) {
                Optional<Object> className = step.getHasContainers().stream().filter(f -> ((HasContainer)f).getKey().equals("~label") && ((HasContainer)f).getBiPredicate() instanceof Compare).map(f -> ((HasContainer)f).getValue().toString()).findFirst();
                if (className.isPresent()) {
                    TraversalHelper.removeAllSteps(traversal);
                    traversal.addStep(new OrientClassCountStep(traversal, (String)className.get()));
                }
            } else if (step.getHasContainers().size() == 0) {
                TraversalHelper.removeAllSteps(traversal);
                traversal.addStep(new OrientClassCountStep(traversal, step));
            }
        }
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return Collections.singleton(OrientGraphStepStrategy.class);
    }

    public static OrientGraphCountStrategy instance() {
        return INSTANCE;
    }
}

