/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OEdgeDelegate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.orientdb.OGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientElement;
import org.apache.tinkerpop.gremlin.orientdb.StreamUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class OrientEdge
extends OrientElement
implements Edge {
    private static final List<String> INTERNAL_FIELDS = Arrays.asList("@rid", "@class", "in", "out");
    protected OVertex vOut;
    protected OVertex vIn;
    protected String label;

    public OrientEdge(OGraph graph, OEdge rawElement, OVertex out, OVertex in, String iLabel) {
        super(graph, (OElement)rawElement);
        this.vOut = (OVertex)Preconditions.checkNotNull((Object)out, (Object)("out vertex on edge " + rawElement));
        this.vIn = (OVertex)Preconditions.checkNotNull((Object)in, (Object)("out vertex on edge " + rawElement));
        this.label = (String)Preconditions.checkNotNull((Object)iLabel, (Object)("label on edge " + rawElement));
    }

    public OrientEdge(OGraph graph, OEdge rawEdge, String label) {
        this(graph, rawEdge, rawEdge.getVertex(ODirection.OUT), rawEdge.getVertex(ODirection.IN), label);
    }

    public OrientEdge(OGraph graph, OIdentifiable identifiable) {
        this(graph, (OEdge)new ODocument(identifiable.getIdentity()).asEdge().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot get an Edge for identity %s", identifiable))));
    }

    public OrientEdge(OGraph graph, OEdge rawEdge) {
        this(graph, rawEdge, ((OClass)rawEdge.getSchemaType().get()).getName());
    }

    public static OIdentifiable getConnection(ODocument iEdgeRecord, Direction iDirection) {
        return (OIdentifiable)iEdgeRecord.rawField(iDirection == Direction.OUT ? "out" : "in");
    }

    protected static OEdge createRawElement(OGraph graph, String label) {
        String className = graph.createEdgeClass(label);
        OEdgeDelegate delegate = new OEdgeDelegate(new ODocument(className));
        return delegate;
    }

    public Iterator<Vertex> vertices(Direction direction) {
        this.graph.tx().readWrite();
        switch (direction) {
            case OUT: {
                return this.graph.vertices(new Object[]{this.vOut.getIdentity()});
            }
            case IN: {
                return this.graph.vertices(new Object[]{this.vIn.getIdentity()});
            }
        }
        return this.graph.vertices(new Object[]{this.vOut.getIdentity(), this.vIn.getIdentity()});
    }

    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        Iterator properties = super.properties(propertyKeys);
        return StreamUtils.asStream(properties).filter(p -> !INTERNAL_FIELDS.contains(p.key())).map(p -> p).iterator();
    }

    @Override
    public OElement getRawElement() {
        return (OElement)this.rawElement.asEdge().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot get an Edge for identity %s", this.rawElement.getIdentity())));
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }
}

