/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.orientdb.OrientElement;
import org.apache.tinkerpop.gremlin.orientdb.VertexEdgeListWrapper;
import org.apache.tinkerpop.gremlin.orientdb.VertexEdgeSetWrapper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class OrientProperty<V>
implements Property<V> {
    protected String key;
    protected V value;
    protected Object wrappedValue;
    protected OrientElement element;

    public OrientProperty(String key, V value, OrientElement element) {
        this.key = key;
        this.value = value;
        this.element = element;
        this.wrappedValue = this.wrapIntoGraphElement(value);
    }

    private Object wrapIntoGraphElement(V value) {
        Object result = value;
        if (result instanceof ORID) {
            result = ((ORID)result).getRecord();
        }
        if (result instanceof OElement) {
            if (((OElement)result).isVertex()) {
                result = this.element.getGraph().elementFactory().wrapVertex((OVertex)((OElement)result).asVertex().get());
            } else if (((OElement)value).isEdge()) {
                result = this.element.getGraph().elementFactory().wrapEdge((OEdge)((OElement)result).asEdge().get());
            }
        }
        if (result instanceof Collection && this.containsGraphElements((Collection)result)) {
            if (result instanceof List) {
                result = new VertexEdgeListWrapper((List)result, this.element);
            } else if (result instanceof Set) {
                result = new VertexEdgeSetWrapper((Set)result, this.element);
            }
        }
        return result;
    }

    private boolean containsGraphElements(Collection result) {
        for (Object o : result) {
            if (!(o instanceof OElement) || !((OElement)o).isVertex() && !((OElement)o).isVertex()) continue;
            return true;
        }
        return false;
    }

    public String key() {
        return this.key;
    }

    public V value() throws NoSuchElementException {
        return (V)this.wrappedValue;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public Element element() {
        return this.element;
    }

    public void remove() {
        OElement doc = this.element.getRawElement();
        doc.removeProperty(this.key);
        doc.save();
        this.value = null;
        this.wrappedValue = null;
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }

    public final boolean equals(Object object) {
        return ElementHelper.areEqual((Property)this, (Object)object);
    }

    public int hashCode() {
        return ElementHelper.hashCode((Property)this);
    }
}

