/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.AbstractTransaction;
import org.apache.tinkerpop.gremlin.structure.util.TransactionException;

public class OrientTransaction
extends AbstractTransaction {
    protected OrientGraph graph;
    protected Consumer<Transaction> readWriteConsumerInternal = Transaction.READ_WRITE_BEHAVIOR.AUTO;
    protected Consumer<Transaction> closeConsumerInternal = Transaction.CLOSE_BEHAVIOR.ROLLBACK;
    protected final List<Consumer<Transaction.Status>> transactionListeners = new CopyOnWriteArrayList<Consumer<Transaction.Status>>();

    public OrientTransaction(OrientGraph graph) {
        super((Graph)graph);
        this.graph = graph;
    }

    public boolean isOpen() {
        return this.tx().isActive();
    }

    public Transaction onReadWrite(Consumer<Transaction> consumer) {
        this.readWriteConsumerInternal = Optional.ofNullable(consumer).orElseThrow(Transaction.Exceptions::onReadWriteBehaviorCannotBeNull);
        return this;
    }

    public Transaction onClose(Consumer<Transaction> consumer) {
        this.closeConsumerInternal = Optional.ofNullable(consumer).orElseThrow(Transaction.Exceptions::onReadWriteBehaviorCannotBeNull);
        return this;
    }

    public void addTransactionListener(Consumer<Transaction.Status> listener) {
        this.transactionListeners.add(listener);
    }

    public void removeTransactionListener(Consumer<Transaction.Status> listener) {
        this.transactionListeners.remove(listener);
    }

    public void clearTransactionListeners() {
        this.transactionListeners.clear();
    }

    protected void doOpen() {
        this.db().begin();
    }

    protected void doCommit() throws TransactionException {
        this.db().commit();
    }

    protected void doClose() {
        this.closeConsumerInternal.accept((Transaction)this);
    }

    protected void doReadWrite() {
        this.readWriteConsumerInternal.accept((Transaction)this);
    }

    protected void fireOnCommit() {
        this.transactionListeners.forEach(c -> c.accept(Transaction.Status.COMMIT));
    }

    protected void fireOnRollback() {
        this.transactionListeners.forEach(c -> c.accept(Transaction.Status.ROLLBACK));
    }

    protected void doRollback() throws TransactionException {
        this.db().rollback();
    }

    protected OTransaction tx() {
        return this.graph.getRawDatabase().getTransaction();
    }

    protected ODatabaseDocument db() {
        return this.graph.getRawDatabase();
    }
}

