/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.orientdb.OrientElement;

public class VertexEdgeListWrapper
implements List {
    private final List wrapped;
    private final OrientElement parent;

    public VertexEdgeListWrapper(List wrapped, OrientElement parentElement) {
        this.wrapped = wrapped;
        this.parent = parentElement;
    }

    private Object unbox(Object next) {
        if (next instanceof OrientElement) {
            return ((OrientElement)next).getRawElement();
        }
        return next;
    }

    private Object box(Object elem) {
        if (elem instanceof ORID) {
            elem = ((ORID)elem).getRecord();
        }
        if (elem instanceof OElement) {
            if (((OElement)elem).isVertex()) {
                elem = this.parent.getGraph().elementFactory().wrapVertex((OVertex)((OElement)elem).asVertex().get());
            } else if (((OElement)elem).isEdge()) {
                elem = this.parent.getGraph().elementFactory().wrapEdge((OEdge)((OElement)elem).asEdge().get());
            }
        }
        return elem;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof OrientElement && this.wrapped.contains(((OrientElement)o).getRawElement())) {
            return true;
        }
        return this.wrapped.contains(o);
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            Iterator baseIter;
            {
                this.baseIter = VertexEdgeListWrapper.this.wrapped.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseIter.hasNext();
            }

            public Object next() {
                return VertexEdgeListWrapper.this.box(this.baseIter.next());
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.wrapped.stream().map(x -> this.box(x)).toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.wrapped.stream().map(x -> this.box(x)).toArray();
    }

    @Override
    public boolean add(Object o) {
        return this.wrapped.add(this.unbox(o));
    }

    @Override
    public boolean remove(Object o) {
        return this.wrapped.remove(this.unbox(o));
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.wrapped.containsAll(c.stream().map(x -> this.unbox(x)).collect(Collectors.toList()));
    }

    @Override
    public boolean addAll(Collection c) {
        boolean changed = false;
        for (Object o : c) {
            changed = changed || this.wrapped.add(this.unbox(o));
        }
        return changed;
    }

    public boolean addAll(int index, Collection c) {
        for (Object o : c) {
            this.wrapped.add(index++, this.unbox(o));
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean changed = false;
        for (Object o : c) {
            changed = changed || this.wrapped.remove(this.unbox(o));
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.wrapped.retainAll(c.stream().map(x -> this.unbox(x)).collect(Collectors.toList()));
    }

    public void replaceAll(UnaryOperator operator) {
        this.wrapped.replaceAll(operator);
    }

    public void sort(Comparator c) {
        this.wrapped.sort(c);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    public Object get(int index) {
        return this.box(this.wrapped.get(index));
    }

    public Object set(int index, Object element) {
        return this.wrapped.set(index, this.unbox(element));
    }

    public void add(int index, Object element) {
        this.wrapped.add(index, this.unbox(element));
    }

    public Object remove(int index) {
        return this.wrapped.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.wrapped.indexOf(this.unbox(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.wrapped.lastIndexOf(this.unbox(o));
    }

    public ListIterator listIterator() {
        return new ListIterator(){
            ListIterator baseIter;
            {
                this.baseIter = VertexEdgeListWrapper.this.wrapped.listIterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseIter.hasNext();
            }

            @Override
            public Object next() {
                return VertexEdgeListWrapper.this.box(this.baseIter.next());
            }

            @Override
            public boolean hasPrevious() {
                return this.baseIter.hasNext();
            }

            public Object previous() {
                return VertexEdgeListWrapper.this.box(this.baseIter.previous());
            }

            @Override
            public int nextIndex() {
                return this.baseIter.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.baseIter.previousIndex();
            }

            @Override
            public void remove() {
                this.baseIter.remove();
            }

            public void set(Object o) {
                this.baseIter.set(VertexEdgeListWrapper.this.unbox(o));
            }

            public void add(Object o) {
                this.baseIter.add(VertexEdgeListWrapper.this.unbox(o));
            }
        };
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            ListIterator baseIter;
            {
                this.baseIter = VertexEdgeListWrapper.this.wrapped.listIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this.baseIter.hasNext();
            }

            @Override
            public Object next() {
                return VertexEdgeListWrapper.this.box(this.baseIter.next());
            }

            @Override
            public boolean hasPrevious() {
                return this.baseIter.hasNext();
            }

            public Object previous() {
                return VertexEdgeListWrapper.this.box(this.baseIter.previous());
            }

            @Override
            public int nextIndex() {
                return this.baseIter.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.baseIter.previousIndex();
            }

            @Override
            public void remove() {
                this.baseIter.remove();
            }

            public void set(Object o) {
                this.baseIter.set(VertexEdgeListWrapper.this.unbox(o));
            }

            public void add(Object o) {
                this.baseIter.add(VertexEdgeListWrapper.this.unbox(o));
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        return new VertexEdgeListWrapper(this.wrapped.subList(fromIndex, toIndex), this.parent);
    }

    @Override
    public Spliterator spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate filter) {
        return this.wrapped.removeIf(filter);
    }

    @Override
    public Stream stream() {
        return this.wrapped.stream().map(x -> this.box(x));
    }

    @Override
    public Stream parallelStream() {
        return this.wrapped.parallelStream().map(x -> this.box(x));
    }

    @Override
    public void forEach(Consumer action) {
        this.wrapped.forEach(action);
    }
}

